/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.listeners.backpack;

import java.util.UUID;
import me.ziomalu.api.gui.Page;
import me.ziomalu.api.gui.button.Button;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import pl.ziomalu.backpackplus.BackpackManager;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.crafting.CraftingManager;
import pl.ziomalu.backpackplus.inventoryholders.ChangeCraftingInventoryHolder;

public class ChangeBackpackCraftingListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void onCraftingInventoryClose(InventoryCloseEvent e) {
        if (e.getInventory().getHolder() instanceof ChangeCraftingInventoryHolder) {
            UUID playerUniqueId = e.getPlayer().getUniqueId();
            if (CraftingManager.getInstance().isCraftingEditor(playerUniqueId)) {
                Bukkit.getScheduler().runTask((Plugin)BackpackPlus.getInstance(), () -> e.getPlayer().openInventory(CraftingManager.getInstance().getEditorInventory(playerUniqueId)));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBackpackInventoryClick(InventoryClickEvent e) {
        InventoryHolder inventoryHolder = e.getInventory().getHolder();
        if (inventoryHolder instanceof ChangeCraftingInventoryHolder) {
            ChangeCraftingInventoryHolder changeCraftingInventoryHolder = (ChangeCraftingInventoryHolder)inventoryHolder;
            int rawSlot = e.getRawSlot();
            if (e.getClickedInventory() == null) {
                return;
            }
            if (!(e.getClickedInventory().getHolder() instanceof ChangeCraftingInventoryHolder)) {
                return;
            }
            switch (rawSlot) {
                case 3: 
                case 4: 
                case 5: 
                case 12: 
                case 13: 
                case 14: 
                case 21: 
                case 22: 
                case 23: {
                    break;
                }
                default: {
                    e.setCancelled(true);
                    Page page = BackpackManager.getInstance().getBackpackSettingsByTier(changeCraftingInventoryHolder.backpackId()).getEditCraftingPage();
                    if (page == null) {
                        return;
                    }
                    Button button = page.getButton(e.getSlot(), e.getClick());
                    if (button == null) break;
                    button.onButtonClick(page, (Player)e.getWhoClicked(), (Event)e);
                }
            }
        }
    }
}

