/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.listeners.player;

import java.util.ArrayList;
import me.ziomalu.api.cache.Cache;
import me.ziomalu.api.cache.CacheKeyManager;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import pl.ziomalu.backpackplus.BackpackManager;
import pl.ziomalu.backpackplus.database.DatabaseManager;
import pl.ziomalu.backpackplus.objects.PlayerDeathItems;
import pl.ziomalu.backpackplus.settings.Settings;

public class PlayerDeathListener
implements Listener {
    private final BackpackManager backpackManager = BackpackManager.getInstance();

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent e) {
        Player player = e.getEntity();
        if (!Settings.KEEP_BACKPACK_AFTER_DEATH) {
            return;
        }
        if (e.getKeepInventory()) {
            return;
        }
        if (player.getGameMode() != GameMode.SURVIVAL) {
            return;
        }
        if (Settings.KEEP_BACKPACK_AFTER_DEATH_PERMISSION != null && !Settings.KEEP_BACKPACK_AFTER_DEATH_PERMISSION.isEmpty() && !player.hasPermission(Settings.KEEP_BACKPACK_AFTER_DEATH_PERMISSION)) {
            return;
        }
        if (e.getDrops().isEmpty()) {
            return;
        }
        ArrayList<ItemStack> dropContent = new ArrayList<ItemStack>(e.getDrops());
        e.getDrops().removeIf(this.backpackManager::isBackpackStack);
        dropContent.removeIf(item -> !this.backpackManager.isBackpackStack((ItemStack)item));
        PlayerDeathItems deathItems = new PlayerDeathItems(player.getUniqueId(), dropContent);
        Cache.put(CacheKeyManager.deathItems(player.getUniqueId()), deathItems);
        String content = deathItems.getContent();
        DatabaseManager.getInstance().getDatabase().savePlayerDeathItems(player.getUniqueId(), content);
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent e) {
        Player player = e.getPlayer();
        PlayerDeathItems cachedDeathItems = (PlayerDeathItems)Cache.get(CacheKeyManager.deathItems(player.getUniqueId()));
        if (cachedDeathItems != null) {
            this.restoreItemsToPlayer(player, cachedDeathItems);
            Cache.remove(CacheKeyManager.deathItems(player.getUniqueId()));
            DatabaseManager.getInstance().getDatabase().deletePlayerDeathItems(player.getUniqueId());
            return;
        }
        String serializedDeathItems = DatabaseManager.getInstance().getDatabase().getPlayerAndDeleteDeathItems(player.getUniqueId());
        if (serializedDeathItems == null) {
            return;
        }
        PlayerDeathItems deathItems = PlayerDeathItems.fromContent(player.getUniqueId(), serializedDeathItems);
        if (deathItems != null) {
            this.restoreItemsToPlayer(player, deathItems);
            Cache.remove(CacheKeyManager.deathItems(player.getUniqueId()));
        }
    }

    private void restoreItemsToPlayer(Player player, PlayerDeathItems deathItems) {
        player.getInventory().addItem(deathItems.getItems().toArray(new ItemStack[0]));
    }
}

