/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.listeners.player;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import pl.ziomalu.backpackplus.BackpackManager;
import pl.ziomalu.backpackplus.events.BackpackCreateEvent;
import pl.ziomalu.backpackplus.events.PreBackpackOpenEvent;
import pl.ziomalu.backpackplus.language.LanguageManager;
import pl.ziomalu.backpackplus.settings.BackpackSettings;
import pl.ziomalu.backpackplus.settings.Settings;
import pl.ziomalu.backpackplus.utils.Text;
import pl.ziomalu.backpackplus.utils.Utils;

public class PlayerInteractionListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (e.getItem() == null) {
            return;
        }
        if (!e.getItem().hasItemMeta()) {
            return;
        }
        if (!BackpackManager.getInstance().isBackpackStack(e.getItem())) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_AIR && e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack backpackStack = e.getItem();
        Player player = e.getPlayer();
        if (BackpackManager.getInstance().playerHasCooldown(player.getUniqueId(), Settings.BACKPACK_COOLDOWN)) {
            LanguageManager.sendMessage(player, "cooldown-message");
            e.setCancelled(true);
            return;
        }
        if (BackpackManager.getInstance().isBackpackStack(e.getPlayer().getInventory().getItemInMainHand()) && BackpackManager.getInstance().isBackpackStack(e.getPlayer().getInventory().getItemInOffHand()) && e.getHand() != EquipmentSlot.HAND) {
            e.setCancelled(true);
            return;
        }
        e.setCancelled(true);
        int backpackTier = BackpackManager.getInstance().getBackpackTier(e.getItem());
        BackpackSettings backpackSettings = BackpackManager.getInstance().getBackpackSettingsByTier(backpackTier);
        if (Settings.PERMISSIONS_TO_USE_BACKPACK && !backpackSettings.getData().getUsePermission().isEmpty() && !player.hasPermission(backpackSettings.getData().getUsePermission())) {
            LanguageManager.sendMessage(player, "backpack-no-permission-use");
            e.setCancelled(true);
            return;
        }
        if (!BackpackManager.getInstance().backpackIsUsed(backpackStack)) {
            e.setCancelled(true);
            int maxBackpackAmount = Settings.LIMIT_BACKPACK_PER_INVENTORY_AMOUNT;
            if (Settings.LIMIT_BACKPACK_PER_INVENTORY && Utils.playerHasBackpackInInventory(player, maxBackpackAmount)) {
                if (maxBackpackAmount > 1) {
                    String message = LanguageManager.getInstance().getString("multiple-backpack-per-inventory").replace("%amount%", String.valueOf(maxBackpackAmount));
                    player.sendMessage(Text.setColour(message));
                } else {
                    LanguageManager.sendMessage(player, "one-backpack-per-inventory");
                }
                return;
            }
            BackpackCreateEvent backpackCreateEvent = new BackpackCreateEvent(player, backpackStack);
            Bukkit.getPluginManager().callEvent((Event)backpackCreateEvent);
            return;
        }
        UUID backpackUniqueId = BackpackManager.getInstance().getBackpackUniqueId(e.getItem());
        if (backpackUniqueId == null) {
            e.setCancelled(true);
            Utils.debugLogToConsole("[PlayerInteractionListener] [onPlayerInteract] BackpackUniqueId is null");
            return;
        }
        this.triggerBackpackPreOpenEvent(backpackUniqueId, backpackTier, e.getItem(), player);
        BackpackManager.getInstance().addPlayerCooldown(player.getUniqueId());
    }

    @EventHandler
    public void onClickEntity(PlayerInteractEntityEvent e) {
        ItemStack item = e.getPlayer().getInventory().getItem(e.getHand());
        if (item == null) {
            return;
        }
        if (!item.hasItemMeta()) {
            return;
        }
        if (!BackpackManager.getInstance().isBackpackStack(item)) {
            return;
        }
        Player player = e.getPlayer();
        Entity entity = e.getRightClicked();
        if (player.isSneaking() && (entity.getType().equals((Object)EntityType.ITEM_FRAME) || entity.getType().equals((Object)EntityType.GLOW_ITEM_FRAME))) {
            return;
        }
        if (BackpackManager.getInstance().playerHasCooldown(player.getUniqueId(), Settings.BACKPACK_COOLDOWN)) {
            Utils.sendMessage(player, LanguageManager.getInstance().getString("cooldown-message"));
            e.setCancelled(true);
            return;
        }
        if (BackpackManager.getInstance().isBackpackStack(e.getPlayer().getInventory().getItemInMainHand()) && BackpackManager.getInstance().isBackpackStack(e.getPlayer().getInventory().getItemInOffHand()) && e.getHand() != EquipmentSlot.HAND) {
            e.setCancelled(true);
            return;
        }
        int backpackTier = BackpackManager.getInstance().getBackpackTier(item);
        BackpackSettings backpackSettings = BackpackManager.getInstance().getBackpackSettingsByTier(backpackTier);
        if (Settings.PERMISSIONS_TO_USE_BACKPACK && !backpackSettings.getData().getUsePermission().isEmpty() && !player.hasPermission(backpackSettings.getData().getUsePermission())) {
            LanguageManager.sendMessage(player, "backpack-no-permission-use");
            e.setCancelled(true);
            return;
        }
        if (!BackpackManager.getInstance().backpackIsUsed(item)) {
            e.setCancelled(true);
            int maxBackpackAmount = Settings.LIMIT_BACKPACK_PER_INVENTORY_AMOUNT;
            if (Settings.LIMIT_BACKPACK_PER_INVENTORY && Utils.playerHasBackpackInInventory(e.getPlayer(), maxBackpackAmount)) {
                if (maxBackpackAmount > 1) {
                    String message = LanguageManager.getInstance().getString("multiple-backpack-per-inventory").replace("%amount%", String.valueOf(maxBackpackAmount));
                    Utils.sendPlayerOnceMessage(player, message, 10);
                } else {
                    Utils.sendPlayerOnceMessage(player, LanguageManager.getInstance().getString("one-backpack-per-inventory"), 10);
                }
                return;
            }
            BackpackCreateEvent backpackCreateEvent = new BackpackCreateEvent(player, item);
            Bukkit.getPluginManager().callEvent((Event)backpackCreateEvent);
            return;
        }
        UUID backpackUniqueId = BackpackManager.getInstance().getBackpackUniqueId(item);
        if (backpackUniqueId == null) {
            e.setCancelled(true);
            Utils.debugLogToConsole("[PlayerInteractionListener] [onClickEntity] BackpackUniqueId is null");
            return;
        }
        e.setCancelled(true);
        this.triggerBackpackPreOpenEvent(backpackUniqueId, backpackTier, item, player);
        BackpackManager.getInstance().addPlayerCooldown(player.getUniqueId());
    }

    private void triggerBackpackPreOpenEvent(UUID backpackUniqueId, int backpackTier, ItemStack backpackStack, Player player) {
        PreBackpackOpenEvent event = new PreBackpackOpenEvent(backpackUniqueId, backpackTier, backpackStack, player, false);
        Bukkit.getPluginManager().callEvent((Event)event);
    }
}

