/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.listeners.player;

import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import pl.ziomalu.backpackplus.BackpackManager;
import pl.ziomalu.backpackplus.language.LanguageManager;
import pl.ziomalu.backpackplus.settings.Settings;
import pl.ziomalu.backpackplus.utils.Utils;

public class PlayerItemMoveListener
implements Listener {
    @EventHandler
    public void onItemMove(InventoryClickEvent e) {
        if (!Settings.LIMIT_BACKPACK_PER_INVENTORY) {
            return;
        }
        Player player = (Player)e.getWhoClicked();
        if (e.getCurrentItem() == null) {
            return;
        }
        if (e.getClickedInventory() == null) {
            return;
        }
        if (e.getClickedInventory().getType() == InventoryType.PLAYER) {
            return;
        }
        if (e.getClickedInventory().getType() != InventoryType.PLAYER && (e.getAction().equals((Object)InventoryAction.DROP_ALL_SLOT) || e.getAction().equals((Object)InventoryAction.DROP_ONE_SLOT))) {
            return;
        }
        if (!BackpackManager.getInstance().isBackpackStack(e.getCurrentItem())) {
            return;
        }
        int maxBackpackAmount = Settings.LIMIT_BACKPACK_PER_INVENTORY_AMOUNT;
        if (Utils.playerHasBackpackInInventory(player, maxBackpackAmount)) {
            if (maxBackpackAmount > 1) {
                String message = LanguageManager.getInstance().getString("multiple-backpack-per-inventory").replace("%amount%", String.valueOf(maxBackpackAmount));
                Utils.sendPlayerOnceMessage(player, message, 10);
            } else {
                Utils.sendPlayerOnceMessage(player, LanguageManager.getInstance().getString("one-backpack-per-inventory"), 10);
            }
            e.setCancelled(true);
        }
    }
}

