/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.listeners.player;

import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import pl.ziomalu.backpackplus.BackpackManager;
import pl.ziomalu.backpackplus.language.LanguageManager;
import pl.ziomalu.backpackplus.settings.Settings;
import pl.ziomalu.backpackplus.utils.Text;
import pl.ziomalu.backpackplus.utils.Utils;

public class PlayerItemPickupListener
implements Listener {
    @EventHandler
    public void onEntityPickupItem(EntityPickupItemEvent e) {
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!Settings.LIMIT_BACKPACK_PER_INVENTORY) {
            return;
        }
        if (!BackpackManager.getInstance().isBackpackStack(e.getItem().getItemStack())) {
            return;
        }
        int maxBackpackAmount = Settings.LIMIT_BACKPACK_PER_INVENTORY_AMOUNT;
        if (Utils.playerHasBackpackInInventory(player, maxBackpackAmount)) {
            if (maxBackpackAmount > 1) {
                String message = LanguageManager.getInstance().getString("multiple-backpack-per-inventory").replace("%amount%", String.valueOf(maxBackpackAmount));
                Utils.sendPlayerOnceMessage(player, message, 10);
            } else {
                Utils.sendPlayerOnceMessage(player, Text.setColour(LanguageManager.getInstance().getString("one-backpack-per-inventory")), 10);
            }
            e.setCancelled(true);
        }
    }
}

