/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.listeners.player;

import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.metadata.MetadataValue;
import pl.ziomalu.backpackplus.BackpackManager;
import pl.ziomalu.backpackplus.backpackcontent.Backpack;
import pl.ziomalu.backpackplus.database.DatabaseManager;
import pl.ziomalu.backpackplus.utils.Utils;

public class PlayerLeaveListener
implements Listener {
    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        List<Backpack> playerUsedBackpacks;
        Player player = e.getPlayer();
        if (player.hasMetadata("BackpackPlus")) {
            Backpack backpack2 = (Backpack)((MetadataValue)player.getMetadata("BackpackPlus").get(0)).value();
            if (backpack2 == null) {
                return;
            }
            if (backpack2.getLastPlayerUniqueId().equals(player.getUniqueId())) {
                backpack2.closeAndSaveBackpack(false);
                backpack2.setLocked(false);
                DatabaseManager.getInstance().getDatabase().updateBackpackOpenState(backpack2.getBackpackUniqueId(), false);
                BackpackManager.getInstance().removeBackpackFromMap(backpack2.getBackpackUniqueId());
            }
        }
        if ((playerUsedBackpacks = BackpackManager.getInstance().findBackpacksByLastPlayer(player.getUniqueId())).isEmpty()) {
            Utils.debugLogToConsole("[PlayerLeaveListener] (onPlayerQuit) player used backpacks is empty");
            return;
        }
        playerUsedBackpacks.forEach(backpack -> {
            if (backpack.getLastPlayerUniqueId().equals(player.getUniqueId())) {
                backpack.closeAndSaveBackpack(false);
                backpack.setLocked(false);
                BackpackManager.getInstance().removeBackpackFromMap(backpack.getBackpackUniqueId());
            }
        });
        BackpackManager.getInstance().removeBackpackUsedByPlayer(player.getUniqueId());
    }
}

