/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.objects;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import me.ziomalu.api.ItemUtil;
import org.bukkit.inventory.ItemStack;
import pl.ziomalu.backpackplus.BackpackPlus;

public class PlayerDeathItems {
    @NonNull
    private final UUID playerUniqueId;
    @NonNull
    private final List<ItemStack> items;

    public String getContent() {
        if (this.items.isEmpty()) {
            return null;
        }
        Gson gson = new Gson();
        return gson.toJson(this.items.stream().map(ItemUtil::itemToBase64).collect(Collectors.toList()));
    }

    public static PlayerDeathItems fromContent(UUID playerUniqueId, String json) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        Gson gson = new Gson();
        Type listType = new TypeToken<List<String>>(){}.getType();
        List serializedStrings = (List)gson.fromJson(json, listType);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (String serialized : serializedStrings) {
            try {
                ItemStack itemStack = ItemUtil.itemFromBase64(serialized);
                if (itemStack == null) continue;
                items.add(itemStack);
            }
            catch (IOException e) {
                BackpackPlus.getInstance().getLogger().warning("Error deserializing item: " + serialized);
            }
        }
        return new PlayerDeathItems(playerUniqueId, items);
    }

    @Generated
    public PlayerDeathItems(@NonNull UUID playerUniqueId, @NonNull List<ItemStack> items) {
        if (playerUniqueId == null) {
            throw new NullPointerException("playerUniqueId is marked non-null but is null");
        }
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        this.playerUniqueId = playerUniqueId;
        this.items = items;
    }

    @NonNull
    @Generated
    public UUID getPlayerUniqueId() {
        return this.playerUniqueId;
    }

    @NonNull
    @Generated
    public List<ItemStack> getItems() {
        return this.items;
    }
}

