/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.resourcepack;

import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.interfaces.Callback;
import pl.ziomalu.backpackplus.resourcepack.ResourcepackSettings;
import pl.ziomalu.backpackplus.resourcepack.listener.ResourcePackListener;
import pl.ziomalu.backpackplus.utils.Text;

public final class ResourcepackProvider {
    private static ResourcepackProvider instance;

    public ResourcepackProvider() {
        instance = this;
        new ResourcepackSettings(BackpackPlus.getInstance());
        ResourcepackSettings.getInstance().load();
        if (ResourcepackSettings.USE_RESOURCEPACK) {
            BackpackPlus.getInstance().getServer().getPluginManager().registerEvents((Listener)new ResourcePackListener(), (Plugin)BackpackPlus.getInstance());
        }
    }

    public void setPlayerResourcePack(Player player) throws Exception {
        String url = ResourcepackSettings.URL;
        byte[] hashBytes = ResourcepackProvider.getInstance().hexStringToByteArray(ResourcepackSettings.HASH);
        player.setResourcePack(url, hashBytes, Text.setColour(ResourcepackSettings.MESSAGE), ResourcepackSettings.FORCE);
    }

    public void applyResourcePackToAllPlayers() throws Exception {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        String url = ResourcepackSettings.URL;
        byte[] hashBytes = ResourcepackProvider.getInstance().hexStringToByteArray(ResourcepackSettings.HASH);
        Bukkit.getOnlinePlayers().forEach(player -> player.setResourcePack(url, hashBytes, Text.setColour(ResourcepackSettings.MESSAGE)));
    }

    public void setPlayerResourcePack(Player player, Callback callback) throws Exception {
        String url = ResourcepackSettings.URL;
        byte[] hashBytes = ResourcepackProvider.getInstance().hexStringToByteArray(ResourcepackSettings.HASH);
        player.setResourcePack(url, hashBytes, Text.setColour(ResourcepackSettings.MESSAGE), ResourcepackSettings.FORCE);
        callback.execute(player);
    }

    public String bytesToHex(byte[] bytes) {
        StringBuilder hexStringBuilder = new StringBuilder();
        for (byte b : bytes) {
            hexStringBuilder.append(String.format("%02x", b));
        }
        return hexStringBuilder.toString();
    }

    public byte[] hexStringToByteArray(String hexString) {
        int len = hexString.length();
        byte[] byteArray = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            byteArray[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return byteArray;
    }

    @Generated
    public static ResourcepackProvider getInstance() {
        return instance;
    }
}

