/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.resourcepack;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import me.ziomalu.api.config.ConfigValues;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.utils.Text;

public final class ResourcepackSettings
extends ConfigValues {
    private static ResourcepackSettings instance;
    public static String URL;
    public static String HASH;
    public static boolean FORCE;
    public static boolean USE_RESOURCEPACK;
    public static String MESSAGE;

    public ResourcepackSettings(JavaPlugin plugin) {
        super(plugin);
        instance = this;
    }

    public void load() {
        FileConfiguration configuration = BackpackPlus.getInstance().getConfig();
        Logger logger = BackpackPlus.getInstance().getLogger();
        if (!configuration.isSet("resource-pack-hash") || !configuration.isSet("resource-pack-url")) {
            logger.log(Level.WARNING, "=========================================");
            logger.log(Level.WARNING, "Resource pack hash or url not set, resourcepack requirement may not work");
            logger.log(Level.WARNING, "Site to post your resourcepack: https://mc-packs.net/");
            logger.log(Level.WARNING, "I place the default resourcepack Hash: 2d56276eb36465a60070dd5a670fc3fbdf1a9d0a URL: https://www.dropbox.com/scl/fi/rtx4hkfaxh3fzl2meg7ju/BackpackPlus_resourcepack_1_19_x-beyond.zip?rlkey=jp3jxtn4qdgzyq7yqqk1bg98p&st=tooq0mtd&dl=1");
            logger.log(Level.WARNING, "=========================================");
        }
        URL = this.getAndSaveIfNotExists("resource-pack-url", URL);
        HASH = this.getAndSaveIfNotExists("resource-pack-hash", HASH);
        FORCE = this.getAndSaveIfNotExists("force-resource-pack", true);
        USE_RESOURCEPACK = this.getAndSaveIfNotExists("use-resource-pack", true);
        if (this.getMissingFields() > 0) {
            this.save();
        }
        StringBuilder sb = new StringBuilder();
        List<String> messages = this.getAndSaveIfNotExists("resource-pack-message", List.of("&l&8[&6To play you must accept the server resourcepack&l&8]"));
        messages.forEach(str -> sb.append(Text.setColour(str)).append(messages.size() > 1 ? "\n" : ""));
        MESSAGE = sb.toString();
    }

    @Generated
    public static ResourcepackSettings getInstance() {
        return instance;
    }

    static {
        URL = "https://www.dropbox.com/scl/fi/rtx4hkfaxh3fzl2meg7ju/BackpackPlus_resourcepack_1_19_x-beyond.zip?rlkey=jp3jxtn4qdgzyq7yqqk1bg98p&st=tooq0mtd&dl=1";
        HASH = "2d56276eb36465a60070dd5a670fc3fbdf1a9d0a";
        FORCE = true;
        USE_RESOURCEPACK = true;
        MESSAGE = "&l&8[&6To play you must accept the server resourcepack&l&8]";
    }
}

