/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.settings;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.regex.Pattern;
import lombok.Generated;
import me.ziomalu.api.ItemUtil;
import me.ziomalu.api.gui.Page;
import me.ziomalu.api.gui.basic.BasicGuiItems;
import me.ziomalu.api.gui.basic.GlassColors;
import me.ziomalu.api.gui.button.Button;
import me.ziomalu.api.gui.button.ButtonActionKey;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.StringParser;
import pl.ziomalu.backpackplus.crafting.CraftingManager;
import pl.ziomalu.backpackplus.gui.backpack.settings.AllowedItemsGUI;
import pl.ziomalu.backpackplus.gui.backpack.settings.BackpackSettingsMainGUI;
import pl.ziomalu.backpackplus.inventoryholders.ChangeCraftingInventoryHolder;
import pl.ziomalu.backpackplus.items.BackpacksItems;
import pl.ziomalu.backpackplus.language.LanguageManager;
import pl.ziomalu.backpackplus.settings.BackpackSettingsData;
import pl.ziomalu.backpackplus.settings.Settings;
import pl.ziomalu.backpackplus.utils.Text;
import pl.ziomalu.backpackplus.utils.Utils;

public class BackpackSettings {
    private final HashMap<Integer, ItemStack> oldCraftingItems;
    private ItemStack backpackStack;
    private Page editCraftingPage;
    public static final Pattern VALID_RECIPE_KEY = Pattern.compile("^backpack_tier_\\d+_recipe$");
    private final BackpackSettingsMainGUI backpackSettingsMainGUI;
    private AllowedItemsGUI allowedItemsGUI;
    private final BackpackSettingsData data;
    public static final List<Integer> CRAFTING_GRID = Arrays.asList(3, 4, 5, 12, 13, 14, 21, 22, 23);
    public static final ButtonActionKey CANCEL_BUTTON_KEY = new ButtonActionKey("cancel_button");
    public static final ButtonActionKey ACCEPT_BUTTON_KEY = new ButtonActionKey("accept_button");

    public BackpackSettings(BackpackSettingsData data) {
        this.data = data;
        this.oldCraftingItems = new HashMap();
        this.createEditInventory();
        this.loadGridCrafting();
        this.backpackSettingsMainGUI = new BackpackSettingsMainGUI(this);
    }

    public void loadAllowedItemsGUI() {
        this.allowedItemsGUI = new AllowedItemsGUI(this);
    }

    private void createEditInventory() {
        String langTitle = LanguageManager.getInstance().getString("gui.crafting-edit-gui.title");
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("crafting", this.data.getDisplayName());
        String title = StringParser.parseString(langTitle, variables);
        this.editCraftingPage = new Page(new ChangeCraftingInventoryHolder(this.data.getTier()), 0, 27, Text.setColour(title));
        Button cancelButton = new Button(this.editCraftingPage, 10, CANCEL_BUTTON_KEY, BasicGuiItems.getInstance().createBlankStainedGlassPane(GlassColors.Red, Text.setColour("#b80000&lCancel"), false), new ClickType[]{ClickType.LEFT}){

            @Override
            public void onButtonClick(Page page, Player player, Event event) {
                CraftingManager.getInstance().removeCraftingEditor(player.getUniqueId());
                this.getOnClickSound().setPitch(1.0f);
                this.getOnClickSound().playSound(player);
                player.closeInventory();
                Inventory inv = BackpackSettings.this.editCraftingPage.getInventory();
                for (int slot : CRAFTING_GRID) {
                    ItemStack oldSlotStack;
                    ItemStack invSlotStack = inv.getItem(slot);
                    if (invSlotStack == null || invSlotStack.getType() == Material.AIR || invSlotStack.equals((Object)(oldSlotStack = BackpackSettings.this.oldCraftingItems.get(slot))) || !Settings.RETURNS_ITEMS_ON_CLOSE) continue;
                    ItemStack returnStack = invSlotStack.clone();
                    returnStack.setAmount(invSlotStack.getAmount() - (invSlotStack.getAmount() > 1 ? 1 : 0));
                    if (player.getInventory().firstEmpty() == -1) {
                        player.getWorld().dropItem(player.getLocation(), returnStack);
                        continue;
                    }
                    player.getInventory().addItem(new ItemStack[]{returnStack});
                }
                BackpackSettings.this.loadGridCrafting();
                Utils.sendMessage(player, LanguageManager.getInstance().getString("backpack-crafting-change-cancelled"));
            }
        };
        this.editCraftingPage.setItem(10, cancelButton.getButtonIcon(), (i, itemStack) -> this.editCraftingPage.addButton(i, cancelButton));
        Button acceptButton = new Button(this.editCraftingPage, 16, ACCEPT_BUTTON_KEY, BasicGuiItems.getInstance().createBlankStainedGlassPane(GlassColors.Lime, Text.setColour("#008b02&lConfirm"), false), new ClickType[]{ClickType.LEFT}){

            @Override
            public void onButtonClick(Page page, Player player, Event event) {
                CraftingManager.getInstance().removeCraftingEditor(player.getUniqueId());
                this.getOnClickSound().setPitch(1.0f);
                this.getOnClickSound().playSound(player);
                player.closeInventory();
                int totalChanges = 0;
                int airSlots = 0;
                Inventory inv = BackpackSettings.this.editCraftingPage.getInventory();
                for (int slot : CRAFTING_GRID) {
                    ItemStack gridStack = inv.getItem(slot);
                    if (gridStack == null || gridStack.getType() == Material.AIR) {
                        ++airSlots;
                    }
                    if (!BackpackSettings.this.oldCraftingItems.get(slot).equals((Object)gridStack)) {
                        ++totalChanges;
                    }
                    if (gridStack == null || gridStack.getAmount() == 1) continue;
                    ItemStack clonedGridStack = gridStack.clone();
                    clonedGridStack.setAmount(gridStack.getAmount() - 1);
                    gridStack.setAmount(1);
                    if (player.getInventory().firstEmpty() == -1) {
                        player.getWorld().dropItem(player.getLocation(), clonedGridStack);
                        continue;
                    }
                    player.getInventory().addItem(new ItemStack[]{clonedGridStack});
                }
                if (totalChanges == 0 || airSlots == 9) {
                    player.sendMessage(Text.setColour(LanguageManager.getInstance().getString("backpack-crafting-cannot-change")));
                    BackpackSettings.this.loadGridCrafting();
                    return;
                }
                BackpackSettings.this.updateRecipe();
                player.sendMessage(Text.setColour(LanguageManager.getInstance().getString("backpack-crafting-change")));
            }
        };
        this.editCraftingPage.setItem(16, acceptButton.getButtonIcon(), (i, itemStack) -> this.editCraftingPage.addButton(i, acceptButton));
        for (int slot = 0; slot < this.editCraftingPage.getSize(); ++slot) {
            Inventory inv;
            if (CRAFTING_GRID.contains(slot) || (inv = this.editCraftingPage.getInventory()).getItem(slot) != null) continue;
            inv.setItem(slot, BasicGuiItems.getInstance().createBlankStainedGlassPane(GlassColors.Gray, false));
        }
    }

    private void loadGridCrafting() {
        if (!this.data.isCanBeCrafted()) {
            return;
        }
        AtomicInteger slotIndex = new AtomicInteger(0);
        this.data.getCraftingIngredient().forEach((key, value) -> {
            int slotId = CRAFTING_GRID.get(slotIndex.get());
            try {
                Material material = Material.getMaterial((String)value.toUpperCase());
                if (material != null) {
                    ItemStack stack = new ItemStack(material);
                    this.editCraftingPage.getInventory().setItem(slotId, stack);
                    this.oldCraftingItems.put(slotId, stack);
                } else {
                    ItemStack decodedStack = ItemUtil.itemFromBase64(value);
                    if (decodedStack != null) {
                        this.editCraftingPage.getInventory().setItem(slotId, decodedStack);
                        this.oldCraftingItems.put(slotId, decodedStack);
                    } else {
                        this.oldCraftingItems.put(slotId, new ItemStack(Material.AIR));
                    }
                }
                slotIndex.getAndIncrement();
            }
            catch (IOException ex) {
                BackpackPlus.getInstance().getLogger().log(Level.WARNING, "Backpack Config: " + this.data.getTier() + " The item could not be decoded: ", ex);
            }
        });
    }

    public void setupRecipe() {
        ShapedRecipe recipe = new ShapedRecipe(this.data.getRecipeKey(), this.backpackStack);
        ArrayList craftingList = new ArrayList();
        String[] shape = this.data.getPattern();
        if (shape.length < 3) {
            BackpackPlus.getInstance().getLogger().warning("Shape must contain at least 3 rows for a ShapedRecipe. Path: " + this.data.getPath() + "crafting.shape");
            shape = new String[]{"123", "456", "789"};
            this.data.setPattern(shape);
        }
        recipe.shape(shape);
        this.data.getCraftingIngredient().forEach((key, value) -> {
            try {
                Material material = Material.getMaterial((String)value.toUpperCase());
                if (material != null) {
                    this.handleMaterialIngredient(recipe, craftingList, key.charValue(), material);
                } else {
                    this.processNonMaterialIngredient(key.charValue(), (String)value, recipe, craftingList);
                }
            }
            catch (IOException | IllegalArgumentException ex) {
                BackpackPlus.getInstance().getLogger().log(Level.WARNING, "Error processing crafting ingredient for key " + key + ": " + value, ex);
            }
        });
        CraftingManager craftingManager = CraftingManager.getInstance();
        craftingManager.backpackCraftingRecipes.put(this.data.getRecipeKey(), craftingList);
        craftingManager.addRecipe(this.data.getRecipeKey(), recipe);
    }

    private void handleMaterialIngredient(ShapedRecipe recipe, List<ItemStack> craftingList, char key, Material material) {
        if (material.isAir()) {
            return;
        }
        recipe.setIngredient(key, material);
        craftingList.add(new ItemStack(material));
    }

    private void handleExactChoiceIngredient(ShapedRecipe recipe, List<ItemStack> craftingList, char key, ItemStack itemStack) {
        itemStack.setAmount(1);
        recipe.setIngredient(key, (RecipeChoice)new RecipeChoice.ExactChoice(itemStack));
        craftingList.add(itemStack);
    }

    private ItemStack decodeItemStack(String base64) {
        try {
            return ItemUtil.itemFromBase64(base64);
        }
        catch (IOException e) {
            return null;
        }
    }

    private void processNonMaterialIngredient(char key, String value, ShapedRecipe recipe, List<ItemStack> craftingList) throws IOException {
        ItemStack decodedStack = this.decodeItemStack(value);
        if (decodedStack != null) {
            this.handleExactChoiceIngredient(recipe, craftingList, key, decodedStack);
            return;
        }
        Material material = Material.getMaterial((String)value.toUpperCase());
        if (material != null) {
            this.handleMaterialIngredient(recipe, craftingList, key, material);
        } else {
            this.logInvalidIngredient(key, value);
        }
    }

    private void logInvalidIngredient(char key, String value) {
        BackpackPlus.getInstance().getLogger().log(Level.WARNING, "Invalid crafting ingredient for key " + key + ": " + value);
    }

    public void initialize() {
        this.backpackStack = this.data.isSkull() ? BackpacksItems.getInstance().backpackItemStack(this.data.getDisplayName(), this.data.getTier(), this.data.getSkullTexture()) : BackpacksItems.getInstance().backpackItemStack(this.data.getDisplayName(), this.data.getTier(), this.data.getCustomModelId(), this.data.getBackpackMaterial() == null ? Material.BROWN_DYE : this.data.getBackpackMaterial());
        if (!this.data.isCanBeCrafted()) {
            return;
        }
        this.setupRecipe();
        this.loadAllowedItemsGUI();
    }

    void updateRecipe() {
        if (!this.data.isCanBeCrafted()) {
            return;
        }
        Inventory inventory = this.editCraftingPage.getInventory();
        ShapedRecipe recipe = new ShapedRecipe(this.data.getRecipeKey(), this.backpackStack);
        ArrayList<ItemStack> craftingList = new ArrayList<ItemStack>();
        recipe.shape(new String[]{"123", "456", "789"});
        int slotIndex = 1;
        for (int slot : CRAFTING_GRID) {
            ItemStack stack;
            block8: {
                char shapeKey = Character.forDigit(slotIndex, 10);
                stack = inventory.getItem(slot);
                if (stack == null) {
                    this.data.getCraftingIngredient().put(Character.valueOf(shapeKey), Material.AIR.name());
                    craftingList.add(new ItemStack(Material.AIR));
                    this.oldCraftingItems.put(slot, new ItemStack(Material.AIR));
                    ++slotIndex;
                    continue;
                }
                stack.setAmount(1);
                if (stack.hasItemMeta() && stack.getItemMeta() != null && stack.getItemMeta().hasDisplayName()) {
                    recipe.setIngredient(shapeKey, (RecipeChoice)new RecipeChoice.ExactChoice(stack));
                    try {
                        String encodedStackData = ItemUtil.itemToBase64(stack);
                        this.data.getCraftingIngredient().put(Character.valueOf(shapeKey), encodedStackData);
                        break block8;
                    }
                    catch (IllegalStateException ex) {
                        BackpackPlus.getInstance().getLogger().log(Level.WARNING, String.format("Failed to convert item to base64: Item: %s", stack));
                        continue;
                    }
                }
                if (!stack.getType().isAir()) {
                    recipe.setIngredient(shapeKey, stack.getType());
                }
                this.data.getCraftingIngredient().put(Character.valueOf(shapeKey), stack.getType().name());
            }
            craftingList.add(stack);
            this.oldCraftingItems.put(slot, stack);
            ++slotIndex;
        }
        CraftingManager.getInstance().backpackCraftingRecipes.put(this.data.getRecipeKey(), craftingList);
        CraftingManager.getInstance().addRecipe(this.data.getRecipeKey(), recipe);
        this.saveCraftingToConfig();
        if (!Bukkit.getOnlinePlayers().isEmpty()) {
            Bukkit.getOnlinePlayers().forEach(player -> {
                if (!player.hasDiscoveredRecipe(this.data.getRecipeKey())) {
                    player.undiscoverRecipe(this.data.getRecipeKey());
                }
                player.discoverRecipe(this.data.getRecipeKey());
            });
        }
    }

    private void saveCraftingToConfig() {
        FileConfiguration config = BackpackPlus.getInstance().getConfig();
        String path = "backpack-tiers." + this.data.getTier() + ".crafting.ingredient.";
        this.data.getCraftingIngredient().forEach((index, value) -> config.set(path + index, value));
        BackpackPlus.getInstance().saveConfig();
    }

    @Generated
    public HashMap<Integer, ItemStack> getOldCraftingItems() {
        return this.oldCraftingItems;
    }

    @Generated
    public ItemStack getBackpackStack() {
        return this.backpackStack;
    }

    @Generated
    public BackpackSettingsMainGUI getBackpackSettingsMainGUI() {
        return this.backpackSettingsMainGUI;
    }

    @Generated
    public BackpackSettingsData getData() {
        return this.data;
    }

    @Generated
    public Page getEditCraftingPage() {
        return this.editCraftingPage;
    }

    @Generated
    public AllowedItemsGUI getAllowedItemsGUI() {
        return this.allowedItemsGUI;
    }
}

