/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.settings;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import me.ziomalu.api.ItemUtil;
import me.ziomalu.api.config.ConfigValues;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.enums.BackpackType;
import pl.ziomalu.backpackplus.items.Item;
import pl.ziomalu.backpackplus.items.NBTItem;
import pl.ziomalu.backpackplus.utils.Text;
import pl.ziomalu.backpackplus.utils.Utils;

public class BackpackSettingsData
extends ConfigValues {
    private final int tier;
    private Material backpackMaterial;
    private final String displayName;
    private final String guiTitle;
    private final int customModelId;
    private final String skullTexture;
    private final int size;
    private final boolean isSkull;
    private final boolean showContent;
    private final boolean ownerOnly;
    private String[] pattern = new String[]{"123", "456", "789"};
    private boolean canBeCrafted;
    private final List<String> description;
    private List<Item> allowedItems;
    private List<NBTItem> allowedNbt;
    private BackpackType backpackType;
    private final HashMap<Character, String> craftingIngredient;
    private final String craftPermission;
    private final String usePermission;
    private final NamespacedKey recipeKey;
    private final String path;

    public BackpackSettingsData(int backpackTier) {
        super(BackpackPlus.getInstance());
        ConfigurationSection section;
        this.tier = backpackTier;
        this.path = String.format("backpack-tiers.%s.", this.tier);
        this.recipeKey = new NamespacedKey((Plugin)BackpackPlus.getInstance(), "backpack_tier_" + this.tier + "_recipe");
        if (!this.isSet("backpack-tiers." + this.tier)) {
            BackpackPlus.getInstance().getLogger().warning("No backpack config of the specified tier was found: " + this.tier);
            throw new IllegalArgumentException("No backpack config of the specified tier was found: " + this.tier);
        }
        this.craftingIngredient = new HashMap();
        if (this.getConfig().isSet(this.path + "material")) {
            String materialStr = this.getConfig().getString(this.path + "material");
            if (materialStr == null) {
                materialStr = Material.BROWN_DYE.name();
                BackpackPlus.getInstance().getLogger().warning("Backpack material is null at path: " + this.path + "material");
            }
            Material material = Material.getMaterial((String)materialStr.toUpperCase());
            this.backpackMaterial = Objects.requireNonNullElse(material, Material.BROWN_DYE);
        }
        this.displayName = this.getConfig().getString(this.path + "displayName");
        this.guiTitle = this.isSet(this.path + "guiTitle") ? this.getString(this.path + "guiTitle") : this.getString(this.path + "gui-title");
        this.customModelId = this.getInt(this.path + "custom-model-id");
        this.skullTexture = this.getString(this.path + "backpack-skull-hash");
        this.size = this.getInt(this.path + "size");
        this.isSkull = this.getBoolean(this.path + "is-skull");
        this.showContent = this.getBoolean(this.path + "show-content");
        this.canBeCrafted = this.getBoolean(this.path + "can-be-crafted");
        this.backpackType = BackpackType.valueOf(this.getAndSaveIfNotExists(this.path + "type", BackpackType.DEFAULT.name()));
        this.allowedItems = new ArrayList<Item>();
        this.allowedNbt = new ArrayList<NBTItem>();
        this.description = Text.setColourList(this.getStringList(this.path + "description"));
        this.usePermission = this.getString(this.path + "permission-use");
        this.craftPermission = this.getString(this.path + "permission-craft");
        boolean saveNeed = false;
        if (!this.isSet(this.path + "owner-only")) {
            this.ownerOnly = false;
            this.set(this.path + "owner-only", false);
            saveNeed = true;
        } else {
            this.ownerOnly = this.getBoolean(this.path + "owner-only");
        }
        if (!this.isSet(this.path + "crafting")) {
            BackpackPlus.getInstance().getLogger().warning("Backpack crafting doesn't exist. can-be-crafted is set to false");
            this.canBeCrafted = false;
            this.set(this.path + "can-be-crafted", false);
            saveNeed = true;
        }
        if (!this.isSet(this.path + "crafting.pattern")) {
            this.set(this.path + "crafting.pattern", this.pattern);
            saveNeed = true;
            BackpackPlus.getInstance().getLogger().warning("Pattern not set at path: " + this.path + "crafting.pattern, default is set");
        } else {
            List<String> patternList = this.getStringList(this.path + "crafting.pattern");
            if (patternList.isEmpty()) {
                this.set(this.path + "crafting.pattern", this.pattern);
                saveNeed = true;
                BackpackPlus.getInstance().getLogger().warning("Pattern is empty at path: " + this.path + "crafting.pattern, default is set");
            } else {
                this.pattern = patternList.toArray(new String[0]);
            }
        }
        if (saveNeed) {
            this.save();
        }
        if ((section = this.getConfig().getConfigurationSection(this.path + "crafting.ingredient")) != null) {
            for (String ingredient : section.getKeys(false)) {
                char shapeKey = ingredient.charAt(0);
                String value = this.getConfig().getString(this.path + "crafting.ingredient." + ingredient);
                this.craftingIngredient.put(Character.valueOf(shapeKey), value);
            }
        } else {
            this.canBeCrafted = false;
            BackpackPlus.getInstance().getLogger().warning("Pattern is empty at path: " + this.path + "crafting.ingredient is null, can-be-crafted sets to false");
        }
        this.loadAllowedItems();
    }

    private void loadAllowedItems() {
        List itemsString = this.getConfig().getStringList(this.path + "allowed-items");
        if (itemsString.isEmpty()) {
            return;
        }
        for (String item : itemsString) {
            try {
                this.processItemEntry(item.trim());
            }
            catch (Exception e) {
                this.logWarning("Error processing item: " + item, e.getMessage());
            }
        }
    }

    private void processItemEntry(String item) throws IOException {
        if (item.startsWith("nbt:")) {
            this.processNBTItem(item);
        } else if (Utils.isValidBase64(item)) {
            this.processBase64Item(item);
        } else {
            this.processMaterialItem(item);
        }
    }

    private void processNBTItem(String item) {
        String nbtData = item.substring(4);
        String[] parts = nbtData.split("[:=]", 3);
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid NBT format. Expected: nbt:plugin:namespace=type");
        }
        NBTItem nbtItem = new NBTItem(parts[0], parts[1], parts[2]);
        this.allowedNbt.add(nbtItem);
    }

    private void processBase64Item(String item) throws IOException {
        ItemStack stack = ItemUtil.itemFromBase64(item);
        if (stack == null) {
            throw new IllegalArgumentException("Invalid base64 string");
        }
        this.allowedItems.add(new Item(stack));
    }

    private void processMaterialItem(String item) {
        Material material = Material.getMaterial((String)item.toUpperCase());
        if (material == null) {
            throw new IllegalArgumentException("Invalid material");
        }
        this.allowedItems.add(new Item(material));
    }

    private void logWarning(String message, String item) {
        BackpackPlus.getInstance().getLogger().warning(String.format("%s: '%s' (Tier: %s)", message, item, this.tier));
    }

    public String toString() {
        return "Backpack{tier=" + this.tier + ", displayName='" + this.displayName + "', guiTitle='" + this.guiTitle + "', customModelId='" + this.customModelId + "', skullTextureLength='" + this.skullTexture.length() + "', size=" + this.size + ", isSkull=" + this.isSkull + ", showContent=" + this.showContent + ", canBeCrafted=" + this.canBeCrafted + ", description=" + String.valueOf(this.description) + ", allowedItems=" + String.valueOf(this.allowedItems) + ", backpackType=" + String.valueOf((Object)this.backpackType) + ", craftPermission='" + this.craftPermission + "', usePermission='" + this.usePermission + "', recipeKey='" + this.recipeKey.getKey() + "}";
    }

    public String getGuiTitle() {
        return this.guiTitle == null || this.guiTitle.isEmpty() ? this.displayName : this.guiTitle;
    }

    public void addAllowedItem(Material material) {
        boolean exists = this.allowedItems.stream().anyMatch(item -> item.getMaterial() == material);
        if (exists) {
            return;
        }
        this.allowedItems.add(new Item(material));
    }

    public void addAllowedItem(ItemStack stack) {
        boolean exists = this.allowedItems.stream().anyMatch(item -> item.equals(stack));
        if (exists) {
            return;
        }
        this.allowedItems.add(new Item(stack));
    }

    public boolean isAllowedItem(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return this.allowedItems.stream().anyMatch(item -> {
            if (item.getItem() != null && item.getItem().isSimilar(stack)) {
                return true;
            }
            return !Item.isCustomItem(stack) && item.getMaterial() != null && item.getMaterial() == stack.getType();
        });
    }

    public boolean isAllowedNBT(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return this.allowedNbt.stream().anyMatch(nbtItem -> nbtItem.isSameType(stack));
    }

    public boolean isAllowedItem(Material material) {
        return this.allowedItems.stream().anyMatch(item -> item.getMaterial() != null && item.getMaterial() == material);
    }

    @Generated
    public int getTier() {
        return this.tier;
    }

    @Generated
    public Material getBackpackMaterial() {
        return this.backpackMaterial;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public int getCustomModelId() {
        return this.customModelId;
    }

    @Generated
    public String getSkullTexture() {
        return this.skullTexture;
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public boolean isSkull() {
        return this.isSkull;
    }

    @Generated
    public boolean isShowContent() {
        return this.showContent;
    }

    @Generated
    public boolean isOwnerOnly() {
        return this.ownerOnly;
    }

    @Generated
    public String[] getPattern() {
        return this.pattern;
    }

    @Generated
    public boolean isCanBeCrafted() {
        return this.canBeCrafted;
    }

    @Generated
    public List<String> getDescription() {
        return this.description;
    }

    @Generated
    public List<Item> getAllowedItems() {
        return this.allowedItems;
    }

    @Generated
    public List<NBTItem> getAllowedNbt() {
        return this.allowedNbt;
    }

    @Generated
    public BackpackType getBackpackType() {
        return this.backpackType;
    }

    @Generated
    public HashMap<Character, String> getCraftingIngredient() {
        return this.craftingIngredient;
    }

    @Generated
    public NamespacedKey getRecipeKey() {
        return this.recipeKey;
    }

    @Override
    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public void setPattern(String[] pattern) {
        this.pattern = pattern;
    }

    @Generated
    public void setCanBeCrafted(boolean canBeCrafted) {
        this.canBeCrafted = canBeCrafted;
    }

    @Generated
    public void setAllowedItems(List<Item> allowedItems) {
        this.allowedItems = allowedItems;
    }

    @Generated
    public void setAllowedNbt(List<NBTItem> allowedNbt) {
        this.allowedNbt = allowedNbt;
    }

    @Generated
    public void setBackpackType(BackpackType backpackType) {
        this.backpackType = backpackType;
    }

    @Generated
    public String getCraftPermission() {
        return this.craftPermission;
    }

    @Generated
    public String getUsePermission() {
        return this.usePermission;
    }
}

