/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.settings;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import me.ziomalu.api.config.ConfigValues;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.plugin.java.JavaPlugin;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.utils.BukkitConsole;
import pl.ziomalu.backpackplus.utils.MinecraftVersion;

public final class Settings
extends ConfigValues {
    private static Settings instance;
    public static String LANGUAGE;
    public static boolean PERMISSIONS_TO_USE_BACKPACK;
    public static boolean CRAFTING_BACKPACK_REQUIRES_PERMISSIONS;
    public static int BACKPACK_COOLDOWN;
    public static boolean RETURNS_ITEMS_ON_CLOSE;
    public static int BACKPACK_IDLE_CACHE_CLEAR;
    public static int PLAYER_BACKPACKS_GUI_IDLE_CACHE_CLEAR;
    public static int CACHE_CLEAR_FREQUENCY;
    public static String FILLING_COLOR_BUTTONS;
    public static boolean FILLING_USE_CUSTOM_MODEL;
    public static int FILLING_CUSTOM_MODEL_ID;
    public static String FILLING_CUSTOM_MODEL_MATERIAL;
    public static boolean FILLING_COLOR_BUTTONS_GLOW;
    public static String COLOUR_OVERFILL_SLOTS;
    public static boolean OVERFILL_USE_CUSTOM_MODEL;
    public static int OVERFILL_CUSTOM_MODEL_ID;
    public static String OVERFILL_CUSTOM_MODEL_MATERIAL;
    public static boolean COLOUR_OVERFILL_SLOTS_GLOW;
    public static boolean LIMIT_BACKPACK_PER_INVENTORY;
    public static int LIMIT_BACKPACK_PER_INVENTORY_AMOUNT;
    public static boolean PAGE_NEXT_USE_CUSTOM_MODEL;
    public static int PAGE_NEXT_CUSTOM_MODEL_ID;
    public static String PAGE_NEXT_CUSTOM_MODEL_MATERIAL;
    public static boolean PAGE_PREVIOUS_USE_CUSTOM_MODEL;
    public static int PAGE_PREVIOUS_CUSTOM_MODEL_ID;
    public static String PAGE_PREVIOUS_CUSTOM_MODEL_MATERIAL;
    public static boolean BLOCK_BACKPACK_INSERT_CONTAINERS;
    private static List<String> BLOCKED_CONTAINERS_STRS;
    public static List<InventoryType> BLOCKED_CONTAINERS;
    public static boolean PLAY_SONG_WHEN_ITEM_MOVED_IN_BACKPACK;
    public static boolean KEEP_BACKPACK_AFTER_DEATH;
    public static String KEEP_BACKPACK_AFTER_DEATH_PERMISSION;
    public static boolean ALLOW_BUNDLES_IN_BACKPACKS;
    public static final boolean DEBUG = false;

    public Settings(JavaPlugin plugin) {
        super(plugin);
        instance = this;
    }

    private void loadBlockedContainers() {
        BLOCKED_CONTAINERS.clear();
        for (String containerName : BLOCKED_CONTAINERS_STRS) {
            try {
                InventoryType inventoryType = InventoryType.valueOf((String)containerName.toUpperCase());
                BLOCKED_CONTAINERS.add(inventoryType);
            }
            catch (IllegalArgumentException e) {
                BackpackPlus.getInstance().getLogger().warning("Invalid InventoryType: " + containerName + " in blocked-containers");
            }
        }
        if (BLOCK_BACKPACK_INSERT_CONTAINERS) {
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Settings\u00a78] \u00a72Loaded " + BLOCKED_CONTAINERS.size() + " blocked container types");
        }
    }

    private static List<String> initializeBlockedContainers() {
        ArrayList<String> blockedContainers = new ArrayList<String>();
        blockedContainers.add(InventoryType.HOPPER.name());
        blockedContainers.add(InventoryType.CHEST.name());
        blockedContainers.add(InventoryType.ENDER_CHEST.name());
        blockedContainers.add(InventoryType.LOOM.name());
        blockedContainers.add(InventoryType.SHULKER_BOX.name());
        blockedContainers.add(InventoryType.BARREL.name());
        blockedContainers.add(InventoryType.DISPENSER.name());
        blockedContainers.add(InventoryType.DROPPER.name());
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_21)) {
            blockedContainers.add(InventoryType.CRAFTER.name());
        }
        return blockedContainers;
    }

    public void load() {
        FILLING_USE_CUSTOM_MODEL = this.getBooleanAndSaveIfNotExists("Gui.filling.custom-model.use", FILLING_USE_CUSTOM_MODEL, "Whether it should use a custom item");
        FILLING_CUSTOM_MODEL_MATERIAL = this.getStringAndSaveIfNotExists("Gui.filling.custom-model.material", FILLING_CUSTOM_MODEL_MATERIAL, "Custom Model Material");
        FILLING_CUSTOM_MODEL_ID = this.getIntAndSaveIfNotExists("Gui.filling.custom-model.custom-model-id", FILLING_CUSTOM_MODEL_ID, "Custom Model Id");
        FILLING_COLOR_BUTTONS_GLOW = this.getBooleanAndSaveIfNotExists("Gui.filling.button.glow", FILLING_COLOR_BUTTONS_GLOW, "Should it glow");
        FILLING_COLOR_BUTTONS = this.getStringAndSaveIfNotExists("Gui.filling.button.color", FILLING_COLOR_BUTTONS, "Colours available:", "White, Red, Orange, Pink, Yellow, Lime, Green, Light_Blue, Cyan, Blue, Magenta, Purple, Brown, Gray, Light_Gray, Black", "", "This is for the lower Blank Stained Glass Pane at the ex buttons:", "[BTN] [x] [x] [x] [x] [x] [x] [x] [BTN]");
        OVERFILL_USE_CUSTOM_MODEL = this.getBooleanAndSaveIfNotExists("Gui.overfill.custom-model.use", OVERFILL_USE_CUSTOM_MODEL, "Whether it should use a custom item");
        OVERFILL_CUSTOM_MODEL_MATERIAL = this.getStringAndSaveIfNotExists("Gui.overfill.custom-model.material", OVERFILL_CUSTOM_MODEL_MATERIAL, "Custom Model Material");
        OVERFILL_CUSTOM_MODEL_ID = this.getIntAndSaveIfNotExists("Gui.overfill.custom-model.custom-model-id", OVERFILL_CUSTOM_MODEL_ID, "Custom Model Id");
        COLOUR_OVERFILL_SLOTS_GLOW = this.getBooleanAndSaveIfNotExists("Gui.overfill.button.glow", COLOUR_OVERFILL_SLOTS_GLOW, "Should it glow");
        COLOUR_OVERFILL_SLOTS = this.getStringAndSaveIfNotExists("Gui.overfill.button.color", COLOUR_OVERFILL_SLOTS, "Colours available:", "White, Red, Orange, Pink, Yellow, Lime, Green, Light_Blue, Cyan, Blue, Magenta, Purple, Brown, Gray, Light_Gray, Black", "", "This is for the lower Blank Stained Glass Pane at the ex buttons:", "[BTN] [x] [x] [x] [x] [x] [x] [x] [BTN]");
        PAGE_NEXT_USE_CUSTOM_MODEL = this.getBooleanAndSaveIfNotExists("Gui.page-next.custom-model.use", PAGE_NEXT_USE_CUSTOM_MODEL, "Should the next page button be as a custom model if it is on false will be used head player");
        PAGE_NEXT_CUSTOM_MODEL_MATERIAL = this.getStringAndSaveIfNotExists("Gui.page-next.custom-model.material", PAGE_NEXT_CUSTOM_MODEL_MATERIAL, "Custom Model Material");
        PAGE_NEXT_CUSTOM_MODEL_ID = this.getIntAndSaveIfNotExists("Gui.page-next.custom-model.custom-model-id", PAGE_NEXT_CUSTOM_MODEL_ID, "Custom Model Id");
        PAGE_PREVIOUS_USE_CUSTOM_MODEL = this.getBooleanAndSaveIfNotExists("Gui.page-previous.custom-model.use", PAGE_PREVIOUS_USE_CUSTOM_MODEL, "Should the next page button be as a custom model if it is on false will be used head player");
        PAGE_PREVIOUS_CUSTOM_MODEL_MATERIAL = this.getStringAndSaveIfNotExists("Gui.page-previous.custom-model.material", PAGE_PREVIOUS_CUSTOM_MODEL_MATERIAL, "Custom Model Material");
        PAGE_PREVIOUS_CUSTOM_MODEL_ID = this.getIntAndSaveIfNotExists("Gui.page-previous.custom-model.custom-model-id", PAGE_PREVIOUS_CUSTOM_MODEL_ID, "Custom Model Id");
        LANGUAGE = this.getStringAndSaveIfNotExists("language", LANGUAGE, "All languages are in the folder: localization, to add a language simply duplicate an already existing one and rename it");
        PERMISSIONS_TO_USE_BACKPACK = this.getBooleanAndSaveIfNotExists("permissions-to-use-backpack", PERMISSIONS_TO_USE_BACKPACK, "Whether to require permissions for a player to use backpacks (different for each tier)");
        CRAFTING_BACKPACK_REQUIRES_PERMISSIONS = this.getBooleanAndSaveIfNotExists("crafting-backpack-requires-permission", CRAFTING_BACKPACK_REQUIRES_PERMISSIONS, "Whether the craft of the backpack is to require the appropriate permission");
        LIMIT_BACKPACK_PER_INVENTORY = this.getBooleanAndSaveIfNotExists("limit-backpack-per-inventory", LIMIT_BACKPACK_PER_INVENTORY, "Block the possibility of having more than the set number(limit-backpack-per-inventory-amount) of backpacks in the inventory");
        LIMIT_BACKPACK_PER_INVENTORY_AMOUNT = this.getIntAndSaveIfNotExists("limit-backpack-per-inventory-amount", LIMIT_BACKPACK_PER_INVENTORY_AMOUNT, "Determines how many backpacks a player can have in inventory, must be enabled: limit-backpack-per-inventory");
        BACKPACK_IDLE_CACHE_CLEAR = this.getIntAndSaveIfNotExists("backpacks-idle-cache-clear", BACKPACK_IDLE_CACHE_CLEAR, "ADVANCE", "After what time (in seconds) the backpack is not used, it is to be deleted from memory");
        PLAYER_BACKPACKS_GUI_IDLE_CACHE_CLEAR = this.getIntAndSaveIfNotExists("player-backpacks-gui-idle-cache-clear", PLAYER_BACKPACKS_GUI_IDLE_CACHE_CLEAR, "After what time (in seconds) the player's backpack gui is not used, it is to be deleted from memory");
        CACHE_CLEAR_FREQUENCY = this.getIntAndSaveIfNotExists("cache-clear-frequency", CACHE_CLEAR_FREQUENCY, "Every how many seconds to be checked");
        this.setComments("Gui", "https://colors-picker.com/hex-color-picker/", "From this page you can take the color hex, of course you can from other pages.", "You can also use regular colors e.g. &2");
        BACKPACK_COOLDOWN = this.getIntAndSaveIfNotExists("backpack-cooldown", BACKPACK_COOLDOWN, "Time in milliseconds, 1 second = 1000 milliseconds");
        RETURNS_ITEMS_ON_CLOSE = this.getBooleanAndSaveIfNotExists("return-items-on-close", RETURNS_ITEMS_ON_CLOSE, "Set to true if it should return items after canceling a crafting change");
        this.setComments("backpack-tiers", "Crafting Slots:", "[1] [2] [3]", "[4] [5] [6]", "[7] [8] [9]", "", "To be able to set a different gui title add: \"guiTitle:\" under \"displayName:\"", "Possible parameters to add to the \"gui-title\":", "%page% -> current page", "%max_pages% -> Number of total pages.", "", "type: DEFAULT | FILTERED(You can only put in those items that are on the allowed-items list)", "allowed-items: allowed materials to put into backpack if type is FILTERED", "^- If you want to add nbt do it like this: nbt:plugin:namespace=value (value must be of type String) eg: nbt:MMOItems:MMOITEMS_ITEM_TYPE=MATERIAL", "", "owner-only: Can the backpack be opened only by its owner", "description: backpack description show in backpack lore", "show-content: Whether it should show the contents of the backpack");
        BLOCK_BACKPACK_INSERT_CONTAINERS = this.getBooleanAndSaveIfNotExists("block-backpack-insert-containers", BLOCK_BACKPACK_INSERT_CONTAINERS, "Should it block the possibility of placing backpacks in containers");
        BLOCKED_CONTAINERS_STRS = this.getStringListAndSaveIfNotExists("blocked-containers", BLOCKED_CONTAINERS_STRS, "https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/event/inventory/InventoryType.html");
        this.loadBlockedContainers();
        PLAY_SONG_WHEN_ITEM_MOVED_IN_BACKPACK = this.getBooleanAndSaveIfNotExists("play-song-when-item-moved-in-backpack", PLAY_SONG_WHEN_ITEM_MOVED_IN_BACKPACK, "Should there be sound when rearranging items in the backpack");
        KEEP_BACKPACK_AFTER_DEATH = this.getBooleanAndSaveIfNotExists("keep-backpacks-after-death", KEEP_BACKPACK_AFTER_DEATH, "Should a player's backpacks remain in the inventory after his death");
        KEEP_BACKPACK_AFTER_DEATH_PERMISSION = this.getStringAndSaveIfNotExists("keep-backpacks-after-death-permission", KEEP_BACKPACK_AFTER_DEATH_PERMISSION, "What permissions must a player have in order for his backpacks to remain in the inventory after death? if it is empty permissions will not be required");
        ALLOW_BUNDLES_IN_BACKPACKS = this.getBooleanAndSaveIfNotExists("allow-bundles-in-backpacks", ALLOW_BUNDLES_IN_BACKPACKS, "Should placing bundles in backpacks be possible?");
        if (this.getMissingFields() == 0) {
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Settings\u00a78] \u00a72Configuration loaded successfully. No missing fields detected.");
        } else {
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Settings\u00a78] \u00a72Configuration loaded. \u00a7c" + this.getMissingFields() + " \u00a72missing fields have been added to the configuration.");
            this.save();
        }
    }

    @Override
    public void reload() {
        super.reload();
        this.load();
        BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eBackpackPlus\u00a78]\u00a77 \u00a78[\u00a76Settings\u00a78] \u00a72Settings reloaded successfully.");
    }

    @Generated
    public static Settings getInstance() {
        return instance;
    }

    static {
        LANGUAGE = "eng";
        PERMISSIONS_TO_USE_BACKPACK = false;
        CRAFTING_BACKPACK_REQUIRES_PERMISSIONS = false;
        BACKPACK_COOLDOWN = 2000;
        RETURNS_ITEMS_ON_CLOSE = false;
        BACKPACK_IDLE_CACHE_CLEAR = 1800;
        PLAYER_BACKPACKS_GUI_IDLE_CACHE_CLEAR = 120;
        CACHE_CLEAR_FREQUENCY = 10;
        FILLING_COLOR_BUTTONS = "Black";
        FILLING_USE_CUSTOM_MODEL = false;
        FILLING_CUSTOM_MODEL_ID = 810001;
        FILLING_CUSTOM_MODEL_MATERIAL = Material.MAP.name();
        FILLING_COLOR_BUTTONS_GLOW = true;
        COLOUR_OVERFILL_SLOTS = "Black";
        OVERFILL_USE_CUSTOM_MODEL = false;
        OVERFILL_CUSTOM_MODEL_ID = 810001;
        OVERFILL_CUSTOM_MODEL_MATERIAL = Material.MAP.name();
        COLOUR_OVERFILL_SLOTS_GLOW = true;
        LIMIT_BACKPACK_PER_INVENTORY = false;
        LIMIT_BACKPACK_PER_INVENTORY_AMOUNT = 1;
        PAGE_NEXT_USE_CUSTOM_MODEL = false;
        PAGE_NEXT_CUSTOM_MODEL_ID = 810003;
        PAGE_NEXT_CUSTOM_MODEL_MATERIAL = Material.MAP.name();
        PAGE_PREVIOUS_USE_CUSTOM_MODEL = false;
        PAGE_PREVIOUS_CUSTOM_MODEL_ID = 810002;
        PAGE_PREVIOUS_CUSTOM_MODEL_MATERIAL = Material.MAP.name();
        BLOCK_BACKPACK_INSERT_CONTAINERS = false;
        BLOCKED_CONTAINERS_STRS = Settings.initializeBlockedContainers();
        BLOCKED_CONTAINERS = new ArrayList<InventoryType>();
        PLAY_SONG_WHEN_ITEM_MOVED_IN_BACKPACK = true;
        KEEP_BACKPACK_AFTER_DEATH = false;
        KEEP_BACKPACK_AFTER_DEATH_PERMISSION = "backpackplus.keep.backpacks";
        ALLOW_BUNDLES_IN_BACKPACKS = false;
    }
}

