/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.tasks;

import java.util.Iterator;
import pl.ziomalu.backpackplus.BackpackManager;
import pl.ziomalu.backpackplus.backpackcontent.Backpack;
import pl.ziomalu.backpackplus.gui.backpack.PlayerBackpacksGUI;
import pl.ziomalu.backpackplus.gui.backpack.backpacksgui.AllBackpacksGUI;
import pl.ziomalu.backpackplus.settings.Settings;
import pl.ziomalu.backpackplus.utils.Utils;

public class CacheClearRunnable
implements Runnable {
    @Override
    public void run() {
        long timeElapsed;
        long timeElapsed2;
        if (!BackpackManager.getInstance().getBackpacks().isEmpty()) {
            Iterator<Object> iterator = BackpackManager.getInstance().getBackpacks().iterator();
            while (iterator.hasNext()) {
                Backpack backpack = iterator.next();
                if (backpack == null || backpack.hasInspectors() || backpack.getBackpackGUI().hasViewers() || (timeElapsed2 = (System.currentTimeMillis() - backpack.getLastUsed()) / 1000L) < (long)Settings.BACKPACK_IDLE_CACHE_CLEAR) continue;
                backpack.closeAndSaveBackpack(true);
                iterator.remove();
                Utils.debugLogToConsole("[CacheClearRunnable] The backpack has been removed from memory: " + String.valueOf(backpack.getBackpackUniqueId()));
            }
        }
        if (!BackpackManager.getInstance().getPlayersBackpacksGUI().isEmpty()) {
            for (PlayerBackpacksGUI playerBackpacksGUI : BackpackManager.getInstance().getPlayersBackpacksGUI()) {
                if (playerBackpacksGUI == null || (timeElapsed2 = (System.currentTimeMillis() - playerBackpacksGUI.getLastUse()) / 1000L) < (long)Settings.PLAYER_BACKPACKS_GUI_IDLE_CACHE_CLEAR) continue;
                BackpackManager.getInstance().removePlayerBackpackGUI(playerBackpacksGUI.getPlayerUniqueId());
            }
        }
        if (AllBackpacksGUI.getInstance() != null && AllBackpacksGUI.getInstance().hasPlayers() && (timeElapsed = (System.currentTimeMillis() - AllBackpacksGUI.getInstance().getLastUsed()) / 1000L) >= (long)Settings.PLAYER_BACKPACKS_GUI_IDLE_CACHE_CLEAR) {
            AllBackpacksGUI.getInstance().unload();
        }
    }
}

