/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.utils;

import lombok.Generated;
import org.bukkit.Bukkit;

public final class MinecraftVersion {
    private final String isNotMyCode = "Original Code From: https://github.com/kangarko/Foundation/blob/master/src/main/java/org/mineacademy/fo/MinecraftVersion.java";
    private static final String serverVersion;
    private static final V current;
    private static final int subversion;

    public static boolean equals(V version) {
        return MinecraftVersion.compareWith(version) == 0;
    }

    public static boolean olderThan(V version) {
        return MinecraftVersion.compareWith(version) < 0;
    }

    public static boolean newerThan(V version) {
        return MinecraftVersion.compareWith(version) > 0;
    }

    public static boolean atLeast(V version) {
        return MinecraftVersion.equals(version) || MinecraftVersion.newerThan(version);
    }

    private static int compareWith(V version) {
        try {
            return MinecraftVersion.getCurrent().minorVersionNumber - version.minorVersionNumber;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return 0;
        }
    }

    public static String getFullVersion() {
        return current.toString() + (String)(subversion > 0 ? "." + subversion : "");
    }

    @Deprecated
    public static String getServerVersion() {
        return serverVersion.equals("craftbukkit") ? "" : serverVersion;
    }

    @Generated
    public static V getCurrent() {
        return current;
    }

    @Generated
    public static int getSubversion() {
        return subversion;
    }

    static {
        String packageName = Bukkit.getServer() == null ? "" : Bukkit.getServer().getClass().getPackage().getName();
        String curr = packageName.substring(packageName.lastIndexOf(46) + 1);
        serverVersion = !"craftbukkit".equals(curr) && !packageName.isEmpty() ? curr : "";
        String bukkitVersion = Bukkit.getServer().getBukkitVersion();
        String versionString = bukkitVersion.split("\\-")[0];
        String[] versions = versionString.split("\\.");
        if (versions.length != 2 && versions.length != 3) {
            throw new RuntimeException("Cannot read Bukkit version: " + versionString + ", expected 2 or 3 parts separated by dots, got " + versions.length + " parts");
        }
        int version = Integer.parseInt(versions[1]);
        current = version < 3 ? V.v1_3_AND_BELOW : V.parse(version);
        subversion = versions.length == 3 ? Integer.parseInt(versions[2]) : 0;
    }

    public static enum V {
        v1_22(22),
        v1_21(21),
        v1_20(20),
        v1_19(19),
        v1_18(18),
        v1_17(17),
        v1_16(16),
        v1_15(15),
        v1_14(14),
        v1_13(13),
        v1_12(12),
        v1_11(11),
        v1_10(10),
        v1_9(9),
        v1_8(8),
        v1_7(7),
        v1_6(6),
        v1_5(5),
        v1_4(4),
        v1_3_AND_BELOW(3);

        private final int minorVersionNumber;

        private V(int version) {
            this.minorVersionNumber = version;
        }

        private static V parse(int number) {
            for (V v : V.values()) {
                if (v.minorVersionNumber != number) continue;
                return v;
            }
            throw new RuntimeException("Invalid version number: " + number);
        }

        public String toString() {
            return "1." + this.minorVersionNumber;
        }
    }
}

