/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.utils;

import java.util.UUID;
import javax.annotation.Nullable;
import lombok.Generated;
import me.ziomalu.api.cache.Cache;
import me.ziomalu.api.cache.CacheKeyManager;
import me.ziomalu.api.cache.object.PlayerCache;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import pl.ziomalu.backpackplus.database.DatabaseManager;
import pl.ziomalu.backpackplus.utils.UUIDToNameConverter;

public final class OfflinePlayersData {
    private static final OfflinePlayersData instance = new OfflinePlayersData();

    private OfflinePlayersData() {
    }

    @Nullable
    public String getPlayerName(UUID playerUniqueId) {
        PlayerCache found = (PlayerCache)Cache.get(CacheKeyManager.playerCache(playerUniqueId));
        if (found != null) {
            return found.getPlayerName();
        }
        Player player = this.getPlayerOnline(playerUniqueId);
        if (player != null) {
            this.updatePlayerCache(playerUniqueId, player.getName());
            return player.getName();
        }
        String playerName = DatabaseManager.getInstance().getDatabase().getPlayerName(playerUniqueId);
        if (playerName != null) {
            this.updatePlayerCache(playerUniqueId, playerName);
            return playerName;
        }
        OfflinePlayer offlinePlayer = this.getOfflinePlayerByUUID(playerUniqueId);
        if (offlinePlayer != null && offlinePlayer.getName() != null) {
            this.updatePlayerCache(playerUniqueId, offlinePlayer.getName());
            return offlinePlayer.getName();
        }
        for (OfflinePlayer offlinePlayer1 : Bukkit.getOfflinePlayers()) {
            if (!offlinePlayer1.getUniqueId().equals(playerUniqueId)) continue;
            this.updatePlayerCache(playerUniqueId, offlinePlayer1.getName());
            return offlinePlayer1.getName();
        }
        return this.fetchNameFromConverter(playerUniqueId);
    }

    private String fetchNameFromConverter(UUID playerUniqueId) {
        if (!Bukkit.getOnlineMode()) {
            return null;
        }
        try {
            String name = new UUIDToNameConverter(playerUniqueId).call();
            if (name != null && !name.isEmpty()) {
                this.updatePlayerCache(playerUniqueId, name);
                return name;
            }
        }
        catch (Exception e) {
            this.logError("fetchNameFromConverter", playerUniqueId, e);
        }
        return null;
    }

    @Nullable
    public UUID getPlayerUniqueId(String playerName) {
        UUID cachedUUID = (UUID)Cache.get(CacheKeyManager.playerUUID(playerName));
        if (cachedUUID != null) {
            return cachedUUID;
        }
        Player player = this.getPlayerOnline(playerName);
        if (player != null) {
            this.updatePlayerCache(player.getUniqueId(), playerName);
            return player.getUniqueId();
        }
        UUID playerUniqueId = DatabaseManager.getInstance().getDatabase().getPlayerUniqueId(playerName);
        if (playerUniqueId != null) {
            this.updatePlayerCache(playerUniqueId, playerName);
        }
        return playerUniqueId;
    }

    public void savePlayer(UUID playerUniqueId, String playerName) {
        DatabaseManager.getInstance().getDatabase().savePlayer(playerUniqueId, playerName);
        this.updatePlayerCache(playerUniqueId, playerName);
    }

    public boolean playerExists(UUID playerUniqueId) {
        return DatabaseManager.getInstance().getDatabase().playerExists(playerUniqueId);
    }

    @Nullable
    public OfflinePlayer getOfflinePlayerByUUID(UUID playerUniqueId) {
        PlayerCache found = (PlayerCache)Cache.get(CacheKeyManager.playerCache(playerUniqueId));
        if (found != null) {
            return found.getOfflinePlayer();
        }
        try {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerUniqueId);
            this.updatePlayerCache(playerUniqueId, offlinePlayer.getName());
            return offlinePlayer;
        }
        catch (Exception e) {
            this.logError("getOfflinePlayerByUUID", playerUniqueId, e);
            return null;
        }
    }

    private OfflinePlayer handleOfflinePlayerFallback(UUID playerUniqueId) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerUniqueId);
        Cache.put(CacheKeyManager.playerCache(playerUniqueId), new PlayerCache(playerUniqueId, offlinePlayer.getName()));
        return offlinePlayer;
    }

    private void updatePlayerCache(UUID playerUniqueId, String playerName) {
        Cache.put(CacheKeyManager.playerCache(playerUniqueId), new PlayerCache(playerUniqueId, playerName));
        Cache.put(CacheKeyManager.playerUUID(playerName), playerUniqueId);
    }

    private void log(String methodName, Object key, String source, Object result) {
    }

    private void logError(String methodName, Object key, Exception exception) {
    }

    private Player getPlayerOnline(UUID playerUniqueId) {
        return Bukkit.getPlayer((UUID)playerUniqueId);
    }

    private Player getPlayerOnline(String playerName) {
        return Bukkit.getPlayer((String)playerName);
    }

    @Generated
    public static OfflinePlayersData getInstance() {
        return instance;
    }
}

