/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import me.ziomalu.api.cache.Cache;
import me.ziomalu.api.cache.CacheKeyManager;
import org.bukkit.Material;
import org.bukkit.SkullType;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.utils.MinecraftVersion;
import pl.ziomalu.backpackplus.utils.OfflinePlayersData;
import pl.ziomalu.backpackplus.utils.ReflectionUtil;

public class SkullCreator {
    private static Field blockProfileField;
    private static Method metaSetProfileMethod;
    private static Field metaProfileField;

    public static ItemStack createSkull() {
        try {
            return new ItemStack(Material.valueOf((String)"PLAYER_HEAD"));
        }
        catch (IllegalArgumentException e) {
            return new ItemStack(Material.valueOf((String)"SKULL_ITEM"), 1, 3);
        }
    }

    public static ItemStack itemFromName(String name) {
        String key = CacheKeyManager.skullByName(name);
        if (Cache.containsKey(key)) {
            return (ItemStack)Cache.get(key);
        }
        ItemStack item = SkullCreator.itemWithName(SkullCreator.createSkull(), name);
        Cache.put(key, item);
        return item;
    }

    public static ItemStack itemFromUuid(UUID id) {
        String key = CacheKeyManager.skullByUUID(id);
        if (Cache.containsKey(key)) {
            return (ItemStack)Cache.get(key);
        }
        ItemStack item = SkullCreator.itemWithUuid(SkullCreator.createSkull(), id);
        Cache.put(key, item);
        return item;
    }

    public static ItemStack itemFromUrl(String url) {
        return SkullCreator.itemWithUrl(SkullCreator.createSkull(), url);
    }

    public static ItemStack itemFromBase64(String base64) {
        return SkullCreator.itemWithBase64(SkullCreator.createSkull(), base64);
    }

    public static ItemStack itemWithName(@NonNull ItemStack item, @NonNull String name) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        meta.setOwner(name);
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public static ItemStack itemWithUuid(@NonNull ItemStack item, @NonNull UUID id) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        try {
            meta.setOwningPlayer(OfflinePlayersData.getInstance().getOfflinePlayerByUUID(id));
        }
        catch (Throwable t) {
            meta.setOwner(OfflinePlayersData.getInstance().getPlayerName(id));
            BackpackPlus.getInstance().getLogger().severe("[SkullCreator] (Throwable) itemWithUuid Error: " + t.getMessage());
        }
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public static ItemStack itemWithUrl(@NonNull ItemStack item, @NonNull String url) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return SkullCreator.itemWithBase64(item, SkullCreator.urlToBase64(url));
    }

    public static ItemStack itemWithBase64(@NonNull ItemStack item, @NonNull String base64) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (base64 == null) {
            throw new NullPointerException("base64 is marked non-null but is null");
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof SkullMeta)) {
            return null;
        }
        SkullMeta meta = (SkullMeta)itemMeta;
        SkullCreator.mutateItemMeta(meta, base64);
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public static SkullMeta metaWithUrl(@NonNull SkullMeta meta, @NonNull String url) {
        if (meta == null) {
            throw new NullPointerException("meta is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        String base64 = SkullCreator.urlToBase64(url);
        SkullCreator.mutateItemMeta(meta, base64);
        return meta;
    }

    public static void blockWithUuid(@NonNull Block block, @NonNull UUID id) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        SkullCreator.setToSkull(block);
        Skull state = (Skull)block.getState();
        state.setRawData((byte)1);
        try {
            state.setOwningPlayer(OfflinePlayersData.getInstance().getOfflinePlayerByUUID(id));
        }
        catch (Throwable t) {
            state.setOwner(OfflinePlayersData.getInstance().getPlayerName(id));
        }
        state.update(false, false);
    }

    public static void blockWithUrl(@NonNull Block block, @NonNull String url) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        SkullCreator.blockWithBase64(block, SkullCreator.urlToBase64(url));
    }

    public static void blockWithBase64(@NonNull Block block, @NonNull String base64) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (base64 == null) {
            throw new NullPointerException("base64 is marked non-null but is null");
        }
        SkullCreator.setToSkull(block);
        Skull state = (Skull)block.getState();
        SkullCreator.mutateBlockState(state, base64);
        state.update(false, false);
    }

    private static void setToSkull(Block block) {
        try {
            block.setType(Material.valueOf((String)"PLAYER_HEAD"), false);
        }
        catch (IllegalArgumentException e) {
            block.setType(Material.valueOf((String)"SKULL"), false);
            Skull state = (Skull)block.getState();
            state.setSkullType(SkullType.PLAYER);
            state.setRawData((byte)1);
            state.update(false, false);
            BackpackPlus.getInstance().getLogger().severe("[SkullCreator] (IllegalArgumentException) setToSkull Error: " + e.getMessage());
        }
    }

    private static String urlToBase64(String url) {
        URI actualUrl;
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            throw new IllegalArgumentException("URL for skull must start with http:// or https://, given: " + url);
        }
        try {
            actualUrl = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String toEncode = "{\"textures\":{\"SKIN\":{\"url\":\"" + String.valueOf(actualUrl) + "\"}}}";
        return Base64.getEncoder().encodeToString(toEncode.getBytes());
    }

    private static Object makeProfile(String b64) {
        UUID id = new UUID(b64.substring(b64.length() - 20).hashCode(), b64.substring(b64.length() - 10).hashCode());
        try {
            Class<?> gameProfileClass = ReflectionUtil.lookupClass("com.mojang.authlib.GameProfile");
            Class<?> propertyClass = ReflectionUtil.lookupClass("com.mojang.authlib.properties.Property");
            Object fakeProfileInstance = gameProfileClass.getConstructor(UUID.class, String.class).newInstance(id, "aaaaa");
            Object propertyInstance = propertyClass.getConstructor(String.class, String.class).newInstance("textures", b64);
            Method getProperties = fakeProfileInstance.getClass().getMethod("getProperties", new Class[0]);
            Object propertyMap = getProperties.invoke(fakeProfileInstance, new Object[0]);
            Method putMethod = propertyMap.getClass().getMethod("put", Object.class, Object.class);
            putMethod.invoke(propertyMap, "textures", propertyInstance);
            if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_21) && MinecraftVersion.getSubversion() >= 1) {
                Class<?> resolvableProfileClass = ReflectionUtil.lookupClass("net.minecraft.world.item.component.ResolvableProfile");
                Object fakeResolvableProfileInstance = resolvableProfileClass.getConstructor(gameProfileClass).newInstance(fakeProfileInstance);
                return fakeResolvableProfileInstance;
            }
            return fakeProfileInstance;
        }
        catch (ReflectiveOperationException ex) {
            BackpackPlus.getInstance().getLogger().severe("[SkullCreator] makeProfile Error: " + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    public static void mutateBlockState(Skull block, String b64) {
        try {
            if (blockProfileField == null) {
                blockProfileField = block.getClass().getDeclaredField("profile");
                blockProfileField.setAccessible(true);
            }
            blockProfileField.set(block, SkullCreator.makeProfile(b64));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            BackpackPlus.getInstance().getLogger().severe("[SkullCreator] mutateBlockState Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void mutateItemMeta(SkullMeta meta, String b64) {
        try {
            if (metaSetProfileMethod == null) {
                metaSetProfileMethod = meta.getClass().getDeclaredMethod("setProfile", ReflectionUtil.lookupClass("com.mojang.authlib.GameProfile"));
                metaSetProfileMethod.setAccessible(true);
            }
            metaSetProfileMethod.invoke((Object)meta, SkullCreator.makeProfile(b64));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            try {
                if (metaProfileField == null) {
                    metaProfileField = meta.getClass().getDeclaredField("profile");
                    metaProfileField.setAccessible(true);
                }
                metaProfileField.set(meta, SkullCreator.makeProfile(b64));
            }
            catch (IllegalAccessException | NoSuchFieldException ex2) {
                BackpackPlus.getInstance().getLogger().severe("[SkullCreator] mutateItemMeta Error: " + ex.getMessage());
                ex2.printStackTrace();
            }
        }
        catch (ClassNotFoundException e) {
            BackpackPlus.getInstance().getLogger().severe("[SkullCreator] (ClassNotFoundException) mutateItemMeta Error: " + e.getMessage());
        }
    }

    public static void rotateSkull(Skull skull, BlockFace blockFace) {
        skull.setRotation(blockFace);
        skull.update(true);
    }

    @Generated
    private SkullCreator() {
    }
}

