/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.backpackplus.utils;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.ziomalu.api.cache.Cache;
import me.ziomalu.api.cache.CacheKeyManager;
import me.ziomalu.api.gui.basic.BasicGuiItems;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.profile.PlayerProfile;
import pl.ziomalu.backpackplus.BackpackManager;
import pl.ziomalu.backpackplus.BackpackPlus;
import pl.ziomalu.backpackplus.interfaces.Callback;
import pl.ziomalu.backpackplus.utils.Text;
import pl.ziomalu.backpackplus.utils.UpdateChecker;

public final class Utils {
    private static final HashMap<UUID, Long> messageCooldowns = new HashMap();
    private static final Pattern UUID_PATTERN = Pattern.compile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");

    private Utils() {
    }

    public static boolean playerHasBackpackInInventory(Player player) {
        ItemStack[] stacks;
        PlayerInventory inv = player.getInventory();
        if (inv.isEmpty()) {
            return false;
        }
        for (ItemStack stack : stacks = inv.getContents()) {
            if (stack == null || !BackpackManager.getInstance().isBackpackStack(stack) || !BackpackManager.getInstance().backpackIsUsed(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean playerHasBackpackInInventory(Player player, int maxBackpacks) {
        PlayerInventory inv = player.getInventory();
        if (inv.isEmpty()) {
            return false;
        }
        ItemStack[] stacks = inv.getContents();
        int backpackInInventory = 0;
        for (ItemStack stack : stacks) {
            if (stack == null || !BackpackManager.getInstance().isBackpackStack(stack) || !BackpackManager.getInstance().backpackIsUsed(stack) || ++backpackInInventory < maxBackpacks) continue;
            return true;
        }
        return false;
    }

    public static void sendPlayerOnceMessage(Player player, String message, int delay) {
        long timeElapsed;
        if (message == null || message.isEmpty()) {
            return;
        }
        if (messageCooldowns.containsKey(player.getUniqueId()) && (timeElapsed = System.currentTimeMillis() - messageCooldowns.get(player.getUniqueId())) > (long)delay * 1000L) {
            messageCooldowns.remove(player.getUniqueId());
        }
        if (!messageCooldowns.containsKey(player.getUniqueId())) {
            player.sendMessage(Text.setColour(message));
            messageCooldowns.put(player.getUniqueId(), System.currentTimeMillis());
        }
    }

    public static ItemStack getOneItemStack(ItemStack items) {
        if (items == null) {
            return null;
        }
        int originalAmount = items.getAmount();
        if (originalAmount > 1) {
            ItemStack cloned = items.clone();
            cloned.setAmount(1);
            items.setAmount(originalAmount - 1);
            return cloned;
        }
        return items;
    }

    public static void debugLogToConsole(Level level, String message) {
    }

    public static void debugLogToConsole(String message) {
    }

    public static void debugLogToConsole(Level level, String message, Exception ex) {
    }

    public static void sendMessage(Player player, String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        player.sendMessage(Text.setColour(message));
    }

    public static void sendMessage(CommandSender sender, String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        sender.sendMessage(Text.setColour(message));
    }

    public static boolean isValidBase64(String base64) {
        if (base64 == null || base64.isEmpty() || base64.length() % 4 != 0 || base64.contains(" ")) {
            return false;
        }
        if (!base64.matches("^[A-Za-z0-9+/]+[=]{0,2}$")) {
            return false;
        }
        try {
            Base64.getDecoder().decode(base64);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByDescending(Map<K, V> toSort) {
        return toSort.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    public static String firstWorldsToUpper(String worldName) {
        worldName = worldName.replace("_", " ");
        String[] splitName = worldName.split(" ");
        StringBuilder sb = new StringBuilder();
        for (String split : splitName) {
            sb.append(split.substring(0, 1).toUpperCase()).append(split.substring(1)).append(" ");
        }
        return sb.toString().trim();
    }

    public static String firstLetterUpper(String text) {
        return text.substring(0, 1).toUpperCase() + text.substring(1).toLowerCase();
    }

    public static boolean isBase64(String str) {
        if (str == null || str.length() % 4 != 0) {
            return false;
        }
        return str.matches("^[A-Za-z0-9+/=]+$");
    }

    public static String extractTextureUrlFromBase64(String base64String) {
        String url;
        Root root;
        byte[] decodedBytes;
        if (!Utils.isBase64(base64String)) {
            return base64String;
        }
        try {
            decodedBytes = Base64.getDecoder().decode(base64String);
        }
        catch (IllegalArgumentException e) {
            return base64String;
        }
        String decodedString = new String(decodedBytes);
        Gson gson = new Gson();
        try {
            root = (Root)gson.fromJson(decodedString, Root.class);
        }
        catch (Exception e) {
            return null;
        }
        if (root.textures != null && root.textures.SKIN != null && root.textures.SKIN.url != null && (url = root.textures.SKIN.url).startsWith("http://textures.minecraft.net/texture/")) {
            return url;
        }
        return base64String;
    }

    public static boolean isValidUrl(String urlString) {
        try {
            URI uri = new URI(urlString);
            if (!uri.isAbsolute()) {
                return false;
            }
            URL url = uri.toURL();
            return (url.getProtocol().equals("http") || url.getProtocol().equals("https")) && url.getHost() != null;
        }
        catch (MalformedURLException | URISyntaxException e) {
            return false;
        }
    }

    public static boolean isPuttingItemIntoBundle(ItemStack currentItem, ItemStack cursorItem) {
        try {
            return currentItem != null && currentItem.getType() == Material.BUNDLE && BackpackManager.getInstance().isBackpackStack(cursorItem) || BackpackManager.getInstance().isBackpackStack(currentItem) && cursorItem != null && cursorItem.getType() == Material.BUNDLE;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean isBlockedItem(ItemStack stack) {
        return BackpackManager.getInstance().isBlocked(stack);
    }

    public static boolean hasBlockedItem(ItemStack ... stacks) {
        if (stacks == null) {
            return false;
        }
        for (ItemStack stack : stacks) {
            if (!Utils.isBlockedItem(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBackpackStack(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return BackpackManager.getInstance().isBackpackStack(stack);
    }

    public static boolean isGuiOrPageButtonItem(ItemStack item) {
        if (item == null) {
            return false;
        }
        return BasicGuiItems.getInstance().isPageButtonItem(item) || BasicGuiItems.getInstance().isGuiItem(item);
    }

    public static boolean stackIsBundle(ItemStack itemStack) {
        return itemStack != null && itemStack.getType() == Material.BUNDLE;
    }

    public static <T extends InventoryHolder> void playerHasOpenInventory(Player player, Class<T> inventoryHolderClass, Callback callback) {
        Bukkit.getScheduler().runTaskLater((Plugin)BackpackPlus.getInstance(), () -> {
            if (player == null || !player.isOnline()) {
                callback.execute(false);
                return;
            }
            boolean hasOpenedInventory = inventoryHolderClass.isInstance(player.getOpenInventory().getTopInventory().getHolder());
            callback.execute(hasOpenedInventory);
        }, 1L);
    }

    public static int extractTier(String jsonContent) {
        try {
            JsonObject jsonObject = JsonParser.parseString((String)jsonContent).getAsJsonObject();
            return jsonObject.get("tier").getAsInt();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid JSON format: " + jsonContent, e);
        }
    }

    public static boolean isValidUUID(String str) {
        if (str == null) {
            return false;
        }
        Matcher matcher = UUID_PATTERN.matcher(str);
        return matcher.matches();
    }

    public static UpdateChecker.Version getPluginVersion() {
        UpdateChecker.VersionChannel channel;
        String pluginVersionAll = BackpackPlus.getInstance().getDescription().getVersion();
        String[] splitVersion = pluginVersionAll.split("-");
        String pluginVersionStr = splitVersion[0];
        try {
            channel = splitVersion.length == 1 ? UpdateChecker.VersionChannel.RELEASE : UpdateChecker.VersionChannel.valueOf(splitVersion[1].replace("Release", "RELEASE").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            BackpackPlus.getInstance().getLogger().warning("Unknown version channel: " + splitVersion[1]);
            channel = UpdateChecker.VersionChannel.RELEASE;
        }
        int buildNumber = 0;
        try {
            if (splitVersion.length == 3) {
                buildNumber = channel == UpdateChecker.VersionChannel.DEV ? Integer.parseInt(splitVersion[2]) : 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new UpdateChecker.Version(pluginVersionStr, channel, buildNumber);
    }

    public static ItemStack getPlayerHead(Player player) {
        String cacheKey = CacheKeyManager.skullByUUID(player.getUniqueId());
        if (Cache.containsKey(cacheKey)) {
            ItemStack cached = (ItemStack)Cache.get(cacheKey);
            return cached != null ? cached.clone() : null;
        }
        PlayerProfile profile = player.getPlayerProfile();
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (meta != null) {
            meta.setOwnerProfile(profile);
            head.setItemMeta((ItemMeta)meta);
        }
        Cache.put(cacheKey, head.clone());
        return head;
    }

    public static ItemStack getPlayerHead(OfflinePlayer offlinePlayer) {
        String cacheKey = CacheKeyManager.skullByUUID(offlinePlayer.getUniqueId());
        if (Cache.containsKey(cacheKey)) {
            ItemStack cached = (ItemStack)Cache.get(cacheKey);
            return cached != null ? cached.clone() : null;
        }
        PlayerProfile profile = offlinePlayer.getPlayerProfile();
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (meta != null) {
            meta.setOwnerProfile(profile);
            head.setItemMeta((ItemMeta)meta);
        }
        Cache.put(cacheKey, head.clone());
        return head;
    }

    static class Root {
        Textures textures;

        Root() {
        }
    }

    static class Textures {
        Skin SKIN;

        Textures() {
        }
    }

    static class Skin {
        String url;

        Skin() {
        }
    }
}

