/*
 * Decompiled with CFR 0.152.
 */
package se.dpixie.democraticcommands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

@Mod(value="democraticcommands")
public class DemocraticCommandsMod {
    public static final String MOD_ID = "democraticcommands";
    private static final Map<UUID, ActiveVote> activeVotes = new ConcurrentHashMap<UUID, ActiveVote>();
    private static final Set<String> opCommands = new HashSet<String>(Arrays.asList("gamemode", "gamerule", "give", "tp", "teleport", "kill", "ban", "kick", "op", "deop", "whitelist", "difficulty", "stop", "save-all", "save-on", "save-off", "setblock", "fill", "clone", "summon", "effect", "enchant", "xp", "experience", "weather", "time", "spawnpoint", "setworldspawn", "spreadplayers", "playsound", "particle", "title", "scoreboard", "team", "worldborder", "locate", "loot", "data", "execute", "function"));
    private static File auditLogFile;

    public DemocraticCommandsMod() {
        try {
            Class.forName("org.spongepowered.asm.mixin.Mixin");
            System.out.println("[DemocraticCommands] Mixin is available!");
        }
        catch (ClassNotFoundException e) {
            System.out.println("[DemocraticCommands] Mixin is NOT available!");
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new VotingEventHandler());
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
    }

    private void onServerStarting(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        File worldDir = server.m_129843_(LevelResource.f_78182_).toFile();
        File modLogDir = new File(worldDir, "logs");
        if (!modLogDir.exists()) {
            modLogDir.mkdirs();
        }
        auditLogFile = new File(modLogDir, "audit.txt");
        CommandDispatcher dispatcher = server.m_129892_().m_82094_();
        for (String opCommand : opCommands) {
            try {
                CommandNode commandNode = dispatcher.getRoot().getChild(opCommand);
                if (commandNode == null) continue;
                try {
                    Field field = CommandNode.class.getDeclaredField("requirement");
                    field.setAccessible(true);
                    field.set(commandNode, source -> true);
                    System.out.println("[DemocraticCommands] Made " + opCommand + " visible to all players");
                }
                catch (Exception e) {
                    System.err.println("[DemocraticCommands] Failed to modify " + opCommand + ": " + e.getMessage());
                }
            }
            catch (Exception exception) {}
        }
    }

    public static class Config {
        public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        public static final ForgeConfigSpec.IntValue VOTE_TIMEOUT = BUILDER.comment("Time in seconds before a vote times out").defineInRange("voteTimeout", 30, 10, 300);
        public static final ForgeConfigSpec.IntValue MINIMUM_VOTERS = BUILDER.comment("Minimum number of players required online to initiate a vote").defineInRange("minimumVoters", 2, 1, 100);
        public static final ForgeConfigSpec.IntValue MINIMUM_VOTES_REQUIRED = BUILDER.comment("Minimum number of actual votes (not abstentions) required for a vote to be valid").defineInRange("minimumVotesRequired", 2, 1, 100);
        public static final ForgeConfigSpec.DoubleValue APPROVAL_THRESHOLD = BUILDER.comment("Percentage of YES votes required for a vote to pass (0.5 = 50%, 0.66 = 66%)").defineInRange("approvalThreshold", 0.5, 0.0, 1.0);
        public static final ForgeConfigSpec.BooleanValue REQUIRE_MAJORITY_PARTICIPATION = BUILDER.comment("If true, requires more than 50% of online players to vote (not abstain) for the vote to be valid").define("requireMajorityParticipation", true);
        public static final ForgeConfigSpec.BooleanValue LOG_VOTES = BUILDER.comment("Enable logging of all votes to file").define("logVotes", true);
        public static final ForgeConfigSpec.BooleanValue COUNT_ABSTENTIONS_AS_NO = BUILDER.comment("If true, abstentions count as NO votes. If false, they are ignored").define("countAbstentionsAsNo", false);
        public static final ForgeConfigSpec SPEC = BUILDER.build();
    }

    @Mod.EventBusSubscriber(modid="democraticcommands")
    public static class VotingEventHandler {
        private static final SuggestionProvider<CommandSourceStack> OP_COMMAND_SUGGESTIONS = (context, builder) -> {
            String input = builder.getRemaining();
            CommandDispatcher dispatcher = ((CommandSourceStack)context.getSource()).m_81377_().m_129892_().m_82094_();
            CommandSourceStack opSource = ((CommandSourceStack)context.getSource()).m_81325_(4);
            StringReader reader = new StringReader(input);
            ParseResults parseResults = dispatcher.parse(reader, (Object)opSource);
            return dispatcher.getCompletionSuggestions(parseResults, input.length());
        };

        @SubscribeEvent
        public static void onRegisterCommands(RegisterCommandsEvent event) {
            CommandDispatcher dispatcher = event.getDispatcher();
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"vote").requires(source -> true)).then(Commands.m_82129_((String)"command", (ArgumentType)StringArgumentType.greedyString()).suggests(OP_COMMAND_SUGGESTIONS).executes(context -> VotingEventHandler.initiateVote((CommandContext<CommandSourceStack>)context))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"yes").requires(source -> true)).executes(context -> VotingEventHandler.castVote((CommandContext<CommandSourceStack>)context, true)));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"no").requires(source -> true)).executes(context -> VotingEventHandler.castVote((CommandContext<CommandSourceStack>)context, false)));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"votestatus").requires(source -> true)).executes(context -> VotingEventHandler.showVoteStatus((CommandContext<CommandSourceStack>)context)));
        }

        @SubscribeEvent
        public static void onCommandEvent(CommandEvent event) {
            CommandSourceStack source = (CommandSourceStack)event.getParseResults().getContext().getSource();
            String fullCommand = event.getParseResults().getReader().getString();
            Entity entity = source.m_81373_();
            if (!(entity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)entity;
            if (player.getPersistentData().m_128471_("democraticcommands_vote_executing")) {
                player.getPersistentData().m_128379_("democraticcommands_vote_executing", false);
                return;
            }
            String commandName = fullCommand.split(" ")[0].replace("/", "");
            if (!opCommands.contains(commandName) || player.m_20310_(2)) {
                return;
            }
            event.setCanceled(true);
            VotingEventHandler.createAndStartVote(fullCommand, player);
        }

        private static void createAndStartVote(String fullCommand, ServerPlayer initiator) {
            if (activeVotes.containsKey(initiator.m_20148_())) {
                initiator.m_213846_((Component)Component.m_237113_((String)"\u00a7cYou already have an active vote. Please wait for it to complete."));
                return;
            }
            MinecraftServer server = initiator.m_20194_();
            List players = server.m_6846_().m_11314_();
            if (players.size() < (Integer)Config.MINIMUM_VOTERS.get()) {
                initiator.m_213846_((Component)Component.m_237113_((String)("\u00a7cNot enough players online to vote. Minimum required: " + String.valueOf(Config.MINIMUM_VOTERS.get()) + ", Currently online: " + players.size())));
                return;
            }
            ActiveVote activeVote = new ActiveVote(fullCommand, initiator, players);
            activeVotes.put(initiator.m_20148_(), activeVote);
            initiator.getPersistentData().m_128379_("democraticcommands_vote_executing", false);
            MutableComponent voteMessage = Component.m_237113_((String)"\u00a76===== VOTE INITIATED =====\n").m_7220_((Component)Component.m_237113_((String)("\u00a7ePlayer \u00a7b" + initiator.m_7755_().getString() + "\u00a7e wants to execute:\n"))).m_7220_((Component)Component.m_237113_((String)("\u00a7c/" + fullCommand + "\n"))).m_7220_((Component)Component.m_237113_((String)"\u00a7eVote using: ")).m_7220_((Component)VotingEventHandler.createClickableVote("\u00a7a[YES]", "/yes", "\u00a7aClick to vote YES")).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)VotingEventHandler.createClickableVote("\u00a7c[NO]", "/no", "\u00a7cClick to vote NO")).m_7220_((Component)Component.m_237113_((String)("\n\u00a77Vote expires in " + String.valueOf(Config.VOTE_TIMEOUT.get()) + " seconds"))).m_7220_((Component)Component.m_237113_((String)("\n\u00a77Required: " + (int)((Double)Config.APPROVAL_THRESHOLD.get() * 100.0) + "% approval, minimum " + String.valueOf(Config.MINIMUM_VOTES_REQUIRED.get()) + " votes")));
            for (ServerPlayer player : players) {
                player.m_213846_((Component)voteMessage);
            }
            VotingEventHandler.logVote("INITIATED", activeVote);
        }

        @SubscribeEvent
        public static void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            Iterator<Map.Entry<UUID, ActiveVote>> iterator = activeVotes.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, ActiveVote> entry = iterator.next();
                ActiveVote vote = entry.getValue();
                if (!vote.isExpired()) continue;
                vote.markAbstained();
                VotingEventHandler.concludeVote(entry.getKey(), vote);
                iterator.remove();
            }
        }

        private static int initiateVote(CommandContext<CommandSourceStack> context) {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            Entity entity = source.m_81373_();
            if (!(entity instanceof ServerPlayer)) {
                source.m_81352_((Component)Component.m_237113_((String)"\u00a7cOnly players can initiate votes."));
                return 0;
            }
            ServerPlayer initiator = (ServerPlayer)entity;
            String command = StringArgumentType.getString(context, (String)"command");
            String commandName = command.split(" ")[0];
            if (!opCommands.contains(commandName)) {
                initiator.m_213846_((Component)Component.m_237113_((String)"\u00a7eThis command doesn't require op permissions. You can run it directly."));
                return 0;
            }
            VotingEventHandler.createAndStartVote(command, initiator);
            return 1;
        }

        private static int castVote(CommandContext<CommandSourceStack> context, boolean yes) {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            if (!(source.m_81373_() instanceof ServerPlayer)) {
                return 0;
            }
            ServerPlayer voter = (ServerPlayer)source.m_81373_();
            ActiveVote activeVote = null;
            UUID voteId = null;
            for (Map.Entry<UUID, ActiveVote> entry : activeVotes.entrySet()) {
                ActiveVote vote = entry.getValue();
                if (!vote.eligibleVoters.contains(voter.m_20148_())) continue;
                activeVote = vote;
                voteId = entry.getKey();
                break;
            }
            if (activeVote == null) {
                voter.m_213846_((Component)Component.m_237113_((String)"\u00a7cNo active vote found."));
                return 0;
            }
            if (activeVote.hasVoted(voter.m_20148_())) {
                voter.m_213846_((Component)Component.m_237113_((String)("\u00a7eYou changed your vote to \u00a7" + (yes ? "aYES" : "cNO"))));
            } else {
                voter.m_213846_((Component)Component.m_237113_((String)("\u00a7eYou voted \u00a7" + (yes ? "aYES" : "cNO"))));
            }
            activeVote.vote(voter.m_20148_(), yes);
            if (activeVote.yesVotes.size() + activeVote.noVotes.size() == activeVote.eligibleVoters.size()) {
                VotingEventHandler.concludeVote(voteId, activeVote);
                activeVotes.remove(voteId);
            } else {
                VotingEventHandler.updateVoteStatus(activeVote);
            }
            return 1;
        }

        private static int showVoteStatus(CommandContext<CommandSourceStack> context) {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            if (activeVotes.isEmpty()) {
                source.m_243053_((Component)Component.m_237113_((String)"\u00a77No active votes."));
                return 0;
            }
            for (ActiveVote vote : activeVotes.values()) {
                MutableComponent status = Component.m_237113_((String)"\u00a76=== CURRENT VOTE STATUS ===\n").m_7220_((Component)Component.m_237113_((String)("\u00a7eCommand: \u00a7c/" + vote.command + "\n"))).m_7220_((Component)Component.m_237113_((String)("\u00a7aYES: " + vote.yesVotes.size() + " \u00a77| \u00a7cNO: " + vote.noVotes.size() + " \u00a77| \u00a78Not voted: " + (vote.eligibleVoters.size() - vote.yesVotes.size() - vote.noVotes.size()) + "\n"))).m_7220_((Component)Component.m_237113_((String)("\u00a77Time remaining: " + vote.getTimeRemaining() + " seconds")));
                source.m_243053_((Component)status);
            }
            return 1;
        }

        private static void concludeVote(UUID voteId, ActiveVote vote) {
            MinecraftServer server = vote.initiator.m_20194_();
            List players = server.m_6846_().m_11314_();
            boolean passed = vote.isPassed();
            int totalVotes = vote.yesVotes.size() + vote.noVotes.size();
            MutableComponent resultMessage = Component.m_237113_((String)"\u00a76===== VOTE CONCLUDED =====\n").m_7220_((Component)Component.m_237113_((String)("\u00a7eCommand: \u00a7c/" + vote.command + "\n"))).m_7220_((Component)Component.m_237113_((String)("\u00a7aYES: " + vote.yesVotes.size() + " \u00a77| \u00a7cNO: " + vote.noVotes.size() + " \u00a77| \u00a78Abstained: " + vote.abstained.size() + "\n")));
            if (!passed) {
                if (totalVotes < (Integer)Config.MINIMUM_VOTES_REQUIRED.get()) {
                    resultMessage.m_7220_((Component)Component.m_237113_((String)("\u00a7cInsufficient votes: " + totalVotes + "/" + String.valueOf(Config.MINIMUM_VOTES_REQUIRED.get()) + " required\n")));
                } else if (((Boolean)Config.REQUIRE_MAJORITY_PARTICIPATION.get()).booleanValue() && (double)totalVotes / (double)vote.eligibleVoters.size() <= 0.5) {
                    resultMessage.m_7220_((Component)Component.m_237113_((String)"\u00a7cInsufficient participation (>50% required)\n"));
                }
            }
            resultMessage.m_7220_((Component)Component.m_237113_((String)(passed ? "\u00a7a\u2713 VOTE PASSED" : "\u00a7c\u2717 VOTE FAILED")));
            for (ServerPlayer player : players) {
                player.m_213846_((Component)resultMessage);
            }
            if (passed) {
                try {
                    vote.initiator.getPersistentData().m_128379_("democraticcommands_vote_executing", true);
                    CommandSourceStack commandSource = vote.initiator.m_20203_().m_81325_(4);
                    int result = server.m_129892_().m_230957_(commandSource, "/" + vote.command);
                    if (result > 0) {
                        for (ServerPlayer player : players) {
                            player.m_213846_((Component)Component.m_237113_((String)"\u00a7aCommand executed successfully!"));
                        }
                    } else {
                        vote.initiator.m_213846_((Component)Component.m_237113_((String)"\u00a7cCommand returned no success value. Possible syntax issue."));
                    }
                }
                catch (Exception e) {
                    vote.initiator.m_213846_((Component)Component.m_237113_((String)("\u00a7cError executing command: " + e.getMessage())));
                }
            }
            VotingEventHandler.logVote(passed ? "PASSED" : "FAILED", vote);
        }

        private static void updateVoteStatus(ActiveVote vote) {
            MinecraftServer server = vote.initiator.m_20194_();
            List players = server.m_6846_().m_11314_();
            int notVoted = vote.eligibleVoters.size() - vote.yesVotes.size() - vote.noVotes.size();
            MutableComponent statusMessage = Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)("\u00a7eVote status: \u00a7a" + vote.yesVotes.size() + " YES \u00a77| \u00a7c" + vote.noVotes.size() + " NO \u00a77| \u00a78" + notVoted + " not voted"))).m_7220_((Component)Component.m_237113_((String)(" \u00a77(" + vote.getTimeRemaining() + "s remaining)")));
            for (ServerPlayer player : players) {
                player.m_213846_((Component)statusMessage);
            }
        }

        private static MutableComponent createClickableVote(String display, String command, String hover) {
            return Component.m_237113_((String)display).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)hover))));
        }

        private static void logVote(String status, ActiveVote vote) {
            if (!((Boolean)Config.LOG_VOTES.get()).booleanValue()) {
                return;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timestamp = dateFormat.format(new Date());
            String logEntry = String.format("\n[%s] Vote %s\n%s\n%s\n", timestamp, status, vote.getVoteSummary(), "----------------------------------------");
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(auditLogFile, true));){
                writer.write(logEntry);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class ActiveVote {
        public final String command;
        public final ServerPlayer initiator;
        public final Set<UUID> yesVotes = new HashSet<UUID>();
        public final Set<UUID> noVotes = new HashSet<UUID>();
        public final Set<UUID> abstained = new HashSet<UUID>();
        public final Map<UUID, String> voterNames = new HashMap<UUID, String>();
        public final Set<UUID> eligibleVoters = new HashSet<UUID>();
        public final long startTime;

        public ActiveVote(String command, ServerPlayer initiator, Collection<ServerPlayer> players) {
            this.command = command;
            this.initiator = initiator;
            this.startTime = System.currentTimeMillis();
            for (ServerPlayer player : players) {
                this.eligibleVoters.add(player.m_20148_());
                this.voterNames.put(player.m_20148_(), player.m_7755_().getString());
            }
        }

        public boolean hasVoted(UUID playerId) {
            return this.yesVotes.contains(playerId) || this.noVotes.contains(playerId);
        }

        public void vote(UUID playerId, boolean yes) {
            if (!this.eligibleVoters.contains(playerId)) {
                return;
            }
            this.yesVotes.remove(playerId);
            this.noVotes.remove(playerId);
            this.abstained.remove(playerId);
            if (yes) {
                this.yesVotes.add(playerId);
            } else {
                this.noVotes.add(playerId);
            }
        }

        public void markAbstained() {
            for (UUID voter : this.eligibleVoters) {
                if (this.hasVoted(voter)) continue;
                this.abstained.add(voter);
            }
        }

        public boolean isPassed() {
            int effectiveTotal;
            double participationRate;
            int totalVotes = this.yesVotes.size() + this.noVotes.size();
            if (totalVotes < (Integer)Config.MINIMUM_VOTES_REQUIRED.get()) {
                return false;
            }
            if (((Boolean)Config.REQUIRE_MAJORITY_PARTICIPATION.get()).booleanValue() && (participationRate = (double)totalVotes / (double)this.eligibleVoters.size()) <= 0.5) {
                return false;
            }
            int effectiveNo = this.noVotes.size();
            if (((Boolean)Config.COUNT_ABSTENTIONS_AS_NO.get()).booleanValue()) {
                effectiveNo += this.abstained.size();
            }
            if ((effectiveTotal = this.yesVotes.size() + effectiveNo) == 0) {
                return false;
            }
            double approvalRate = (double)this.yesVotes.size() / (double)effectiveTotal;
            return approvalRate >= (Double)Config.APPROVAL_THRESHOLD.get();
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.startTime > (long)((Integer)Config.VOTE_TIMEOUT.get()).intValue() * 1000L;
        }

        public int getTimeRemaining() {
            return Math.max(0, (Integer)Config.VOTE_TIMEOUT.get() - (int)((System.currentTimeMillis() - this.startTime) / 1000L));
        }

        public String getVoteSummary() {
            StringBuilder summary = new StringBuilder();
            summary.append("Command: /").append(this.command).append("\n");
            summary.append("Initiator: ").append(this.initiator.m_7755_().getString()).append("\n");
            summary.append("YES votes (").append(this.yesVotes.size()).append("): ");
            summary.append(this.yesVotes.stream().map(this.voterNames::get).collect(Collectors.joining(", "))).append("\n");
            summary.append("NO votes (").append(this.noVotes.size()).append("): ");
            summary.append(this.noVotes.stream().map(this.voterNames::get).collect(Collectors.joining(", "))).append("\n");
            summary.append("Abstained (").append(this.abstained.size()).append("): ");
            summary.append(this.abstained.stream().map(this.voterNames::get).collect(Collectors.joining(", "))).append("\n");
            summary.append("Result: ").append(this.isPassed() ? "PASSED" : "FAILED");
            return summary.toString();
        }
    }
}

