/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.blockentity.ChargedAmethystRelayBlockEntity;
import top.ribs.scguns.init.ModBlockEntities;

public class ChargedAmethystRelayBlock
extends BaseEntityBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<NoteBlockInstrument> INSTRUMENT = BlockStateProperties.f_61395_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final int LISTEN_RADIUS = 20;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public ChargedAmethystRelayBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.FALSE)).m_61124_(INSTRUMENT, (Comparable)NoteBlockInstrument.HARP)).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        if (direction == null) {
            return false;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return direction.m_122424_() == facing;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED, INSTRUMENT, FACING});
    }

    private BlockState setInstrument(Level level, BlockPos pos, BlockState state) {
        NoteBlockInstrument instrumentAbove = level.m_8055_(pos.m_7494_()).m_280603_();
        if (instrumentAbove.m_280504_()) {
            return (BlockState)state.m_61124_(INSTRUMENT, (Comparable)instrumentAbove);
        }
        NoteBlockInstrument instrumentBelow = level.m_8055_(pos.m_7495_()).m_280603_();
        NoteBlockInstrument finalInstrument = instrumentBelow.m_280504_() ? NoteBlockInstrument.HARP : instrumentBelow;
        return (BlockState)state.m_61124_(INSTRUMENT, (Comparable)finalInstrument);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.setInstrument(context.m_43725_(), context.m_8083_(), (BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.FALSE)).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_()));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            NoteBlockInstrument currentInstrument = (NoteBlockInstrument)state.m_61143_(INSTRUMENT);
            level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)currentInstrument.m_263188_().m_203334_(), SoundSource.BLOCKS, 3.0f, 1.0f);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                double colorOffset = this.getInstrumentColorOffset(currentInstrument);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, 1, colorOffset, 0.0, 0.0, 0.0);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    private double getInstrumentColorOffset(NoteBlockInstrument instrument) {
        int instrumentIndex = instrument.ordinal();
        int totalInstruments = NoteBlockInstrument.values().length;
        return (double)instrumentIndex / (double)totalInstruments;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        boolean flag = facing.m_122434_() == Direction.Axis.Y;
        return flag ? this.setInstrument((Level)level, currentPos, state) : super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockState newState = this.setInstrument(level, pos, state);
        if (!newState.equals(state)) {
            level.m_7731_(pos, newState, 3);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ChargedAmethystRelayBlockEntity) {
                ChargedAmethystRelayBlockEntity relay = (ChargedAmethystRelayBlockEntity)blockEntity;
                relay.onInstrumentTuned((NoteBlockInstrument)newState.m_61143_(INSTRUMENT));
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ChargedAmethystRelayBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : ChargedAmethystRelayBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.CHARGED_AMETHYST_RELAY.get()), ChargedAmethystRelayBlockEntity::serverTick);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7899_(BlockState state) {
        return (Boolean)state.m_61143_((Property)POWERED);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (!((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue()) {
            return 0;
        }
        Direction facing = (Direction)blockState.m_61143_((Property)FACING);
        return side.m_122424_() == facing ? 15 : 0;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (!((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue()) {
            return 0;
        }
        Direction facing = (Direction)blockState.m_61143_((Property)FACING);
        return side.m_122424_() == facing ? 15 : 0;
    }

    public void onInstrumentHeard(Level level, BlockPos relayPos, NoteBlockInstrument playedInstrument) {
        NoteBlockInstrument tunedInstrument;
        BlockState state = level.m_8055_(relayPos);
        if (state.m_60734_() == this && playedInstrument == (tunedInstrument = (NoteBlockInstrument)state.m_61143_(INSTRUMENT))) {
            BlockEntity blockEntity = level.m_7702_(relayPos);
            if (blockEntity instanceof ChargedAmethystRelayBlockEntity) {
                ChargedAmethystRelayBlockEntity relay = (ChargedAmethystRelayBlockEntity)blockEntity;
                relay.activateFromInstrument();
            }
            level.m_7731_(relayPos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 7);
            level.m_7260_(relayPos, state, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
            level.m_186460_(relayPos, (Block)this, 20);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 7);
            level.m_7260_(pos, state, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ChargedAmethystRelayBlockEntity) {
                ChargedAmethystRelayBlockEntity relay = (ChargedAmethystRelayBlockEntity)blockEntity;
                relay.deactivate();
            }
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof ChargedAmethystRelayBlockEntity) {
            ChargedAmethystRelayBlockEntity relay = (ChargedAmethystRelayBlockEntity)blockEntity;
            relay.deactivate();
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }
}

