/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.block;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.blockentity.MineUnitBlockEntity;
import top.ribs.scguns.init.ModBlockEntities;
import top.ribs.scguns.init.ModTags;

public class MineUnitBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty PRIMED = BooleanProperty.m_61465_((String)"primed");
    private static final VoxelShape UNPRIMED_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    private static final VoxelShape PRIMED_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.1, (double)16.0);

    public MineUnitBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)PRIMED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PRIMED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)PRIMED) != false ? PRIMED_SHAPE : UNPRIMED_SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MineUnitBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == ModBlockEntities.MINE_UNIT.get() ? MineUnitBlockEntity::tick : null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof MineUnitBlockEntity)) {
            return InteractionResult.PASS;
        }
        MineUnitBlockEntity mineUnit = (MineUnitBlockEntity)blockEntity;
        if (mineUnit.isPrimed()) {
            return InteractionResult.PASS;
        }
        if (heldItem.m_204117_(ModTags.Items.GRENADES) && !mineUnit.hasGrenade()) {
            if (!level.m_5776_()) {
                ItemStack grenadeStack = heldItem.m_41777_();
                grenadeStack.m_41764_(1);
                mineUnit.setGrenade(grenadeStack, (LivingEntity)player);
                if (!player.m_7500_()) {
                    heldItem.m_41774_(1);
                }
                level.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.spawnLoadingParticles(level, pos);
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (mineUnit.hasGrenade()) {
            if (!level.m_5776_()) {
                mineUnit.setPrimed(true);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)PRIMED, (Comparable)Boolean.valueOf(true)), 3);
                level.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.8f, 1.2f);
                level.m_5594_(null, pos, SoundEvents.f_12524_, SoundSource.BLOCKS, 0.6f, 0.9f);
                this.spawnPrimingParticles(level, pos);
            } else {
                player.m_6674_(hand);
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (level.m_5776_()) {
            player.m_5661_((Component)Component.m_237115_((String)"message.scguns.mine_unit.needs_grenade").m_130940_(ChatFormatting.RED), true);
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    private void spawnLoadingParticles(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 8; ++i) {
                double offsetX = (double)pos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 0.4;
                double offsetY = (double)pos.m_123342_() + 0.2;
                double offsetZ = (double)pos.m_123343_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 0.4;
                double velocityX = (level.f_46441_.m_188500_() - 0.5) * 0.1;
                double velocityY = level.f_46441_.m_188500_() * 0.05;
                double velocityZ = (level.f_46441_.m_188500_() - 0.5) * 0.1;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, offsetX, offsetY, offsetZ, 1, velocityX, velocityY, velocityZ, 0.05);
            }
        }
    }

    private void spawnPrimingParticles(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos belowPos = pos.m_7495_();
            BlockState belowState = level.m_8055_(belowPos);
            if (!belowState.m_60795_()) {
                for (int i = 0; i < 15; ++i) {
                    double offsetX = (double)pos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 0.6;
                    double offsetY = (double)pos.m_123342_() + 0.1;
                    double offsetZ = (double)pos.m_123343_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 0.6;
                    double velocityX = (level.f_46441_.m_188500_() - 0.5) * 0.15;
                    double velocityY = level.f_46441_.m_188500_() * 0.1;
                    double velocityZ = (level.f_46441_.m_188500_() - 0.5) * 0.15;
                    serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, belowState), offsetX, offsetY, offsetZ, 1, velocityX, velocityY, velocityZ, 0.1);
                }
            }
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof MineUnitBlockEntity) {
                MineUnitBlockEntity mineUnit = (MineUnitBlockEntity)blockEntity;
                mineUnit.dropGrenade();
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }
}

