/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import top.ribs.scguns.blockentity.PenetratorBlockEntity;

public class PenetratorBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = DirectionProperty.m_61549_((String)"facing", (Direction[])Direction.values());
    private final int tunnelLength;

    public PenetratorBlock(BlockBehaviour.Properties pProperties, int tunnelLength) {
        super(pProperties);
        this.tunnelLength = tunnelLength;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.SOUTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction facing = pContext.m_43723_() != null && pContext.m_43723_().m_6144_() ? pContext.m_43719_() : pContext.m_8125_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        Direction facing;
        Direction connectionSide = facing = (Direction)state.m_61143_((Property)FACING);
        return side == null || side == connectionSide;
    }

    public boolean m_7899_(BlockState pState) {
        return false;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_) {
            BlockEntity blockEntity;
            Direction facing;
            Direction connectionSide = facing = (Direction)state.m_61143_((Property)FACING);
            BlockPos connectionPos = pos.m_121945_(connectionSide);
            boolean shouldActivate = false;
            if (fromPos.equals((Object)connectionPos)) {
                shouldActivate = level.m_276867_(pos) || level.m_277185_(connectionPos, connectionSide) > 0;
            } else {
                boolean bl = shouldActivate = level.m_277185_(connectionPos, connectionSide) > 0 || level.m_276867_(pos);
            }
            if (shouldActivate && (blockEntity = level.m_7702_(pos)) instanceof PenetratorBlockEntity) {
                PenetratorBlockEntity.tick(level, pos, state, (PenetratorBlockEntity)blockEntity);
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PenetratorBlockEntity(pos, state);
    }

    public int getTunnelLength() {
        return this.tunnelLength;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }
}

