/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SandbagBlock
extends Block {
    public static final EnumProperty<SandbagType> TYPE = EnumProperty.m_61587_((String)"type", SandbagType.class);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape SHAPE_SINGLE_NORTH_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)6.0, (double)12.0);
    private static final VoxelShape SHAPE_DOUBLE_NORTH_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)11.0, (double)12.0);
    private static final VoxelShape SHAPE_TRIPLE_NORTH_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private static final VoxelShape SHAPE_SINGLE_EAST_WEST = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)6.0, (double)16.0);
    private static final VoxelShape SHAPE_DOUBLE_EAST_WEST = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)11.0, (double)16.0);
    private static final VoxelShape SHAPE_TRIPLE_EAST_WEST = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);

    public SandbagBlock(BlockBehaviour.Properties properties) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49992_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(TYPE, (Comparable)((Object)SandbagType.SINGLE))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, FACING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        switch ((SandbagType)((Object)state.m_61143_(TYPE))) {
            case DOUBLE: {
                return direction == Direction.NORTH || direction == Direction.SOUTH ? SHAPE_DOUBLE_NORTH_SOUTH : SHAPE_DOUBLE_EAST_WEST;
            }
            case TRIPLE: {
                return direction == Direction.NORTH || direction == Direction.SOUTH ? SHAPE_TRIPLE_NORTH_SOUTH : SHAPE_TRIPLE_EAST_WEST;
            }
        }
        return direction == Direction.NORTH || direction == Direction.SOUTH ? SHAPE_SINGLE_NORTH_SOUTH : SHAPE_SINGLE_EAST_WEST;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        BlockState state = world.m_8055_(pos);
        if (state.m_60713_((Block)this)) {
            if (state.m_61143_(TYPE) == SandbagType.SINGLE) {
                return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)SandbagType.DOUBLE));
            }
            if (state.m_61143_(TYPE) == SandbagType.DOUBLE) {
                return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)SandbagType.TRIPLE));
            }
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_(TYPE, (Comparable)((Object)SandbagType.SINGLE));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_21120_(hand).m_41720_() == this.m_5456_()) {
            if (state.m_61143_(TYPE) == SandbagType.SINGLE) {
                world.m_7731_(pos, (BlockState)state.m_61124_(TYPE, (Comparable)((Object)SandbagType.DOUBLE)), 3);
                world.m_142346_((Entity)player, GameEvent.f_157792_, pos);
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (state.m_61143_(TYPE) == SandbagType.DOUBLE) {
                world.m_7731_(pos, (BlockState)state.m_61124_(TYPE, (Comparable)((Object)SandbagType.TRIPLE)), 3);
                world.m_142346_((Entity)player, GameEvent.f_157792_, pos);
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (player.m_6144_() && player.m_21120_(hand).m_41619_()) {
            if (state.m_61143_(TYPE) == SandbagType.TRIPLE) {
                world.m_7731_(pos, (BlockState)state.m_61124_(TYPE, (Comparable)((Object)SandbagType.DOUBLE)), 3);
            } else if (state.m_61143_(TYPE) == SandbagType.DOUBLE) {
                world.m_7731_(pos, (BlockState)state.m_61124_(TYPE, (Comparable)((Object)SandbagType.SINGLE)), 3);
            } else if (state.m_61143_(TYPE) == SandbagType.SINGLE) {
                world.m_7471_(pos, false);
            }
            if (!player.m_7500_()) {
                Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this));
            }
            world.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static enum SandbagType implements StringRepresentable
    {
        SINGLE("single"),
        DOUBLE("double"),
        TRIPLE("triple");

        private final String name;

        private SandbagType(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

