/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.blockentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import top.ribs.scguns.block.PenetratorBlock;
import top.ribs.scguns.init.ModBlockEntities;

public class PenetratorBlockEntity
extends BlockEntity {
    public PenetratorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.PENETRATOR.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PenetratorBlockEntity blockEntity) {
        boolean isPowered;
        if (!level.f_46443_ && (isPowered = level.m_276867_(pos))) {
            blockEntity.explode(level, pos, state);
            level.m_7471_(pos, false);
        }
    }

    private void explode(Level level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)PenetratorBlock.FACING);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        level.m_5594_(null, pos, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f);
        ArrayList allDrops = new ArrayList();
        for (int i = 1; i <= ((PenetratorBlock)state.m_60734_()).getTunnelLength(); ++i) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockState targetBlockState;
                    if (facing.m_122434_() == Direction.Axis.X) {
                        mutablePos.m_122154_((Vec3i)pos, facing.m_122429_() * i, y, z);
                    } else if (facing.m_122434_() == Direction.Axis.Y) {
                        mutablePos.m_122154_((Vec3i)pos, z, facing.m_122430_() * i, y);
                    } else {
                        mutablePos.m_122154_((Vec3i)pos, y, z, facing.m_122431_() * i);
                    }
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, (double)mutablePos.m_123341_() + 0.5, (double)mutablePos.m_123342_() + 0.5, (double)mutablePos.m_123343_() + 0.5, 3, 0.1, 0.1, 0.1, 0.0);
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)mutablePos.m_123341_() + 0.5, (double)mutablePos.m_123342_() + 0.5, (double)mutablePos.m_123343_() + 0.5, 6, 0.2, 0.2, 0.2, 0.02);
                    }
                    if ((targetBlockState = level.m_8055_((BlockPos)mutablePos)).m_60713_(Blocks.f_50752_)) continue;
                    if (!targetBlockState.m_60795_()) {
                        List drops = Block.m_49869_((BlockState)targetBlockState, (ServerLevel)((ServerLevel)level), (BlockPos)mutablePos, null);
                        allDrops.addAll(drops);
                        level.m_7731_((BlockPos)mutablePos, Blocks.f_50016_.m_49966_(), 3);
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            serverLevel.m_46796_(2001, (BlockPos)mutablePos, Block.m_49956_((BlockState)targetBlockState));
                        }
                    }
                    this.applyDamageToEntities(level, (BlockPos)mutablePos);
                }
            }
        }
        for (ItemStack item : allDrops) {
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)item);
        }
        this.dropItemsAfterExplosion((ServerLevel)level, pos);
    }

    private void dropItemsAfterExplosion(ServerLevel level, BlockPos pos) {
        TagKey tagKey = ItemTags.create((ResourceLocation)new ResourceLocation("scguns", "penetrator_drops"));
        ArrayList items = new ArrayList();
        BuiltInRegistries.f_257033_.m_206058_(tagKey).forEach(holder -> items.add((Item)holder.m_203334_()));
        Random random = new Random();
        int itemsToDrop = random.nextInt(3) + 3;
        for (int i = 0; i < itemsToDrop; ++i) {
            if (items.isEmpty()) continue;
            Item item = (Item)items.get(random.nextInt(items.size()));
            ItemStack stack = new ItemStack((ItemLike)item, random.nextInt(2) + 1);
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
        }
    }

    private void applyDamageToEntities(Level level, BlockPos pos) {
        List entities = level.m_45933_(null, new AABB((double)pos.m_123341_() - 2.0, (double)pos.m_123342_() - 2.0, (double)pos.m_123343_() - 2.0, (double)pos.m_123341_() + 2.0, (double)pos.m_123342_() + 2.0, (double)pos.m_123343_() + 2.0));
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            DamageSource explosionDamage = serverLevel.m_269111_().m_269093_(null);
            for (Entity entity : entities) {
                double dz;
                double dy;
                double dx;
                double distance;
                float damage;
                if (entity instanceof ItemEntity) continue;
                float f = damage = entity instanceof Player ? 20.0f : 9.0f;
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    if (player.f_8941_.m_9290_() != GameType.SURVIVAL) continue;
                    player.m_6469_(explosionDamage, damage);
                    player.m_36399_(damage * 0.1f);
                    player.m_21153_(player.m_21223_() - damage);
                } else {
                    boolean damaged = entity.m_6469_(explosionDamage, damage);
                    if (!damaged && entity instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity;
                        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19602_, 1, 0));
                    }
                }
                if ((distance = Math.sqrt((dx = entity.m_20185_() - (double)pos.m_123341_()) * dx + (dy = entity.m_20186_() - (double)pos.m_123342_()) * dy + (dz = entity.m_20189_() - (double)pos.m_123343_()) * dz)) == 0.0) continue;
                entity.m_20256_(entity.m_20184_().m_82520_(dx / distance * 0.4, dy / distance * 0.4, dz / distance * 0.4));
            }
        }
    }
}

