/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.blockentity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.Config;
import top.ribs.scguns.client.screen.PolarGeneratorMenu;
import top.ribs.scguns.init.ModBlockEntities;

public class PolarGeneratorBlockEntity
extends BlockEntity
implements MenuProvider,
ICapabilityProvider {
    private final EnergyStorage energyStorage = new EnergyStorage(24000){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int received = super.receiveEnergy(maxReceive, simulate);
            if (!simulate && received > 0) {
                PolarGeneratorBlockEntity.this.m_6596_();
                PolarGeneratorBlockEntity.this.sync();
            }
            return received;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int extracted = super.extractEnergy(maxExtract, simulate);
            if (!simulate && extracted > 0) {
                PolarGeneratorBlockEntity.this.m_6596_();
                PolarGeneratorBlockEntity.this.sync();
            }
            return extracted;
        }
    };
    private final LazyOptional<IEnergyStorage> internalEnergy = LazyOptional.of(() -> this.energyStorage);
    private final LazyOptional<IEnergyStorage> externalEnergy = LazyOptional.of(() -> new EnergyStorage(this.energyStorage.getMaxEnergyStored()){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return PolarGeneratorBlockEntity.this.energyStorage.extractEnergy(maxExtract, simulate);
        }

        public int getEnergyStored() {
            return PolarGeneratorBlockEntity.this.energyStorage.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return PolarGeneratorBlockEntity.this.energyStorage.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return false;
        }
    });
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandlerModifiable> manualHandler = LazyOptional.of(() -> this.itemHandler);
    private final LazyOptional<IItemHandler> topHandler = LazyOptional.of(() -> new InputItemHandler(this.itemHandler));
    private final LazyOptional<IItemHandler> sideHandler = LazyOptional.of(() -> new SideItemHandler(this.itemHandler));
    private int burnTime;
    private int burnTimeTotal;
    private static final float WHEEL_ROTATION_SPEED = 20.0f;
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> PolarGeneratorBlockEntity.this.burnTime;
                case 1 -> PolarGeneratorBlockEntity.this.burnTimeTotal;
                case 2 -> PolarGeneratorBlockEntity.this.energyStorage.getEnergyStored();
                case 3 -> PolarGeneratorBlockEntity.this.energyStorage.getMaxEnergyStored();
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    PolarGeneratorBlockEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    PolarGeneratorBlockEntity.this.burnTimeTotal = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    public PolarGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.POLAR_GENERATOR.get(), pos, state);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"container.polar_generator");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new PolarGeneratorMenu(id, playerInventory, this, this.data);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                PolarGeneratorBlockEntity.this.m_6596_();
                PolarGeneratorBlockEntity.this.sync();
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return slot == 0 && ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0;
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (slot == 0) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return super.extractItem(slot, amount, simulate);
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.manualHandler.cast();
            }
            if (side == Direction.UP) {
                return this.topHandler.cast();
            }
            return this.sideHandler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            if (side == null) {
                return this.internalEnergy.cast();
            }
            return this.externalEnergy.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("polar_generator.burnTime", this.burnTime);
        tag.m_128405_("polar_generator.burnTimeTotal", this.burnTimeTotal);
        tag.m_128365_("Energy", this.energyStorage.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.burnTime = tag.m_128451_("polar_generator.burnTime");
        this.burnTimeTotal = tag.m_128451_("polar_generator.burnTimeTotal");
        this.energyStorage.deserializeNBT(tag.m_128423_("Energy"));
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.handleUpdateTag(tag);
        }
    }

    private void sync() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PolarGeneratorBlockEntity blockEntity) {
        if (!level.f_46443_) {
            boolean isLit;
            int burnTime;
            ItemStack fuelStack;
            if (blockEntity.burnTime > 0) {
                --blockEntity.burnTime;
                blockEntity.energyStorage.receiveEnergy(((Integer)Config.COMMON.gameplay.energyProductionRate.get()).intValue(), false);
                blockEntity.m_6596_();
                blockEntity.sync();
            }
            for (Direction direction : Direction.values()) {
                BlockEntity adjacentEntity = level.m_7702_(pos.m_121945_(direction));
                if (adjacentEntity == null) continue;
                adjacentEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).ifPresent(handler -> {
                    if (handler.canReceive()) {
                        int extracted = blockEntity.energyStorage.extractEnergy(((Integer)Config.COMMON.gameplay.energyProductionRate.get()).intValue(), true);
                        int accepted = handler.receiveEnergy(extracted, false);
                        blockEntity.energyStorage.extractEnergy(accepted, false);
                        blockEntity.m_6596_();
                        blockEntity.sync();
                    }
                });
            }
            if (blockEntity.burnTime == 0 && blockEntity.energyStorage.getEnergyStored() < blockEntity.energyStorage.getMaxEnergyStored() && !(fuelStack = blockEntity.itemHandler.getStackInSlot(0)).m_41619_() && (burnTime = ForgeHooks.getBurnTime((ItemStack)fuelStack, (RecipeType)RecipeType.f_44108_)) > 0) {
                ItemStack remainder;
                blockEntity.burnTime = burnTime;
                blockEntity.burnTimeTotal = burnTime;
                ItemStack containerItem = fuelStack.getCraftingRemainingItem();
                fuelStack.m_41774_(1);
                if (!containerItem.m_41619_() && fuelStack.m_41619_()) {
                    blockEntity.itemHandler.setStackInSlot(0, containerItem);
                } else if (!(containerItem.m_41619_() || fuelStack.m_41619_() || (remainder = blockEntity.itemHandler.insertItem(0, containerItem, false)).m_41619_() || blockEntity.f_58857_ == null)) {
                    Containers.m_18992_((Level)blockEntity.f_58857_, (double)((double)blockEntity.f_58858_.m_123341_() + 0.5), (double)((double)blockEntity.f_58858_.m_123342_() + 1.0), (double)((double)blockEntity.f_58858_.m_123343_() + 0.5), (ItemStack)remainder);
                }
                blockEntity.m_6596_();
                blockEntity.sync();
            }
            boolean bl = isLit = blockEntity.burnTime > 0;
            if ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != isLit) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(isLit)), 3);
            }
        }
    }

    public float getWheelRotation(float partialTicks) {
        assert (this.f_58857_ != null);
        return ((float)this.f_58857_.m_46467_() + partialTicks) * 20.0f % 360.0f;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.f_58857_ != null);
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    private static class SideItemHandler
    implements IItemHandlerModifiable {
        private final ItemStackHandler itemHandler;

        public SideItemHandler(ItemStackHandler itemHandler) {
            this.itemHandler = itemHandler;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            this.itemHandler.setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return this.itemHandler.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.itemHandler.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot == 0 && ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0) {
                return this.itemHandler.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.itemHandler.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.itemHandler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return slot == 0 && ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0;
        }
    }

    private static class InputItemHandler
    implements IItemHandlerModifiable {
        private final ItemStackHandler itemHandler;

        public InputItemHandler(ItemStackHandler itemHandler) {
            this.itemHandler = itemHandler;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            this.itemHandler.setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return this.itemHandler.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.itemHandler.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot == 0 && ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0) {
                return this.itemHandler.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.itemHandler.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.itemHandler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return slot == 0 && ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0;
        }
    }
}

