/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.blockentity;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.block.HostileTurretTargetingBlock;
import top.ribs.scguns.block.PlayerTurretTargetingBlock;
import top.ribs.scguns.block.ShockCoilBlock;
import top.ribs.scguns.block.TurretTargetingBlock;
import top.ribs.scguns.config.ShockCoilConfig;
import top.ribs.scguns.init.ModBlockEntities;

public class ShockCoilBlockEntity
extends BlockEntity {
    private final EnergyStorage energyStorage = new EnergyStorage(ShockCoilConfig.getMaxEnergy()){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int received = super.receiveEnergy(maxReceive, simulate);
            if (!simulate && received > 0) {
                ShockCoilBlockEntity.this.m_6596_();
                ShockCoilBlockEntity.this.updateBlockState();
            }
            return received;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int extracted = super.extractEnergy(maxExtract, simulate);
            if (!simulate && extracted > 0) {
                ShockCoilBlockEntity.this.m_6596_();
                ShockCoilBlockEntity.this.updateBlockState();
            }
            return extracted;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    };
    private final LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> this.energyStorage);
    private int zapCooldown = 0;
    private boolean redstoneDisabled = false;
    private TargetingMode targetingMode = TargetingMode.HOSTILE;

    public ShockCoilBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SHOCK_COIL.get(), pos, state);
    }

    public void setRedstoneDisabled(boolean disabled) {
        this.redstoneDisabled = disabled;
        this.updateBlockState();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ShockCoilBlockEntity blockEntity) {
        if (level == null || level.f_46443_) {
            return;
        }
        blockEntity.updateTargetingMode();
        if (blockEntity.zapCooldown > 0) {
            --blockEntity.zapCooldown;
            return;
        }
        if (blockEntity.redstoneDisabled) {
            blockEntity.updateBlockState();
            return;
        }
        int energyPerZap = ShockCoilConfig.getEnergyPerZap();
        if (blockEntity.energyStorage.getEnergyStored() < energyPerZap) {
            blockEntity.updateBlockState();
            return;
        }
        Predicate<LivingEntity> targetPredicate = blockEntity.getTargetPredicate();
        List nearbyTargets = level.m_6443_(LivingEntity.class, new AABB(pos).m_82400_(ShockCoilConfig.getZapRange()), entity -> entity.m_6084_() && !entity.m_213877_() && targetPredicate.test((LivingEntity)entity));
        if (!nearbyTargets.isEmpty()) {
            int targetsZapped = 0;
            Vec3 coilCenter = Vec3.m_82512_((Vec3i)pos);
            for (LivingEntity target : nearbyTargets) {
                if (targetsZapped >= ShockCoilConfig.getMaxTargetsPerZap() || blockEntity.energyStorage.getEnergyStored() < energyPerZap) break;
                Vec3 targetPos = new Vec3(target.m_20185_(), target.m_20186_() + (double)target.m_20192_() * 0.5, target.m_20189_());
                blockEntity.zapTarget(target, coilCenter, targetPos);
                blockEntity.energyStorage.extractEnergy(energyPerZap, false);
                ++targetsZapped;
            }
            if (targetsZapped > 0) {
                blockEntity.zapCooldown = ShockCoilConfig.getZapCooldown();
                blockEntity.m_6596_();
            }
        }
    }

    private void updateTargetingMode() {
        if (this.f_58857_ == null) {
            return;
        }
        boolean hasPlayerModule = false;
        boolean hasHostileModule = false;
        boolean hasBaseModule = false;
        for (Direction direction : Direction.values()) {
            BlockState adjacentState = this.f_58857_.m_8055_(this.f_58858_.m_121945_(direction));
            if (adjacentState.m_60734_() instanceof PlayerTurretTargetingBlock) {
                hasPlayerModule = true;
                continue;
            }
            if (adjacentState.m_60734_() instanceof HostileTurretTargetingBlock) {
                hasHostileModule = true;
                continue;
            }
            if (!(adjacentState.m_60734_() instanceof TurretTargetingBlock) || adjacentState.m_60734_() instanceof PlayerTurretTargetingBlock || adjacentState.m_60734_() instanceof HostileTurretTargetingBlock) continue;
            hasBaseModule = true;
        }
        TargetingMode newMode = hasPlayerModule ? TargetingMode.PLAYER : (hasBaseModule ? TargetingMode.ALL : TargetingMode.HOSTILE);
        if (this.targetingMode != newMode) {
            this.targetingMode = newMode;
            this.m_6596_();
        }
    }

    private Predicate<LivingEntity> getTargetPredicate() {
        return switch (this.targetingMode) {
            default -> throw new IncompatibleClassChangeError();
            case TargetingMode.HOSTILE -> entity -> entity instanceof Monster;
            case TargetingMode.PLAYER -> entity -> entity instanceof Player;
            case TargetingMode.ALL -> entity -> true;
        };
    }

    private void zapTarget(LivingEntity target, Vec3 start, Vec3 end) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.spawnLightningArc(serverLevel, start, end);
            String soundId = ShockCoilConfig.getZapSound();
            SoundEvent soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(soundId));
            if (soundEvent != null) {
                serverLevel.m_5594_(null, this.f_58858_, soundEvent, SoundSource.BLOCKS, 0.8f, 1.0f);
            }
            target.m_6469_(this.f_58857_.m_269111_().m_269548_(), ShockCoilConfig.getBaseDamage());
            for (ShockCoilConfig.StatusEffect statusEffect : ShockCoilConfig.getStatusEffects()) {
                if (!(this.f_58857_.f_46441_.m_188501_() < statusEffect.getChance())) continue;
                target.m_7292_(new MobEffectInstance(statusEffect.getEffect(), statusEffect.getDuration(), statusEffect.getAmplifier()));
            }
        }
    }

    private void spawnLightningArc(ServerLevel serverLevel, Vec3 start, Vec3 end) {
        Vec3 direction = end.m_82546_(start);
        double distance = direction.m_82553_();
        direction = direction.m_82541_();
        double stepSize = 0.15;
        for (double d = 0.0; d < distance; d += stepSize) {
            Vec3 particlePos = start.m_82549_(direction.m_82490_(d));
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.05, 0.05, 0.05, 0.0);
        }
    }

    private void updateBlockState() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            boolean isPowered = !this.redstoneDisabled && this.energyStorage.getEnergyStored() >= ShockCoilConfig.getEnergyPerZap();
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)ShockCoilBlock.POWERED, (Comparable)Boolean.valueOf(isPowered)), 3);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyHandler.invalidate();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Energy", this.energyStorage.serializeNBT());
        tag.m_128405_("ZapCooldown", this.zapCooldown);
        tag.m_128379_("RedstoneDisabled", this.redstoneDisabled);
        tag.m_128359_("TargetingMode", this.targetingMode.name());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.energyStorage.deserializeNBT(tag.m_128423_("Energy"));
        this.zapCooldown = tag.m_128451_("ZapCooldown");
        this.redstoneDisabled = tag.m_128471_("RedstoneDisabled");
        if (tag.m_128441_("TargetingMode")) {
            try {
                this.targetingMode = TargetingMode.valueOf(tag.m_128461_("TargetingMode"));
            }
            catch (IllegalArgumentException e) {
                this.targetingMode = TargetingMode.HOSTILE;
            }
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(0);
        assert (this.f_58857_ != null);
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergy() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public TargetingMode getTargetingMode() {
        return this.targetingMode;
    }

    public static enum TargetingMode {
        HOSTILE,
        PLAYER,
        ALL;

    }
}

