/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.handler;

import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.glfw.GLFW;
import top.ribs.scguns.common.exosuit.ExoSuitUpgrade;
import top.ribs.scguns.common.exosuit.ExoSuitUpgradeManager;
import top.ribs.scguns.item.animated.ExoSuitItem;
import top.ribs.scguns.item.exosuit.EnergyUpgradeItem;
import top.ribs.scguns.item.exosuit.GasMaskModuleItem;
import top.ribs.scguns.item.exosuit.RebreatherModuleItem;
import top.ribs.scguns.item.exosuit.TargetTrackerModuleItem;

@Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ExoSuitUpgradeTooltipHandler {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        ExoSuitUpgrade upgrade = ExoSuitUpgradeManager.getUpgradeForItem(stack);
        if (upgrade != null) {
            List tooltip = event.getToolTip();
            boolean showDetailed = ExoSuitUpgradeTooltipHandler.isShiftPressed();
            ExoSuitUpgradeTooltipHandler.addUpgradeTooltip(tooltip, upgrade, stack, showDetailed);
        }
    }

    private static boolean isShiftPressed() {
        return GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) == 1 || GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344) == 1;
    }

    private static void addUpgradeTooltip(List<Component> tooltip, ExoSuitUpgrade upgrade, ItemStack stack, boolean showDetailed) {
        tooltip.add((Component)Component.m_237113_((String)""));
        String upgradeType = upgrade.getType();
        String formattedType = ExoSuitUpgradeTooltipHandler.formatUpgradeType(upgradeType);
        tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.upgrade.type").m_130946_(formattedType).m_130940_(ChatFormatting.GRAY));
        ExoSuitUpgradeTooltipHandler.addSlotCompatibility(tooltip, upgradeType);
        if (!showDetailed) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.upgrade.hold_shift").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            return;
        }
        ExoSuitUpgradeTooltipHandler.addSpecialFunctionality(tooltip, stack, upgrade);
        ExoSuitUpgradeTooltipHandler.addEffectsTooltip(tooltip, upgrade.getEffects());
        Item item = stack.m_41720_();
        if (item instanceof EnergyUpgradeItem) {
            EnergyUpgradeItem energyUpgrade = (EnergyUpgradeItem)item;
            ExoSuitUpgradeTooltipHandler.addEnergyTooltip(tooltip, energyUpgrade);
        }
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.upgrade.install_hint").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
    }

    private static void addEffectsTooltip(List<Component> tooltip, ExoSuitUpgrade.Effects effects) {
        if (effects.getArmorBonus() > 0.0f || effects.getArmorToughness() > 0.0f || effects.getKnockbackResistance() > 0.0f) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.upgrade.effects.defensive").m_130940_(ChatFormatting.GRAY));
            if (effects.getArmorBonus() > 0.0f) {
                tooltip.add((Component)Component.m_237113_((String)" \u2022 ").m_7220_((Component)Component.m_237110_((String)"tooltip.scguns.exosuit.upgrade.stat.armor", (Object[])new Object[]{Float.valueOf(effects.getArmorBonus())})).m_130940_(ChatFormatting.GRAY));
            }
            if (effects.getArmorToughness() > 0.0f) {
                tooltip.add((Component)Component.m_237113_((String)" \u2022 ").m_7220_((Component)Component.m_237110_((String)"tooltip.scguns.exosuit.upgrade.stat.armor_toughness", (Object[])new Object[]{Float.valueOf(effects.getArmorToughness())})).m_130940_(ChatFormatting.GRAY));
            }
            if (effects.getKnockbackResistance() > 0.0f) {
                tooltip.add((Component)Component.m_237113_((String)" \u2022 ").m_7220_((Component)Component.m_237110_((String)"tooltip.scguns.exosuit.upgrade.stat.knockback_resistance", (Object[])new Object[]{(int)(effects.getKnockbackResistance() * 100.0f)})).m_130940_(ChatFormatting.GRAY));
            }
        }
        if (effects.getSpeedModifier() != 0.0f || effects.getJumpBoost() > 0.0f || effects.getFallDamageReduction() > 0.0f) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.upgrade.effects.mobility").m_130940_(ChatFormatting.GRAY));
            if (effects.getSpeedModifier() != 0.0f) {
                String speedKey = effects.getSpeedModifier() > 0.0f ? "tooltip.scguns.exosuit.upgrade.stat.speed_positive" : "tooltip.scguns.exosuit.upgrade.stat.speed_negative";
                ChatFormatting color = effects.getSpeedModifier() > 0.0f ? ChatFormatting.GRAY : ChatFormatting.DARK_GRAY;
                tooltip.add((Component)Component.m_237113_((String)" \u2022 ").m_7220_((Component)Component.m_237110_((String)speedKey, (Object[])new Object[]{Math.abs((int)(effects.getSpeedModifier() * 100.0f))})).m_130940_(color));
            }
            if (effects.getJumpBoost() > 0.0f) {
                tooltip.add((Component)Component.m_237113_((String)" \u2022 ").m_7220_((Component)Component.m_237110_((String)"tooltip.scguns.exosuit.upgrade.stat.jump", (Object[])new Object[]{(int)(effects.getJumpBoost() * 100.0f)})).m_130940_(ChatFormatting.GRAY));
            }
            if (effects.getFallDamageReduction() > 0.0f) {
                tooltip.add((Component)Component.m_237113_((String)" \u2022 ").m_7220_((Component)Component.m_237110_((String)"tooltip.scguns.exosuit.upgrade.stat.fall_damage_reduction", (Object[])new Object[]{(int)(effects.getFallDamageReduction() * 100.0f)})).m_130940_(ChatFormatting.GRAY));
            }
        }
        if (effects.getRecoilAngleReduction() > 0.0f || effects.getRecoilKickReduction() > 0.0f || effects.getSpreadReduction() > 0.0f) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.upgrade.effects.combat").m_130940_(ChatFormatting.GRAY));
            if (effects.getRecoilAngleReduction() > 0.0f) {
                tooltip.add((Component)Component.m_237113_((String)" \u2022 ").m_7220_((Component)Component.m_237110_((String)"tooltip.scguns.exosuit.upgrade.stat.recoil_angle", (Object[])new Object[]{(int)(effects.getRecoilAngleReduction() * 100.0f)})).m_130940_(ChatFormatting.GRAY));
            }
            if (effects.getRecoilKickReduction() > 0.0f) {
                tooltip.add((Component)Component.m_237113_((String)" \u2022 ").m_7220_((Component)Component.m_237110_((String)"tooltip.scguns.exosuit.upgrade.stat.recoil_kick", (Object[])new Object[]{(int)(effects.getRecoilKickReduction() * 100.0f)})).m_130940_(ChatFormatting.GRAY));
            }
            if (effects.getSpreadReduction() > 0.0f) {
                tooltip.add((Component)Component.m_237113_((String)" \u2022 ").m_7220_((Component)Component.m_237110_((String)"tooltip.scguns.exosuit.upgrade.stat.spread_reduction", (Object[])new Object[]{(int)(effects.getSpreadReduction() * 100.0f)})).m_130940_(ChatFormatting.GRAY));
            }
        }
        if (effects.hasNightVision()) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.upgrade.effects.special").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)" \u2022 ").m_7220_((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.upgrade.stat.night_vision")).m_130940_(ChatFormatting.GRAY));
        }
    }

    private static void addSlotCompatibility(List<Component> tooltip, String upgradeType) {
        String slotKey;
        switch (upgradeType) {
            case "pouches": {
                String string = "tooltip.scguns.exosuit.slots.chest_only";
                break;
            }
            case "utility": {
                String string = "tooltip.scguns.exosuit.slots.chest_legs_utility";
                break;
            }
            case "knee_guard": {
                String string = "tooltip.scguns.exosuit.slots.legs_only";
                break;
            }
            case "mobility": {
                String string = "tooltip.scguns.exosuit.slots.boots_only";
                break;
            }
            case "hud": 
            case "breathing": {
                String string = "tooltip.scguns.exosuit.slots.helmet_only";
                break;
            }
            case "pauldron": {
                String string = "tooltip.scguns.exosuit.slots.chest_shoulders";
                break;
            }
            case "plating": {
                String string = "tooltip.scguns.exosuit.slots.helmet_chest_legs";
                break;
            }
            case "power_core": {
                String string = "tooltip.scguns.exosuit.slots.chest_power";
                break;
            }
            default: {
                String string = slotKey = null;
            }
        }
        if (slotKey != null) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.compatible_slots").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237115_((String)slotKey).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC})));
        }
    }

    private static void addSpecialFunctionality(List<Component> tooltip, ItemStack stack, ExoSuitUpgrade upgrade) {
        if (stack.m_41720_() instanceof RebreatherModuleItem) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.functionality.header").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)" \u2022 ").m_7220_((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.functionality.rebreather.water_breathing")).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)" \u2022 ").m_7220_((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.functionality.rebreather.unlimited_exploration")).m_130940_(ChatFormatting.GRAY));
        } else if (stack.m_41720_() instanceof TargetTrackerModuleItem) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.functionality.header").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)" \u2022 ").m_7220_((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.functionality.target_tracker.highlights")).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)" \u2022 ").m_7220_((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.functionality.target_tracker.accuracy")).m_130940_(ChatFormatting.GRAY));
        } else if (stack.m_41720_() instanceof GasMaskModuleItem) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.functionality.header").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)" \u2022 ").m_7220_((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.functionality.gas_mask.toxic_protection")).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)" \u2022 ").m_7220_((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.functionality.gas_mask.environmental_filter")).m_130940_(ChatFormatting.GRAY));
        } else if (upgrade.getType().equals("pouches")) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.functionality.header").m_130940_(ChatFormatting.GRAY));
            int storageSize = upgrade.getDisplay().getStorageSize();
            tooltip.add((Component)Component.m_237113_((String)" \u2022 ").m_7220_((Component)Component.m_237110_((String)"tooltip.scguns.exosuit.functionality.pouches.storage", (Object[])new Object[]{storageSize})).m_130940_(ChatFormatting.GRAY));
            ExoSuitUpgradeTooltipHandler.addPouchContentStatus(tooltip, stack);
        }
    }

    private static void addPouchContentStatus(List<Component> tooltip, ItemStack pouchStack) {
        ExoSuitItem exosuit;
        ItemStack armorStack;
        Item item;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Iterator iterator = player.m_6168_().iterator();
        while (iterator.hasNext() && (!((item = (armorStack = (ItemStack)iterator.next()).m_41720_()) instanceof ExoSuitItem) || (exosuit = (ExoSuitItem)item).m_266204_() != ArmorItem.Type.CHESTPLATE)) {
        }
    }

    private static void addEnergyTooltip(List<Component> tooltip, EnergyUpgradeItem energyUpgrade) {
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.energy.header").m_130940_(ChatFormatting.GRAY));
        String consumptionKey = switch (energyUpgrade.getConsumptionType()) {
            default -> throw new IncompatibleClassChangeError();
            case EnergyUpgradeItem.EnergyConsumptionType.PER_TICK -> "tooltip.scguns.exosuit.energy.consumption.per_tick";
            case EnergyUpgradeItem.EnergyConsumptionType.PER_USE -> "tooltip.scguns.exosuit.energy.consumption.per_use";
            case EnergyUpgradeItem.EnergyConsumptionType.PER_SECOND -> "tooltip.scguns.exosuit.energy.consumption.per_second";
            case EnergyUpgradeItem.EnergyConsumptionType.ACTIVATION -> "tooltip.scguns.exosuit.energy.consumption.activation";
        };
        tooltip.add((Component)Component.m_237113_((String)" \u2022 ").m_7220_((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.energy.consumption.label")).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237110_((String)consumptionKey, (Object[])new Object[]{energyUpgrade.getEnergyConsumption()}).m_130940_(ChatFormatting.GRAY)));
        if (!energyUpgrade.canFunctionWithoutPower()) {
            tooltip.add((Component)Component.m_237113_((String)" \u2022 ").m_7220_((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.energy.requires_power")).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.ITALIC}));
        }
    }

    private static String formatUpgradeType(String type) {
        return switch (type) {
            case "plating" -> Component.m_237115_((String)"tooltip.scguns.exosuit.upgrade.plating").getString();
            case "hud" -> Component.m_237115_((String)"tooltip.scguns.exosuit.upgrade.hud").getString();
            case "breathing" -> Component.m_237115_((String)"tooltip.scguns.exosuit.upgrade.breathing").getString();
            case "pauldron" -> Component.m_237115_((String)"tooltip.scguns.exosuit.upgrade.pauldron").getString();
            case "power_core" -> Component.m_237115_((String)"tooltip.scguns.exosuit.upgrade.power_core").getString();
            case "utility" -> Component.m_237115_((String)"tooltip.scguns.exosuit.upgrade.utility").getString();
            case "pouches" -> Component.m_237115_((String)"tooltip.scguns.exosuit.upgrade.pouches").getString();
            case "knee_guard" -> Component.m_237115_((String)"tooltip.scguns.exosuit.upgrade.knee_guard").getString();
            case "mobility" -> Component.m_237115_((String)"tooltip.scguns.exosuit.upgrade.mobility").getString();
            default -> type.substring(0, 1).toUpperCase() + type.substring(1).replace("_", " ");
        };
    }
}

