/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.handler;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.DamageEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationController;
import top.ribs.scguns.client.handler.ClientMeleeAttackHandler;
import top.ribs.scguns.client.handler.GunRenderingHandler;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.common.ReloadType;
import top.ribs.scguns.enchantment.CorrodedEnchantment;
import top.ribs.scguns.event.GunEventBus;
import top.ribs.scguns.init.ModEnchantments;
import top.ribs.scguns.init.ModSyncedDataKeys;
import top.ribs.scguns.init.ModTags;
import top.ribs.scguns.item.BayonetItem;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.item.animated.AnimatedGunItem;
import top.ribs.scguns.item.attachment.IAttachment;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.C2SMessageReload;
import top.ribs.scguns.network.message.S2CMessageMeleeAttack;
import top.ribs.scguns.util.GunModifierHelper;

public class MeleeAttackHandler {
    private static final float ENCHANTMENT_DAMAGE_SCALING_FACTOR = 0.7f;
    private static final float BASE_SPEED_DAMAGE_SCALING_FACTOR = 0.0f;
    private static final float[] BANZAI_SCALING_FACTORS = new float[]{3.0f, 5.5f, 7.0f};
    private static final String WALL_COLLISION_COOLDOWN_TAG = "WallCollisionCooldown";
    private static final String MELEE_COOLDOWN_TAG = "MeleeCooldown";
    private static final int KNOCKBACK_GRACE_PERIOD_TICKS = 5;
    private static final String KNOCKBACK_GRACE_TAG = "KnockbackGracePeriod";
    private static boolean isBanzai = false;
    private static final int WALL_COLLISION_COOLDOWN_TICKS = 20;
    private static final double WALL_CHECK_DISTANCE = 1.0;
    private static final double[] WALL_CHECK_ANGLES = new double[]{0.0, 10.0, -10.0, 20.0, -20.0, 30.0, -30.0};
    private static final String BANZAI_DAMAGE_COOLDOWN_TAG = "BanzaiDamageCooldown";
    private static final int BANZAI_DAMAGE_COOLDOWN_TICKS = 25;
    private static final double BANZAI_AOE_RADIUS = 1.5;
    private static ItemStack banzaiActiveItem = ItemStack.f_41583_;

    public static boolean isBanzaiActive() {
        return isBanzai;
    }

    public static void startBanzai(ServerPlayer player) {
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        Item item = heldItem.m_41720_();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        if (!gunItem.hasBayonet(heldItem)) {
            MeleeAttackHandler.performMeleeAttack(player);
            return;
        }
        isBanzai = true;
        banzaiActiveItem = heldItem.m_41777_();
    }

    public static void stopBanzai() {
        isBanzai = false;
        banzaiActiveItem = ItemStack.f_41583_;
    }

    public static void performMeleeAttack(ServerPlayer player) {
        CompoundTag tag;
        if (player == null) {
            return;
        }
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        Item item = heldItem.m_41720_();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        if (MeleeAttackHandler.isMeleeOnCooldown((Player)player, heldItem)) {
            return;
        }
        Item item2 = heldItem.m_41720_();
        if (item2 instanceof AnimatedGunItem) {
            AnimatedGunItem animatedGunItem = (AnimatedGunItem)item2;
            tag = heldItem.m_41783_();
            long id = GeoItem.getId((ItemStack)heldItem);
            AnimationController animationController = (AnimationController)animatedGunItem.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
            if (tag != null && tag.m_128471_("scguns:IsReloading")) {
                Gun gun = gunItem.getModifiedGun(heldItem);
                if (gun.getReloads().getReloadType() == ReloadType.MAG_FED) {
                    tag.m_128473_("scguns:IsReloading");
                    ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageReload(false));
                    if (animationController != null) {
                        animationController.forceAnimationReset();
                    }
                } else if (gun.getReloads().getReloadType() == ReloadType.MANUAL && animationController != null && (animatedGunItem.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "reload_loop") || animatedGunItem.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "reload_start"))) {
                    tag.m_128379_("scguns:ReloadComplete", true);
                    animationController.tryTriggerAnimation("reload_stop");
                    tag.m_128473_("scguns:IsReloading");
                    ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageReload(false));
                }
            }
        }
        MeleeAttackHandler.setMeleeCooldown((Player)player, heldItem, gunItem);
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (heldItem.m_41720_() instanceof AnimatedGunItem) {
            AnimationController controller;
            Gun gun = gunItem.getModifiedGun(heldItem);
            if (gun.getGeneral().usesCustomMeleeAnimation()) {
                tag = heldItem.m_41784_();
                tag.m_128379_("scguns:IsMelee", true);
                tag.m_128356_("MeleeStartTime", System.currentTimeMillis());
                ModSyncedDataKeys.MELEE.setValue((Entity)player, (Object)true);
            }
            if ((controller = (AnimationController)((AnimatedGunItem)heldItem.m_41720_()).getAnimatableInstanceCache().getManagerForId(GeoItem.getId((ItemStack)heldItem)).getAnimationControllers().get("controller")) != null && ((AnimatedGunItem)heldItem.m_41720_()).isAnimationPlaying((AnimationController<GeoAnimatable>)controller, "inspect")) {
                controller.tryTriggerAnimation("idle");
            }
        }
        PacketHandler.getPlayChannel().sendToPlayer(() -> player, (IMessage)new S2CMessageMeleeAttack(heldItem));
        LivingEntity target = MeleeAttackHandler.findTargetWithinReach((Player)player, heldItem);
        if (target != null && target != player) {
            MeleeAttackHandler.performMeleeAttackOnTarget(player, target, false);
            MeleeAttackHandler.damageGunAndAttachments(heldItem, (Player)player);
        } else {
            HitResult hitResult = MeleeAttackHandler.rayTraceBlocks((Player)player, heldItem);
            if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                BlockPos pos = blockHitResult.m_82425_();
                BlockState blockState = player.m_9236_().m_8055_(pos);
                ClientboundLevelParticlesPacket particlePacket = MeleeAttackHandler.getClientboundLevelParticlesPacket(blockHitResult, blockState);
                player.f_8906_.m_9829_((Packet)particlePacket);
            }
        }
    }

    @NotNull
    private static ClientboundLevelParticlesPacket getClientboundLevelParticlesPacket(BlockHitResult blockHitResult, BlockState blockState) {
        Vec3 hitVec = blockHitResult.m_82450_();
        BlockParticleOption particleData = new BlockParticleOption(ParticleTypes.f_123794_, blockState);
        return new ClientboundLevelParticlesPacket((ParticleOptions)particleData, true, hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, 0.0f, 0.0f, 0.0f, 0.1f, 10);
    }

    private static HitResult rayTraceBlocks(Player player, ItemStack heldItem) {
        GunItem gunItem = (GunItem)heldItem.m_41720_();
        float reach = gunItem.getModifiedGun(heldItem).getGeneral().getMeleeReach();
        Vec3 eyePosition = player.m_20299_(1.0f);
        Vec3 lookVector = player.m_20154_();
        Vec3 reachVector = eyePosition.m_82549_(lookVector.m_82490_((double)reach));
        return player.m_9236_().m_45547_(new ClipContext(eyePosition, reachVector, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
    }

    private static LivingEntity findTargetWithinReach(Player player, ItemStack heldItem) {
        GunItem gunItem = (GunItem)heldItem.m_41720_();
        float reach = gunItem.getModifiedGun(heldItem).getGeneral().getMeleeReach();
        AABB boundingBox = player.m_20191_().m_82377_((double)reach, (double)reach, (double)reach);
        return player.m_9236_().m_6443_(LivingEntity.class, boundingBox, entity -> entity != player && entity.m_6084_()).stream().min(Comparator.comparingDouble(arg_0 -> ((Player)player).m_20280_(arg_0))).orElse(null);
    }

    public static boolean isMeleeOnCooldown(Player player, ItemStack heldItem) {
        CompoundTag tag = heldItem.m_41784_();
        long currentTime = player.m_9236_().m_46467_();
        return tag.m_128441_(MELEE_COOLDOWN_TAG) && currentTime < tag.m_128454_(MELEE_COOLDOWN_TAG);
    }

    public static void setMeleeCooldown(Player player, ItemStack heldItem, GunItem gunItem) {
        CompoundTag tag = heldItem.m_41784_();
        long currentTime = player.m_9236_().m_46467_();
        int cooldownTicks = gunItem.getModifiedGun(heldItem).getGeneral().getMeleeCooldownTicks();
        tag.m_128356_(MELEE_COOLDOWN_TAG, currentTime + (long)cooldownTicks);
        heldItem.m_41751_(tag);
    }

    private static void performMeleeAttackOnTarget(ServerPlayer player, LivingEntity target, boolean isBanzaiAttack) {
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        Item item = heldItem.m_41720_();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        float baseDamage = (float)player.m_21133_(Attributes.f_22281_);
        float additionalDamage = GunModifierHelper.getAdditionalDamage(heldItem, true);
        float enchantmentDamage = MeleeAttackHandler.getEnchantmentDamageFromBayonet(heldItem, target, gunItem);
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        float meleeDamage = modifiedGun.getGeneral().getMeleeDamage();
        float attackDamage = baseDamage + additionalDamage + enchantmentDamage + meleeDamage;
        if (isBanzaiAttack) {
            float speedDamageMultiplier = MeleeAttackHandler.getBanzaiDamageMultiplier(player, heldItem);
            attackDamage *= speedDamageMultiplier;
            attackDamage = (float)((double)Math.round((double)attackDamage * 100.0) / 100.0);
        }
        DamageSource damageSource = player.m_284548_().m_269111_().m_269075_((Player)player);
        if (isBanzaiAttack) {
            List<LivingEntity> targets = MeleeAttackHandler.findTargetsInArea((Player)player, 2.5);
            for (LivingEntity aoeTarget : targets) {
                if (!aoeTarget.m_6469_(damageSource, attackDamage)) continue;
                MeleeAttackHandler.spawnSuccessfulHitParticles(player, aoeTarget);
                player.m_9236_().m_6263_(null, aoeTarget.m_20185_(), aoeTarget.m_20186_(), aoeTarget.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
                MeleeAttackHandler.applyKnockback((Player)player, aoeTarget, heldItem);
                MeleeAttackHandler.applySpecialEnchantmentsFromBayonet(heldItem, aoeTarget, (Player)player, gunItem);
                MeleeAttackHandler.triggerBanzaiImpactIfNecessary(heldItem);
            }
        } else {
            LivingEntity raycastTarget = MeleeAttackHandler.raycastForMeleeAttack((Player)player, heldItem);
            if (raycastTarget != null && raycastTarget.m_6469_(damageSource, attackDamage)) {
                MeleeAttackHandler.spawnSuccessfulHitParticles(player, raycastTarget);
                MeleeAttackHandler.applyKnockback((Player)player, raycastTarget, heldItem);
                MeleeAttackHandler.applySpecialEnchantmentsFromBayonet(heldItem, raycastTarget, (Player)player, gunItem);
                MeleeAttackHandler.triggerBanzaiImpactIfNecessary(heldItem);
            }
        }
    }

    private static void spawnSuccessfulHitParticles(ServerPlayer player, LivingEntity target) {
        Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.5, 0.0);
        ClientboundLevelParticlesPacket sweepPacket = new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.f_123766_, true, targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, 0.0f, 0.0f, 0.0f, 0.0f, 1);
        player.f_8906_.m_9829_((Packet)sweepPacket);
        for (int i = 0; i < 5; ++i) {
            double offsetX = (Math.random() - 0.5) * 0.5;
            double offsetY = (Math.random() - 0.5) * 0.5;
            double offsetZ = (Math.random() - 0.5) * 0.5;
            ClientboundLevelParticlesPacket critPacket = new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.f_123797_, true, targetPos.f_82479_ + offsetX, targetPos.f_82480_ + offsetY, targetPos.f_82481_ + offsetZ, 0.0f, 0.1f, 0.0f, 0.1f, 1);
            player.f_8906_.m_9829_((Packet)critPacket);
        }
    }

    private static void triggerBanzaiImpactIfNecessary(ItemStack heldItem) {
        if (((GunItem)heldItem.m_41720_()).hasBayonet(heldItem)) {
            GunRenderingHandler.get().triggerBanzaiImpact();
        }
    }

    private static void applySpecialEnchantmentsFromBayonet(ItemStack gunStack, LivingEntity target, Player player, GunItem gunItem) {
        for (IAttachment.Type type : IAttachment.Type.values()) {
            ItemStack attachmentStack = gunItem.getAttachment(gunStack, type);
            if (!(attachmentStack.m_41720_() instanceof BayonetItem)) continue;
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)attachmentStack);
            for (Map.Entry entry : enchantments.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                int level = (Integer)entry.getValue();
                MeleeAttackHandler.applyEnchantmentEffects(enchantment, level, target, player);
                if (enchantment != ModEnchantments.CORRODED.get()) continue;
                MeleeAttackHandler.applyCorrodedEffects(player, target, level);
            }
        }
    }

    private static void applyCorrodedEffects(Player player, LivingEntity target, int level) {
        if (MeleeAttackHandler.isBotEntity(target)) {
            MeleeAttackHandler.spawnCorrodedParticles(player, target, level);
        } else if (player.m_9236_().m_213780_().m_188501_() < 0.3f) {
            int poisonDuration = 60 + level * 20;
            target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, poisonDuration, 0));
        }
    }

    private static void spawnCorrodedParticles(Player player, LivingEntity target, int level) {
        Level level2 = player.m_9236_();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            Random random = new Random();
            for (int i = 0; i < level * 5; ++i) {
                double offsetX = (random.nextDouble() - 0.5) * (double)target.m_20205_();
                double offsetY = random.nextDouble() * (double)target.m_20206_();
                double offsetZ = (random.nextDouble() - 0.5) * (double)target.m_20205_();
                ClientboundLevelParticlesPacket particlePacket = new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.f_175830_, true, target.m_20185_() + offsetX, target.m_20186_() + offsetY, target.m_20189_() + offsetZ, 0.0f, 0.0f, 0.0f, 0.1f, 1);
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.f_8906_.m_9829_((Packet)particlePacket);
            }
        }
    }

    public static void performNormalMeleeAttack(ServerPlayer player) {
        MeleeAttackHandler.performMeleeAttack(player);
    }

    public static void handleBanzaiMode(ServerPlayer player) {
        boolean inGracePeriod;
        if (!isBanzai) {
            return;
        }
        ItemStack currentHeldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        if (!ItemStack.m_41728_((ItemStack)currentHeldItem, (ItemStack)banzaiActiveItem)) {
            MeleeAttackHandler.stopBanzai();
            return;
        }
        CompoundTag playerData = player.getPersistentData();
        long currentTime = player.m_9236_().m_46467_();
        boolean bl = inGracePeriod = playerData.m_128441_(KNOCKBACK_GRACE_TAG) && currentTime < playerData.m_128454_(KNOCKBACK_GRACE_TAG);
        if (!player.m_20142_() && !inGracePeriod) {
            MeleeAttackHandler.stopBanzai();
            return;
        }
        if (MeleeAttackHandler.checkForWallCollision(player)) {
            MeleeAttackHandler.knockPlayerBack(player);
            MeleeAttackHandler.sendWallImpactParticles(player);
            MeleeAttackHandler.triggerBanzaiImpactIfNecessary(currentHeldItem);
            playerData.m_128356_(KNOCKBACK_GRACE_TAG, currentTime + 5L);
            return;
        }
        if (playerData.m_128441_(BANZAI_DAMAGE_COOLDOWN_TAG) && currentTime < playerData.m_128454_(BANZAI_DAMAGE_COOLDOWN_TAG)) {
            return;
        }
        List<LivingEntity> targets = MeleeAttackHandler.findTargetsInArea((Player)player, 1.5);
        if (!targets.isEmpty()) {
            playerData.m_128356_(BANZAI_DAMAGE_COOLDOWN_TAG, currentTime + 25L);
            for (LivingEntity target : targets) {
                if (target == player) continue;
                MeleeAttackHandler.performMeleeAttackOnTarget(player, target, true);
            }
        }
    }

    private static boolean checkForWallCollision(ServerPlayer player) {
        double[] heightOffsets;
        Vec3 playerMotion;
        CompoundTag playerData = player.getPersistentData();
        long currentTime = player.m_9236_().m_46467_();
        if (playerData.m_128441_(WALL_COLLISION_COOLDOWN_TAG) && currentTime < playerData.m_128454_(WALL_COLLISION_COOLDOWN_TAG)) {
            return false;
        }
        Vec3 eyePosition = player.m_20299_(1.0f);
        Vec3 lookVector = player.m_20154_();
        if (lookVector.m_82526_(playerMotion = player.m_20184_()) <= 0.0) {
            return false;
        }
        for (double heightOffset : heightOffsets = new double[]{0.0, 0.5, -0.5}) {
            Vec3 checkPosition = eyePosition.m_82520_(0.0, heightOffset, 0.0);
            for (double angle : WALL_CHECK_ANGLES) {
                Vec3 rotatedVector = MeleeAttackHandler.rotateVector(lookVector, angle);
                Vec3 reachVector = checkPosition.m_82549_(rotatedVector.m_82490_(1.0));
                BlockHitResult hitResult = player.m_9236_().m_45547_(new ClipContext(checkPosition, reachVector, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
                if (hitResult.m_6662_() != HitResult.Type.BLOCK) continue;
                playerData.m_128356_(WALL_COLLISION_COOLDOWN_TAG, currentTime + 20L);
                return true;
            }
        }
        return false;
    }

    private static Vec3 rotateVector(Vec3 lookVector, double angle) {
        double angleRadians = Math.toRadians(angle);
        double x = lookVector.f_82479_ * Math.cos(angleRadians) - lookVector.f_82481_ * Math.sin(angleRadians);
        double z = lookVector.f_82479_ * Math.sin(angleRadians) + lookVector.f_82481_ * Math.cos(angleRadians);
        return new Vec3(x, lookVector.f_82480_, z);
    }

    private static void knockPlayerBack(ServerPlayer player) {
        Vec3 knockbackDirection = player.m_20154_().m_82490_(-0.5);
        player.m_5997_(knockbackDirection.f_82479_, 0.3, knockbackDirection.f_82481_);
        player.f_19864_ = true;
    }

    private static void sendWallImpactParticles(ServerPlayer player) {
        Vec3 eyePosition = player.m_20299_(1.0f);
        Vec3 lookVector = player.m_20154_();
        Vec3 reachVector = eyePosition.m_82549_(lookVector.m_82490_(1.0));
        ClipContext context = new ClipContext(eyePosition, reachVector, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult hitResult = player.m_9236_().m_45547_(context);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos = hitResult.m_82425_();
            BlockState blockState = player.m_9236_().m_8055_(pos);
            ClientboundLevelParticlesPacket particlePacket = MeleeAttackHandler.getClientboundLevelParticlesPacket(hitResult, blockState);
            player.f_8906_.m_9829_((Packet)particlePacket);
            player.m_9236_().m_6263_(null, hitResult.m_82450_().f_82479_, hitResult.m_82450_().f_82480_, hitResult.m_82450_().f_82481_, SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private static float getBanzaiDamageMultiplier(ServerPlayer player, ItemStack heldItem) {
        double speed = player.m_20184_().m_82553_();
        int banzaiLevel = ((GunItem)heldItem.m_41720_()).getBayonetBanzaiLevel(heldItem);
        float scalingFactor = 0.0f;
        if (banzaiLevel > 0 && banzaiLevel <= 3) {
            scalingFactor = BANZAI_SCALING_FACTORS[banzaiLevel - 1];
        }
        return 1.0f + (float)speed * scalingFactor;
    }

    private static float getEnchantmentDamageFromBayonet(ItemStack gunStack, LivingEntity target, GunItem gunItem) {
        float enchantmentDamage = 0.0f;
        for (IAttachment.Type type : IAttachment.Type.values()) {
            ItemStack attachmentStack = gunItem.getAttachment(gunStack, type);
            if (!(attachmentStack.m_41720_() instanceof BayonetItem)) continue;
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)attachmentStack);
            for (Map.Entry entry : enchantments.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                int level = (Integer)entry.getValue();
                if (enchantment instanceof DamageEnchantment) {
                    DamageEnchantment damageEnchantment = (DamageEnchantment)enchantment;
                    float damageBonus = damageEnchantment.m_7335_(level, target.m_6336_());
                    enchantmentDamage += damageBonus * 0.7f;
                    continue;
                }
                if (enchantment != ModEnchantments.CORRODED.get() || !MeleeAttackHandler.isBotEntity(target)) continue;
                float corrodedBonus = CorrodedEnchantment.getBotDamageBonus(level);
                enchantmentDamage += corrodedBonus * 0.7f;
            }
        }
        return enchantmentDamage;
    }

    private static boolean isBotEntity(LivingEntity entity) {
        return entity.m_6095_().m_204039_(ModTags.Entities.BOT);
    }

    private static void applyEnchantmentEffects(Enchantment enchantment, int level, LivingEntity target, Player player) {
        if (enchantment == Enchantments.f_44981_) {
            target.m_20254_(level * 4);
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientMeleeAttackHandler.spawnParticleEffect(player, target, ParticleTypes.f_123744_));
        } else if (enchantment == Enchantments.f_44980_) {
            Vec3 direction = target.m_20182_().m_82546_(player.m_20182_()).m_82541_();
            target.m_147240_((double)((float)level * 0.5f), -direction.m_7096_(), -direction.m_7094_());
        } else if (enchantment == Enchantments.f_44978_ && target.m_6336_() == MobType.f_21641_) {
            MeleeAttackHandler.spawnEnchantmentHitParticles(player, target);
        } else if (enchantment == Enchantments.f_44979_ && target.m_6336_() == MobType.f_21642_) {
            MeleeAttackHandler.spawnEnchantmentHitParticles(player, target);
        } else if (enchantment == Enchantments.f_44977_) {
            MeleeAttackHandler.spawnEnchantmentHitParticles(player, target);
        }
    }

    private static void spawnEnchantmentHitParticles(Player player, LivingEntity target) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ClientboundLevelParticlesPacket particlePacket = new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.f_123808_, true, target.m_20185_(), target.m_20186_() + (double)target.m_20206_() * 0.5, target.m_20189_(), target.m_20205_() * 0.5f, target.m_20206_() * 0.25f, target.m_20205_() * 0.5f, 0.02f, 8);
            serverPlayer.f_8906_.m_9829_((Packet)particlePacket);
        }
    }

    private static void applyKnockback(Player player, LivingEntity target, ItemStack stack) {
        int knockbackLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)stack);
        Vec3 direction = target.m_20182_().m_82546_(player.m_20182_()).m_82541_();
        target.m_147240_((double)(0.4f + (float)knockbackLevel * 0.5f), -direction.m_7096_(), -direction.m_7094_());
    }

    private static LivingEntity raycastForMeleeAttack(Player player, ItemStack heldItem) {
        GunItem gunItem = (GunItem)heldItem.m_41720_();
        float reach = gunItem.getModifiedGun(heldItem).getGeneral().getMeleeReach();
        Vec3 startVec = player.m_20299_(1.0f);
        Vec3 lookVec = player.m_20154_();
        Vec3 endVec = startVec.m_82549_(lookVec.m_82490_((double)reach));
        AABB boundingBox = new AABB(startVec, endVec);
        return player.m_9236_().m_6443_(LivingEntity.class, boundingBox, entity -> entity != player && entity.m_6084_()).stream().min(Comparator.comparingDouble(arg_0 -> ((Player)player).m_20280_(arg_0))).orElse(null);
    }

    private static List<LivingEntity> findTargetsInArea(Player player, double radius) {
        Vec3 position = player.m_20182_();
        AABB boundingBox = new AABB(position.m_82492_(radius, radius, radius), position.m_82520_(radius, radius, radius));
        return player.m_9236_().m_6443_(LivingEntity.class, boundingBox, entity -> entity != player && entity.m_6084_());
    }

    private static void damageGunAndAttachments(ItemStack stack, Player player) {
        Level level = player.m_9236_();
        GunEventBus.damageGun(stack, level, player);
        GunEventBus.damageAttachments(stack, level, player);
    }
}

