/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.render.gun.model;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.client.SpecialModels;
import top.ribs.scguns.client.render.gun.IOverrideModel;
import top.ribs.scguns.client.util.RenderUtil;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.event.GunFireEvent;
import top.ribs.scguns.init.ModItems;
import top.ribs.scguns.item.attachment.IAttachment;

public class RatKingAndQueenModel
implements IOverrideModel {
    @Override
    public void render(float partialTicks, ItemDisplayContext transformType, ItemStack stack, ItemStack parent, LivingEntity entity, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        RenderUtil.renderModel(SpecialModels.RAT_KING_AND_QUEEN_MAIN.getModel(), stack, matrixStack, buffer, light, overlay);
        this.renderBarrelAttachments(matrixStack, buffer, stack, light, overlay);
        this.renderMagazineAttachments(matrixStack, buffer, stack, light, overlay);
        assert (entity != null);
        if (entity.equals((Object)Minecraft.m_91087_().f_91074_)) {
            this.renderReceivers(matrixStack, buffer, stack, light, overlay);
        }
    }

    private void renderBarrelAttachments(PoseStack matrixStack, MultiBufferSource buffer, ItemStack stack, int light, int overlay) {
        boolean isExtendedBarrelEquipped = false;
        if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.BARREL) && Gun.getAttachment(IAttachment.Type.BARREL, stack).m_41720_() == ModItems.EXTENDED_BARREL.get()) {
            isExtendedBarrelEquipped = true;
            RenderUtil.renderModel(SpecialModels.RAT_KING_AND_QUEEN_EXT_BARREL.getModel(), stack, matrixStack, buffer, light, overlay);
        }
        if (!isExtendedBarrelEquipped) {
            RenderUtil.renderModel(SpecialModels.RAT_KING_AND_QUEEN_STAN_BARREL.getModel(), stack, matrixStack, buffer, light, overlay);
        }
        if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.BARREL)) {
            if (Gun.getAttachment(IAttachment.Type.BARREL, stack).m_41720_() == ModItems.SILENCER.get()) {
                RenderUtil.renderModel(SpecialModels.RAT_KING_AND_QUEEN_SILENCER.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.BARREL, stack).m_41720_() == ModItems.MUZZLE_BRAKE.get()) {
                RenderUtil.renderModel(SpecialModels.RAT_KING_AND_QUEEN_MUZZLE_BRAKE.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.BARREL, stack).m_41720_() == ModItems.ADVANCED_SILENCER.get()) {
                RenderUtil.renderModel(SpecialModels.RAT_KING_AND_QUEEN_ADVANCED_SILENCER.getModel(), stack, matrixStack, buffer, light, overlay);
            }
        }
    }

    private void renderMagazineAttachments(PoseStack matrixStack, MultiBufferSource buffer, ItemStack stack, int light, int overlay) {
        if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.MAGAZINE)) {
            if (Gun.getAttachment(IAttachment.Type.MAGAZINE, stack).m_41720_() == ModItems.EXTENDED_MAG.get()) {
                RenderUtil.renderModel(SpecialModels.RAT_KING_AND_QUEEN_EXTENDED_MAG.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.MAGAZINE, stack).m_41720_() == ModItems.SPEED_MAG.get()) {
                RenderUtil.renderModel(SpecialModels.RAT_KING_AND_QUEEN_SPEED_MAG.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.MAGAZINE, stack).m_41720_() == ModItems.PLUS_P_MAG.get()) {
                RenderUtil.renderModel(SpecialModels.RAT_KING_AND_QUEEN_EXTENDED_MAG.getModel(), stack, matrixStack, buffer, light, overlay);
            }
        } else {
            RenderUtil.renderModel(SpecialModels.RAT_KING_AND_QUEEN_STANDARD_MAG.getModel(), stack, matrixStack, buffer, light, overlay);
        }
    }

    private void renderReceivers(PoseStack matrixStack, MultiBufferSource buffer, ItemStack stack, int light, int overlay) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, -0.3625, 0.0);
        ItemCooldowns tracker = Minecraft.m_91087_().f_91074_.m_36335_();
        float cooldown = tracker.m_41521_(stack.m_41720_(), Minecraft.m_91087_().m_91296_());
        cooldown = (float)this.ease(cooldown);
        int shotCount = GunFireEventRatHandler.getShotCount();
        matrixStack.m_85836_();
        if (shotCount % 2 == 0 && cooldown > 0.0f) {
            matrixStack.m_252880_(0.0f, 0.0f, cooldown / 8.0f);
        }
        matrixStack.m_85837_(0.0, 0.3625, 0.0);
        RenderUtil.renderModel(SpecialModels.RAT_KING_AND_QUEEN_RECEIVER_1.getModel(), stack, matrixStack, buffer, light, overlay);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        if (shotCount % 2 == 1 && cooldown > 0.0f) {
            matrixStack.m_252880_(0.0f, 0.0f, cooldown / 8.0f);
        }
        matrixStack.m_85837_(0.0, 0.3625, 0.0);
        RenderUtil.renderModel(SpecialModels.RAT_KING_AND_QUEEN_RECEIVER_2.getModel(), stack, matrixStack, buffer, light, overlay);
        matrixStack.m_85849_();
        matrixStack.m_85849_();
    }

    private double ease(double x) {
        return 1.0 - Math.pow(1.0 - 2.0 * x, 4.0);
    }

    @Mod.EventBusSubscriber(modid="scguns", value={Dist.CLIENT})
    public static class GunFireEventRatHandler {
        private static int shotCount = 0;

        @SubscribeEvent
        public static void onGunFire(GunFireEvent.Post event) {
            if (event.isClient()) {
                ++shotCount;
            }
        }

        public static int getShotCount() {
            return shotCount;
        }
    }
}

