/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import top.ribs.scguns.Config;
import top.ribs.scguns.client.handler.GunRenderingHandler;
import top.ribs.scguns.client.screen.AttachmentContainer;
import top.ribs.scguns.client.screen.ButtonAlignment;
import top.ribs.scguns.client.screen.widget.MiniButton;
import top.ribs.scguns.client.util.RenderUtil;
import top.ribs.scguns.common.FireMode;
import top.ribs.scguns.common.GripType;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.common.ReloadType;
import top.ribs.scguns.common.container.slot.AttachmentSlot;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.item.attachment.IAttachment;
import top.ribs.scguns.util.GunCompositeStatHelper;
import top.ribs.scguns.util.GunEnchantmentHelper;
import top.ribs.scguns.util.GunModifierHelper;

public class AttachmentScreen
extends AbstractContainerScreen<AttachmentContainer> {
    private static final ResourceLocation GUI_TEXTURES = new ResourceLocation("scguns:textures/gui/attachments.png");
    private final Container weaponInventory;
    private int windowZoom = 10;
    private int windowX;
    private int windowY;
    private float windowRotationX;
    private float windowRotationY;
    private boolean mouseGrabbed;
    private int mouseGrabbedButton;
    private int mouseClickedX;
    private int mouseClickedY;
    private float momentumX = 0.0f;
    private float momentumY = 0.0f;
    private float lastDragX = 0.0f;
    private float lastDragY = 0.0f;
    private float targetRotationX = 0.0f;
    private float targetRotationY = 0.0f;
    private float prevRotationX = 0.0f;
    private float prevRotationY = 0.0f;
    private final List<Float> recentDragSpeedsX = new ArrayList<Float>();
    private final List<Float> recentDragSpeedsY = new ArrayList<Float>();
    private static final int VELOCITY_SAMPLES = 5;
    private float totalDragDistance = 0.0f;
    private static final float MOMENTUM_DAMPING = 0.92f;
    private static final float MIN_MOMENTUM = 0.15f;
    private static final float DRAG_THRESHOLD = 25.0f;
    private static final float MOMENTUM_SCALE = 1.4f;
    private static final float INTERPOLATION_SPEED = 0.5f;

    public AttachmentScreen(AttachmentContainer screenContainer, Inventory playerInventory, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, playerInventory, titleIn);
        this.weaponInventory = screenContainer.getWeaponInventory();
        this.f_97727_ = 192;
        this.f_97726_ = 188;
    }

    protected void m_7856_() {
        super.m_7856_();
        List<MiniButton> buttons = this.gatherButtons();
        for (int i = 0; i < buttons.size(); ++i) {
            MiniButton button = buttons.get(i);
            switch ((ButtonAlignment)((Object)Config.CLIENT.buttonAlignment.get())) {
                case LEFT: {
                    assert (this.f_96541_ != null);
                    int titleWidth = this.f_96541_.f_91062_.m_92852_((FormattedText)this.f_96539_);
                    button.m_252865_(this.f_97735_ + titleWidth + 8 + 3 + i * 13 - 6);
                    break;
                }
                case RIGHT: {
                    button.m_252865_(this.f_97735_ + this.f_97726_ - 7 - 10 - (buttons.size() - 1 - i) * 13 - 6);
                }
            }
            button.m_253211_(this.f_97736_ + 5 + 19);
            this.m_142416_((GuiEventListener)button);
        }
    }

    private List<MiniButton> gatherButtons() {
        ArrayList<MiniButton> buttons = new ArrayList<MiniButton>();
        return buttons;
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null && !(this.f_96541_.f_91074_.m_21205_().m_41720_() instanceof GunItem)) {
            Minecraft.m_91087_().m_91152_(null);
        }
        this.prevRotationX = this.windowRotationX;
        this.prevRotationY = this.windowRotationY;
        if (this.mouseGrabbed && this.mouseGrabbedButton == 1) {
            this.windowRotationX += (this.targetRotationX - this.windowRotationX) * 0.5f;
            this.windowRotationY += (this.targetRotationY - this.windowRotationY) * 0.5f;
        } else if (!this.mouseGrabbed && (Math.abs(this.momentumX) > 0.15f || Math.abs(this.momentumY) > 0.15f)) {
            this.windowRotationX += this.momentumX;
            this.windowRotationY += this.momentumY;
            this.targetRotationX = this.windowRotationX;
            this.targetRotationY = this.windowRotationY;
            this.momentumX *= 0.92f;
            this.momentumY *= 0.92f;
            if (Math.abs(this.momentumX) < 0.15f) {
                this.momentumX = 0.0f;
            }
            if (Math.abs(this.momentumY) < 0.15f) {
                this.momentumY = 0.0f;
            }
        }
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(pGuiGraphics, mouseX, mouseY);
        int startX = (this.f_96543_ - this.f_97726_) / 2 - 6;
        int startY = (this.f_96544_ - this.f_97727_) / 2 + 19;
        int numSlots = Math.min(5, IAttachment.Type.values().length);
        int centerX = 88 - numSlots * 18 / 2 + 18 - 5;
        for (int i = 0; i < numSlots; ++i) {
            AttachmentSlot slot;
            int x = centerX + i * 18;
            int y = 89;
            if (!RenderUtil.isMouseWithin(mouseX, mouseY, startX + x, startY + y, 18, 18)) continue;
            IAttachment.Type type = IAttachment.Type.values()[i];
            if (!((AttachmentContainer)this.f_97732_).m_38853_(i).m_6659_()) {
                pGuiGraphics.m_280666_(this.f_96547_, Arrays.asList(Component.m_237115_((String)("slot.scguns.attachment." + type.getTranslationKey())), Component.m_237115_((String)"slot.scguns.attachment.not_applicable")), mouseX, mouseY);
                continue;
            }
            Slot slot2 = ((AttachmentContainer)this.f_97732_).m_38853_(i);
            if (!(slot2 instanceof AttachmentSlot) || !(slot = (AttachmentSlot)slot2).m_7993_().m_41619_() || this.isCompatible(((AttachmentContainer)this.f_97732_).m_142621_(), slot)) continue;
            pGuiGraphics.m_280666_(this.f_96547_, Arrays.asList(Component.m_237115_((String)"slot.scguns.attachment.incompatible").m_130940_(ChatFormatting.YELLOW)), mouseX, mouseY);
        }
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        int left = (this.f_96543_ - this.f_97726_) / 2 - 6;
        int top = (this.f_96544_ - this.f_97727_) / 2 + 19;
        float partialTicks = minecraft.m_91296_();
        float renderRotationX = this.prevRotationX + (this.windowRotationX - this.prevRotationX) * partialTicks;
        float renderRotationY = this.prevRotationY + (this.windowRotationY - this.prevRotationY) * partialTicks;
        pGuiGraphics.m_280588_(left + 8 - 14, top + 17 - 82, left + 8 + 176 + 14, top + 17 + 64);
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_(96.0f, 48.0f, 150.0f);
        pGuiGraphics.m_280168_().m_252880_((float)(this.windowX + (this.mouseGrabbed && this.mouseGrabbedButton == 0 ? mouseX - this.mouseClickedX : 0)), 0.0f, 0.0f);
        pGuiGraphics.m_280168_().m_252880_(0.0f, (float)(this.windowY + (this.mouseGrabbed && this.mouseGrabbedButton == 0 ? mouseY - this.mouseClickedY : 0)), 0.0f);
        pGuiGraphics.m_280168_().m_252781_(Axis.f_252529_.m_252977_(-30.0f));
        pGuiGraphics.m_280168_().m_252781_(Axis.f_252529_.m_252977_(renderRotationY));
        pGuiGraphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(renderRotationX));
        pGuiGraphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(150.0f));
        pGuiGraphics.m_280168_().m_85841_((float)this.windowZoom / 10.0f, (float)this.windowZoom / 10.0f, (float)this.windowZoom / 10.0f);
        pGuiGraphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(90.0f));
        pGuiGraphics.m_280168_().m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        pGuiGraphics.m_280168_().m_85841_(90.0f, 90.0f, 90.0f);
        PoseStack modelStack = RenderSystem.getModelViewStack();
        modelStack.m_85836_();
        modelStack.m_252931_(pGuiGraphics.m_280168_().m_85850_().m_252922_());
        RenderSystem.applyModelViewMatrix();
        assert (this.f_96541_ != null);
        MultiBufferSource.BufferSource buffer = this.f_96541_.m_91269_().m_110104_();
        assert (this.f_96541_.f_91074_ != null);
        GunRenderingHandler.get().renderWeapon((LivingEntity)this.f_96541_.f_91074_, this.f_96541_.f_91074_.m_21205_(), ItemDisplayContext.GROUND, new PoseStack(), (MultiBufferSource)buffer, 0xF000F0, 0.0f);
        buffer.m_109911_();
        pGuiGraphics.m_280168_().m_85849_();
        modelStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        pGuiGraphics.m_280618_();
        pGuiGraphics.m_280262_();
        this.renderGunStats(pGuiGraphics);
    }

    private void renderGunStats(GuiGraphics pGuiGraphics) {
        GripType gripType;
        float puncturingPen;
        float baseArmorPen;
        float totalArmorPen;
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        ItemStack gunStack = this.f_96541_.f_91074_.m_21205_();
        Item item = gunStack.m_41720_();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        Gun modifiedGun = gunItem.getModifiedGun(gunStack);
        Gun.Projectile projectile = modifiedGun.getProjectile(gunStack);
        Gun.General general = modifiedGun.getGeneral();
        Gun.Reloads reloads = modifiedGun.getReloads();
        int startX = -60;
        boolean startY = false;
        int lineHeight = 7;
        float scale = 0.6f;
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_85841_(scale, scale, scale);
        float currentY = (float)startY;
        String gunName = Component.m_237115_((String)gunStack.m_41778_()).getString();
        int gunNameWidth = this.f_96547_.m_92895_(gunName);
        pGuiGraphics.m_280056_(this.f_96547_, gunName, (int)((float)startX / scale), 0, 0xFFFFFF, false);
        pGuiGraphics.m_280509_((int)((float)startX / scale), (int)((currentY + 6.0f) / scale), (int)(((float)startX + (float)gunNameWidth * scale) / scale), (int)((currentY + 7.0f) / scale), -1);
        currentY += (float)(lineHeight + 3);
        float baseDamage = projectile.getDamage();
        baseDamage = GunModifierHelper.getModifiedProjectileDamage(gunStack, baseDamage);
        baseDamage = GunEnchantmentHelper.getAcceleratorDamage(gunStack, baseDamage);
        baseDamage = GunEnchantmentHelper.getHeavyShotDamage(gunStack, baseDamage);
        baseDamage *= ((Double)Config.COMMON.gameplay.globalDamageMultiplier.get()).floatValue();
        float additionalDamage = GunModifierHelper.getAdditionalDamage(gunStack, false);
        CompoundTag tagCompound = gunStack.m_41783_();
        if (tagCompound != null && tagCompound.m_128425_("AdditionalDamage", 99)) {
            additionalDamage += tagCompound.m_128457_("AdditionalDamage");
        }
        float totalDamage = baseDamage + additionalDamage;
        pGuiGraphics.m_280056_(this.f_96547_, Component.m_237115_((String)"info.scguns.damage").getString() + ": " + String.format("%.1f", Float.valueOf(totalDamage)), (int)((float)startX / scale), (int)(currentY / scale), 0xFFFFFF, false);
        currentY += (float)lineHeight;
        float critChance = GunModifierHelper.getCriticalChance(gunStack);
        if (critChance > 0.0f) {
            pGuiGraphics.m_280056_(this.f_96547_, Component.m_237115_((String)"info.scguns.critical_chance").getString() + ": " + String.format("%.1f%%", Float.valueOf(critChance * 100.0f)), (int)((float)startX / scale), (int)(currentY / scale), 0xFFFFFF, false);
            pGuiGraphics.m_280056_(this.f_96547_, Component.m_237115_((String)"info.scguns.critical_multiplier").getString() + ": " + String.format("%.1fx", Float.valueOf(projectile.getCritDamageMultiplier())), (int)((float)startX / scale), (int)((currentY += (float)lineHeight) / scale), 0xFFFFFF, false);
            currentY += (float)lineHeight;
        }
        if (projectile.getEnergyUse() > 0) {
            pGuiGraphics.m_280056_(this.f_96547_, Component.m_237115_((String)"info.scguns.energy_use").getString() + ": " + projectile.getEnergyUse(), (int)((float)startX / scale), (int)(currentY / scale), 0xFFFFFF, false);
            currentY += (float)lineHeight;
        }
        if ((totalArmorPen = (baseArmorPen = projectile.getArmorPen()) + (puncturingPen = GunEnchantmentHelper.getPuncturingArmorBypass(gunStack))) > 0.0f) {
            pGuiGraphics.m_280056_(this.f_96547_, Component.m_237115_((String)"info.scguns.armor_penetration").getString() + ": " + String.format("%.1f", Float.valueOf(totalArmorPen)), (int)((float)startX / scale), (int)(currentY / scale), 0xFFFFFF, false);
            currentY += (float)lineHeight;
        }
        FireMode fireMode = general.getFireMode();
        String fireModeKey = "fire_mode." + fireMode.id().toString();
        pGuiGraphics.m_280056_(this.f_96547_, Component.m_237115_((String)"info.scguns.fire_mode").getString() + ": " + Component.m_237115_((String)fireModeKey).getString(), (int)((float)startX / scale), (int)(currentY / scale), 0xFFFFFF, false);
        int modifiedRate = GunCompositeStatHelper.getCompositeRate(gunStack, modifiedGun);
        float rpm = 20.0f / (float)modifiedRate * 60.0f;
        pGuiGraphics.m_280056_(this.f_96547_, Component.m_237115_((String)"info.scguns.fire_rate").getString() + ": " + String.format("%.0f", Float.valueOf(rpm)) + " RPM", (int)((float)startX / scale), (int)((currentY += (float)lineHeight) / scale), 0xFFFFFF, false);
        int modifiedAmmo = GunModifierHelper.getModifiedAmmoCapacity(gunStack, modifiedGun);
        pGuiGraphics.m_280056_(this.f_96547_, Component.m_237115_((String)"info.scguns.max_ammo").getString() + ": " + modifiedAmmo, (int)((float)startX / scale), (int)((currentY += (float)lineHeight) / scale), 0xFFFFFF, false);
        ReloadType reloadType = reloads.getReloadType();
        String reloadTypeKey = "reload_type." + reloadType.id().toString().replace(":", ".");
        pGuiGraphics.m_280056_(this.f_96547_, Component.m_237115_((String)"info.scguns.reload_type").getString() + ": " + Component.m_237115_((String)reloadTypeKey).getString(), (int)((float)startX / scale), (int)((currentY += (float)lineHeight) / scale), 0xFFFFFF, false);
        currentY += (float)lineHeight;
        if (reloadType == ReloadType.SINGLE_ITEM && reloads.getReloadByproduct() != null) {
            pGuiGraphics.m_280056_(this.f_96547_, Component.m_237115_((String)"info.scguns.reload_byproduct").getString() + ": " + Component.m_237115_((String)reloads.getReloadByproduct().m_5524_()).getString(), (int)((float)startX / scale), (int)(currentY / scale), 0xFFFFFF, false);
            currentY += (float)lineHeight;
            if (reloads.getByproductChance() > 0.0f) {
                pGuiGraphics.m_280056_(this.f_96547_, Component.m_237115_((String)"info.scguns.byproduct_chance").getString() + ": " + String.format("%.0f%%", Float.valueOf(reloads.getByproductChance() * 100.0f)), (int)((float)startX / scale), (int)(currentY / scale), 0xFFFFFF, false);
                currentY += (float)lineHeight;
            }
        }
        String gripKey = (gripType = modifiedGun.determineGripType(gunStack)) == GripType.ONE_HANDED ? "info.scguns.grip_one_handed" : "info.scguns.grip_two_handed";
        pGuiGraphics.m_280056_(this.f_96547_, Component.m_237115_((String)"info.scguns.grip_type").getString() + ": " + Component.m_237115_((String)gripKey).getString(), (int)((float)startX / scale), (int)(currentY / scale), 0xFFFFFF, false);
        currentY += (float)lineHeight;
        if (projectile.isAlwaysSpread()) {
            pGuiGraphics.m_280056_(this.f_96547_, Component.m_237115_((String)"info.scguns.always_spread").getString(), (int)((float)startX / scale), (int)(currentY / scale), 0xFFFFFF, false);
            currentY += (float)lineHeight;
        }
        float modifiedSpread = GunModifierHelper.getModifiedSpread(gunStack, projectile.getSpread());
        pGuiGraphics.m_280056_(this.f_96547_, Component.m_237115_((String)"info.scguns.spread").getString() + ": " + String.format("%.2f", Float.valueOf(modifiedSpread)), (int)((float)startX / scale), (int)(currentY / scale), 0xFFFFFF, false);
        pGuiGraphics.m_280056_(this.f_96547_, Component.m_237115_((String)"info.scguns.recoil_angle").getString() + ": " + String.format("%.1f", Float.valueOf(projectile.getRecoilAngle())), (int)((float)startX / scale), (int)((currentY += (float)lineHeight) / scale), 0xFFFFFF, false);
        currentY += (float)lineHeight;
        float falloffStart = GunModifierHelper.getModifiedDamageFalloffStart(gunStack, projectile.getDamageFalloffStart());
        float falloffEnd = GunModifierHelper.getModifiedDamageFalloffEnd(gunStack, projectile.getDamageFalloffEnd());
        if (falloffStart > 0.0f || falloffEnd > 0.0f) {
            pGuiGraphics.m_280056_(this.f_96547_, Component.m_237115_((String)"info.scguns.falloff_range").getString() + ": " + String.format("%.0f", Float.valueOf(falloffStart)) + " - " + String.format("%.0f", Float.valueOf(falloffEnd)), (int)((float)startX / scale), (int)(currentY / scale), 0xFFFFFF, false);
        } else {
            pGuiGraphics.m_280056_(this.f_96547_, Component.m_237115_((String)"info.scguns.falloff_range").getString() + ": " + Component.m_237115_((String)"info.scguns.falloff_none").getString(), (int)((float)startX / scale), (int)(currentY / scale), 0xFFFFFF, false);
        }
        pGuiGraphics.m_280168_().m_85849_();
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURES);
        int left = (this.f_96543_ - this.f_97726_) / 2 - 6;
        int top = (this.f_96544_ - this.f_97727_) / 2 + 19;
        pGuiGraphics.m_280218_(GUI_TEXTURES, left, top, 0, 0, this.f_97726_, this.f_97727_);
        int numSlots = Math.min(5, IAttachment.Type.values().length);
        int centerX = 88 - numSlots * 18 / 2 + 18 - 5;
        for (int i = 0; i < numSlots; ++i) {
            int x = centerX + i * 18;
            int y = 89;
            if (!this.canPlaceAttachmentInSlot(((AttachmentContainer)this.f_97732_).m_142621_(), ((AttachmentContainer)this.f_97732_).m_38853_(i))) {
                pGuiGraphics.m_280218_(GUI_TEXTURES, left + x, top + y, 192, 0, 16, 16);
                continue;
            }
            if (!this.weaponInventory.m_8020_(i).m_41619_()) continue;
            pGuiGraphics.m_280218_(GUI_TEXTURES, left + x, top + y, 192, 16 + i * 16, 16, 16);
        }
    }

    private boolean canPlaceAttachmentInSlot(ItemStack stack, Slot slot) {
        if (!slot.m_6659_()) {
            return false;
        }
        if (!slot.equals(this.getSlotUnderMouse())) {
            return true;
        }
        if (!slot.m_7993_().m_41619_()) {
            return true;
        }
        if (!(slot instanceof AttachmentSlot)) {
            return true;
        }
        AttachmentSlot s = (AttachmentSlot)slot;
        Item item = stack.m_41720_();
        if (!(item instanceof IAttachment)) {
            return true;
        }
        IAttachment a = (IAttachment)item;
        if (!s.getType().equals((Object)a.getType())) {
            return true;
        }
        return s.m_5857_(stack);
    }

    private boolean isCompatible(ItemStack stack, AttachmentSlot slot) {
        if (stack.m_41619_()) {
            return true;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof IAttachment)) {
            return false;
        }
        IAttachment attachment = (IAttachment)item;
        if (!attachment.getType().equals((Object)slot.getType())) {
            return true;
        }
        if (!attachment.canAttachTo(stack)) {
            return false;
        }
        return slot.m_5857_(stack);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        int startX = (this.f_96543_ - this.f_97726_) / 2 - 6;
        int startY = (this.f_96544_ - this.f_97727_) / 2 + 19;
        if (RenderUtil.isMouseWithin((int)mouseX, (int)mouseY, startX + 8 - 14, startY + 17 - 82, 204, 146)) {
            if (scroll < 0.0 && this.windowZoom > 0) {
                --this.windowZoom;
            } else if (scroll > 0.0) {
                ++this.windowZoom;
            }
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int startX = (this.f_96543_ - this.f_97726_) / 2 - 6;
        int startY = (this.f_96544_ - this.f_97727_) / 2 + 19;
        if (RenderUtil.isMouseWithin((int)mouseX, (int)mouseY, startX + 8 - 14, startY + 17 - 82, 204, 146) && !this.mouseGrabbed && (button == 0 || button == 1)) {
            this.mouseGrabbed = true;
            this.mouseGrabbedButton = button == 1 ? 1 : 0;
            this.mouseClickedX = (int)mouseX;
            this.mouseClickedY = (int)mouseY;
            this.momentumX = 0.0f;
            this.momentumY = 0.0f;
            this.lastDragX = (float)mouseX;
            this.lastDragY = (float)mouseY;
            this.targetRotationX = this.windowRotationX;
            this.targetRotationY = this.windowRotationY;
            this.totalDragDistance = 0.0f;
            this.recentDragSpeedsX.clear();
            this.recentDragSpeedsY.clear();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.mouseGrabbed && this.mouseGrabbedButton == 1) {
            float deltaX = (float)(mouseX - (double)this.lastDragX);
            float deltaY = (float)(mouseY - (double)this.lastDragY);
            this.targetRotationX += deltaX;
            this.targetRotationY -= deltaY;
            float distance = (float)Math.sqrt(deltaX * deltaX + deltaY * deltaY);
            this.totalDragDistance += distance;
            this.recentDragSpeedsX.add(Float.valueOf(deltaX));
            this.recentDragSpeedsY.add(Float.valueOf(-deltaY));
            if (this.recentDragSpeedsX.size() > 5) {
                this.recentDragSpeedsX.remove(0);
                this.recentDragSpeedsY.remove(0);
            }
            this.lastDragX = (float)mouseX;
            this.lastDragY = (float)mouseY;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.mouseGrabbed) {
            if (this.mouseGrabbedButton == 0 && button == 0) {
                this.mouseGrabbed = false;
                this.windowX += (int)(mouseX - (double)this.mouseClickedX - 1.0);
                this.windowY += (int)(mouseY - (double)this.mouseClickedY);
            } else if (this.mouseGrabbedButton == 1 && button == 1) {
                this.mouseGrabbed = false;
                if (this.totalDragDistance >= 25.0f && !this.recentDragSpeedsX.isEmpty()) {
                    float avgSpeedX = 0.0f;
                    float avgSpeedY = 0.0f;
                    for (int i = 0; i < this.recentDragSpeedsX.size(); ++i) {
                        avgSpeedX += this.recentDragSpeedsX.get(i).floatValue();
                        avgSpeedY += this.recentDragSpeedsY.get(i).floatValue();
                    }
                    this.momentumX = (avgSpeedX /= (float)this.recentDragSpeedsX.size()) * 1.4f;
                    this.momentumY = (avgSpeedY /= (float)this.recentDragSpeedsY.size()) * 1.4f;
                    float maxMomentum = 20.0f;
                    this.momentumX = Math.max(-maxMomentum, Math.min(maxMomentum, this.momentumX));
                    this.momentumY = Math.max(-maxMomentum, Math.min(maxMomentum, this.momentumY));
                } else {
                    this.momentumX = 0.0f;
                    this.momentumY = 0.0f;
                }
                this.recentDragSpeedsX.clear();
                this.recentDragSpeedsY.clear();
            }
        }
        return super.m_6348_(mouseX, mouseY, button);
    }
}

