/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.ribs.scguns.client.screen.ExoSuitMenu;
import top.ribs.scguns.item.animated.ExoSuitItem;

public class ExoSuitScreen
extends AbstractContainerScreen<ExoSuitMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("scguns", "textures/gui/exosuit_gui.png");

    public ExoSuitScreen(ExoSuitMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97729_ = 6;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.renderUpgradeSlots(guiGraphics, x, y);
        this.renderUpgradeInfo(guiGraphics, x, y);
    }

    private void renderUpgradeSlots(GuiGraphics guiGraphics, int x, int y) {
        ItemStack armorPiece = ((ExoSuitMenu)this.f_97732_).getArmorPiece();
        int[][] slotPositions = new int[][]{{97, 25}, {115, 25}, {97, 43}, {115, 43}};
        for (int i = 0; i < 4; ++i) {
            int slotX = x + slotPositions[i][0];
            int slotY = y + slotPositions[i][1];
            if (!((ExoSuitMenu)this.f_97732_).isUpgradeSlotEnabled(1 + i)) {
                guiGraphics.m_280509_(slotX, slotY, slotX + 18, slotY + 18, Integer.MIN_VALUE);
                continue;
            }
            this.renderSlotTypeIndicator(guiGraphics, slotX, slotY, armorPiece, i);
        }
    }

    private void renderSlotTypeIndicator(GuiGraphics guiGraphics, int slotX, int slotY, ItemStack armorPiece, int slotIndex) {
        Item item;
        if (armorPiece.m_41619_() || !((item = armorPiece.m_41720_()) instanceof ExoSuitItem)) {
            return;
        }
        ExoSuitItem exosuit = (ExoSuitItem)item;
        int color = this.getSlotTypeColor(exosuit.m_266204_(), slotIndex);
        if (color != 0) {
            guiGraphics.m_280509_(slotX + 1, slotY + 1, slotX + 17, slotY + 17, color);
        }
    }

    private int getSlotTypeColor(ArmorItem.Type armorType, int slotIndex) {
        return switch (armorType) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorItem.Type.HELMET -> {
                switch (slotIndex) {
                    case 0: {
                        yield 0x20FF0000;
                    }
                    case 1: {
                        yield 0x2000FF00;
                    }
                    case 2: {
                        yield 0x200000FF;
                    }
                }
                yield 0;
            }
            case ArmorItem.Type.CHESTPLATE -> {
                switch (slotIndex) {
                    case 0: {
                        yield 0x20FF0000;
                    }
                    case 1: {
                        yield 0x20FFFF00;
                    }
                    case 2: {
                        yield 0x20FF00FF;
                    }
                    case 3: {
                        yield 0x2000FFFF;
                    }
                }
                throw new IllegalStateException("Unexpected value: " + slotIndex);
            }
            case ArmorItem.Type.LEGGINGS -> {
                switch (slotIndex) {
                    case 0: {
                        yield 0x20FF0000;
                    }
                    case 1: {
                        yield 0x20808080;
                    }
                    case 2: {
                        yield 0x2000FFFF;
                    }
                }
                yield 0;
            }
            case ArmorItem.Type.BOOTS -> {
                switch (slotIndex) {
                    case 0: {
                        yield 0x20FF0000;
                    }
                    case 1: {
                        yield 0x2000FF00;
                    }
                }
                yield 0;
            }
        };
    }

    private void renderUpgradeInfo(GuiGraphics guiGraphics, int x, int y) {
        Item item;
        ItemStack armorPiece = ((ExoSuitMenu)this.f_97732_).getArmorPiece();
        if (!armorPiece.m_41619_() && (item = armorPiece.m_41720_()) instanceof ExoSuitItem) {
            ExoSuitItem exosuit = (ExoSuitItem)item;
            int centerX = x + 26 + 9;
            int textY = y + 20;
            int maxSlots = exosuit.getMaxUpgradeSlots();
            int usedSlots = exosuit.getCurrentUpgradeCount(armorPiece);
            String slotInfo = usedSlots + "/" + maxSlots + "Slots";
            int textWidth = this.f_96547_.m_92895_(slotInfo);
            int textX = centerX - textWidth / 2;
            guiGraphics.m_280056_(this.f_96547_, slotInfo, textX, textY, 0x404040, false);
        }
    }

    protected void m_280072_(GuiGraphics guiGraphics, int x, int y) {
        super.m_280072_(guiGraphics, x, y);
        this.renderUpgradeSlotTooltips(guiGraphics, x, y);
    }

    private void renderUpgradeSlotTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ItemStack armorPiece = ((ExoSuitMenu)this.f_97732_).getArmorPiece();
        if (armorPiece.m_41619_()) {
            return;
        }
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        int[][] slotPositions = new int[][]{{97, 25}, {115, 25}, {97, 43}, {115, 43}};
        for (int i = 0; i < 4; ++i) {
            int slotX = x + slotPositions[i][0];
            int slotY = y + slotPositions[i][1];
            if (mouseX < slotX || mouseX >= slotX + 18 || mouseY < slotY || mouseY >= slotY + 18) continue;
            Slot upgradeSlot = ((ExoSuitMenu)this.f_97732_).m_38853_(37 + i);
            if (!((ExoSuitMenu)this.f_97732_).isUpgradeSlotEnabled(1 + i)) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)"Slot not available"), mouseX, mouseY);
                break;
            }
            if (!upgradeSlot.m_7993_().m_41619_()) break;
            String slotType = this.getSlotTypeTooltip(((ExoSuitItem)armorPiece.m_41720_()).m_266204_(), i);
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)slotType), mouseX, mouseY);
            break;
        }
    }

    private String getSlotTypeTooltip(ArmorItem.Type armorType, int slotIndex) {
        return switch (armorType) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorItem.Type.HELMET -> {
                switch (slotIndex) {
                    case 0: {
                        yield "Plating Slot";
                    }
                    case 1: {
                        yield "HUD Slot";
                    }
                    case 2: {
                        yield "Breathing Apparatus Slot";
                    }
                }
                yield "Upgrade Slot";
            }
            case ArmorItem.Type.CHESTPLATE -> {
                switch (slotIndex) {
                    case 0: {
                        yield "Plating Slot";
                    }
                    case 1: {
                        yield "Pauldron Slot";
                    }
                    case 2: {
                        yield "Power Core Slot";
                    }
                    case 3: {
                        yield "Utility Slot";
                    }
                }
                throw new IllegalStateException("Unexpected value: " + slotIndex);
            }
            case ArmorItem.Type.LEGGINGS -> {
                switch (slotIndex) {
                    case 0: {
                        yield "Plating Slot";
                    }
                    case 1: {
                        yield "Knee Guard / Plating Slot";
                    }
                    case 2: {
                        yield "Utility Slot";
                    }
                }
                yield "Upgrade Slot";
            }
            case ArmorItem.Type.BOOTS -> {
                switch (slotIndex) {
                    case 0: {
                        yield "Plating Slot";
                    }
                    case 1: {
                        yield "Mobility Enhancement Slot";
                    }
                }
                yield "Upgrade Slot";
            }
        };
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }
}

