/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import top.ribs.scguns.client.screen.LightningBatteryMenu;

public class LightningBatteryScreen
extends AbstractContainerScreen<LightningBatteryMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("scguns", "textures/gui/lightning_battery_gui.png");
    private static final int BAR_WIDTH = 7;
    private static final int BAR_HEIGHT = 42;
    private static final int BAR_X = 44;
    private static final int BAR_Y = 21;
    private static final int TEXTURE_BAR_X = 176;
    private static final int TEXTURE_BAR_Y = 20;
    private static final int ARROW_X = 79;
    private static final int ARROW_Y = 35;
    private static final int TEXTURE_ARROW_X = 176;
    private static final int TEXTURE_ARROW_Y = 3;
    private static final int ARROW_HEIGHT = 16;

    public LightningBatteryScreen(LightningBatteryMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97729_ = 6;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.renderProgressArrow(guiGraphics, x, y);
        this.renderEnergyBar(guiGraphics, x, y);
    }

    private void renderEnergyBar(GuiGraphics guiGraphics, int x, int y) {
        int energy = ((LightningBatteryMenu)this.f_97732_).getEnergy();
        int maxEnergy = ((LightningBatteryMenu)this.f_97732_).getMaxEnergy();
        if (maxEnergy > 0) {
            int energyHeight = (int)((float)(energy * 42) / (float)maxEnergy);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            guiGraphics.m_280218_(TEXTURE, x + 44, y + 21 + (42 - energyHeight), 176, 20 + (42 - energyHeight), 7, energyHeight);
        }
    }

    private void renderProgressArrow(GuiGraphics guiGraphics, int x, int y) {
        if (((LightningBatteryMenu)this.f_97732_).isCrafting()) {
            int progress = ((LightningBatteryMenu)this.f_97732_).getScaledProgress();
            guiGraphics.m_280218_(TEXTURE, x + 79, y + 35, 176, 3, progress + 1, 16);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        if (this.isMouseOverEnergyBar(mouseX, mouseY, x, y)) {
            this.renderEnergyTooltip(guiGraphics, mouseX, mouseY, ((LightningBatteryMenu)this.f_97732_).getEnergy(), ((LightningBatteryMenu)this.f_97732_).getMaxEnergy());
        }
    }

    private boolean isMouseOverEnergyBar(int mouseX, int mouseY, int x, int y) {
        return mouseX >= x + 44 && mouseX <= x + 44 + 7 && mouseY >= y + 21 && mouseY <= y + 21 + 42;
    }

    private void renderEnergyTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, int energy, int maxEnergy) {
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        tooltip.add(Component.m_237110_((String)"tooltip.lightning_battery.energy", (Object[])new Object[]{energy}));
        guiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
    }
}

