/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import top.ribs.scguns.Config;
import top.ribs.scguns.common.headshot.BasicHeadshotBox;
import top.ribs.scguns.common.headshot.ChildHeadshotBox;
import top.ribs.scguns.common.headshot.DynamicHeadshotBox;
import top.ribs.scguns.common.headshot.NoChildHeadshotBox;
import top.ribs.scguns.common.headshot.NoChildRotatedHeadshotBox;
import top.ribs.scguns.common.headshot.RotatedHeadshotBox;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.interfaces.IHeadshotBox;

public class BoundingBoxManager {
    private static final Map<EntityType<?>, IHeadshotBox<?>> headshotBoxes = new HashMap();
    private static final WeakHashMap<Player, LinkedList<AABB>> playerBoxes = new WeakHashMap();
    private static final Map<EntityType<?>, IHeadshotBox<?>> dynamicHeadshotBoxes = new HashMap();

    public static <T extends LivingEntity> void registerHeadshotBox(EntityType<T> type, IHeadshotBox<T> headshotBox) {
        headshotBoxes.putIfAbsent(type, headshotBox);
    }

    @Nullable
    public static IHeadshotBox<LivingEntity> getHeadshotBoxes(EntityType<?> type) {
        IHeadshotBox<Object> box = headshotBoxes.get(type);
        if (box != null) {
            return box;
        }
        box = dynamicHeadshotBoxes.get(type);
        if (box != null) {
            return box;
        }
        if (type.m_20674_() == MobCategory.MONSTER || type.m_20674_() == MobCategory.CREATURE || type.m_20674_() == MobCategory.AMBIENT) {
            DynamicHeadshotBox<LivingEntity> dynamicBox = new DynamicHeadshotBox<LivingEntity>();
            dynamicHeadshotBoxes.put(type, dynamicBox);
            return dynamicBox;
        }
        return null;
    }

    public static void clearDynamicBoxCache() {
        dynamicHeadshotBoxes.clear();
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!((Boolean)Config.COMMON.gameplay.improvedHitboxes.get()).booleanValue()) {
            return;
        }
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            if (event.player.m_5833_()) {
                playerBoxes.remove(event.player);
                return;
            }
            LinkedList boxes = playerBoxes.computeIfAbsent(event.player, player -> new LinkedList());
            boxes.addFirst(event.player.m_20191_());
            if (boxes.size() > 20) {
                boxes.removeLast();
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        playerBoxes.remove(event.getEntity());
    }

    public static AABB getBoundingBox(Player entity, int ping) {
        if (playerBoxes.containsKey(entity)) {
            LinkedList<AABB> boxes = playerBoxes.get(entity);
            int index = Mth.m_14045_((int)ping, (int)0, (int)(boxes.size() - 1));
            return boxes.get(index);
        }
        return entity.m_20191_();
    }

    static {
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20532_, entity -> {
            AABB headBox = new AABB(-0.25, 0.0, -0.25, 0.25, 0.5, 0.25);
            double scale = 0.9375;
            if (entity.m_6069_()) {
                headBox = headBox.m_82386_(0.0, 0.1875, 0.0);
                Vec3 pos = Vec3.m_82498_((float)entity.m_146909_(), (float)entity.f_20883_).m_82541_().m_82490_(0.8);
                headBox = headBox.m_82383_(pos);
            } else {
                headBox = headBox.m_82386_(0.0, entity.m_6144_() ? 1.25 : 1.5, 0.0);
            }
            return new AABB(headBox.f_82288_ * scale, headBox.f_82289_ * scale, headBox.f_82290_ * scale, headBox.f_82291_ * scale, headBox.f_82292_ * scale, headBox.f_82293_ * scale);
        });
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20501_, new ChildHeadshotBox(8.0, 24.0, 0.75, 0.5));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20531_, new ChildHeadshotBox(8.0, 24.0, 0.75, 0.5));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20458_, new ChildHeadshotBox(8.0, 24.0, 0.75, 0.5));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20524_, new BasicHeadshotBox(8.0, 24.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20497_, new BasicHeadshotBox(8.0, 26.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20481_, new BasicHeadshotBox(8.0, 24.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20558_, new BasicHeadshotBox(8.0, 18.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20479_, new RotatedHeadshotBox(8.0, 5.0, 7.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20562_, new BasicHeadshotBox(8.0, 24.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20492_, new NoChildHeadshotBox(8.0, 9.0, 23.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20530_, new NoChildHeadshotBox(8.0, 9.0, 23.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20493_, new NoChildHeadshotBox(8.0, 9.0, 23.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20568_, new BasicHeadshotBox(8.0, 9.0, 23.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20513_, new BasicHeadshotBox(8.0, 9.0, 23.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20459_, new BasicHeadshotBox(8.0, 9.0, 23.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20494_, new BasicHeadshotBox(8.0, 9.0, 23.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20495_, new BasicHeadshotBox(8.0, 9.0, 23.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20520_, new RotatedHeadshotBox(7.5, 8.0, 15.0, 9.5, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20555_, new NoChildRotatedHeadshotBox(4.0, 6.0, 9.0, 5.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20557_, new NoChildRotatedHeadshotBox(7.5, 8.0, 16.0, 10.5, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20504_, new NoChildRotatedHeadshotBox(7.5, 8.0, 16.0, 10.5, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20510_, new NoChildRotatedHeadshotBox(8.0, 8.0, 10.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20457_, new RotatedHeadshotBox(10.0, 26.0, 16.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20525_, new RotatedHeadshotBox(10.0, 26.0, 16.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20560_, new RotatedHeadshotBox(7.5, 8.0, 20.0, 13.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20503_, new RotatedHeadshotBox(7.5, 8.0, 21.0, 14.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20466_, new RotatedHeadshotBox(8.0, 26.0, 10.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20488_, new RotatedHeadshotBox(8.0, 26.0, 10.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20514_, new RotatedHeadshotBox(9.0, 12.0, 20.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20528_, new BasicHeadshotBox(10.0, 20.5));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20490_, new RotatedHeadshotBox(6.0, 5.0, 1.0, 10.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20460_, new RotatedHeadshotBox(8.0, 10.0, 33.0, 3.5, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20509_, new RotatedHeadshotBox(6.0, 3.0, 1.5, 6.5, true, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20456_, new RotatedHeadshotBox(14.0, 16.0, 7.0, 19.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20500_, new RotatedHeadshotBox(14.0, 16.0, 7.0, 19.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.f_20511_, new ChildHeadshotBox(8.0, 24.0, 0.75, 0.5));
        BoundingBoxManager.registerHeadshotBox((EntityType)ModEntities.HORNLIN.get(), new BasicHeadshotBox(8.0, 24.0));
        BoundingBoxManager.registerHeadshotBox((EntityType)ModEntities.ZOMBIFIED_HORNLIN.get(), new BasicHeadshotBox(8.0, 24.0));
        BoundingBoxManager.registerHeadshotBox((EntityType)ModEntities.THE_MERCHANT.get(), new BasicHeadshotBox(8.0, 29.0));
        BoundingBoxManager.registerHeadshotBox((EntityType)ModEntities.COG_MINION.get(), new BasicHeadshotBox(8.0, 24.0));
        BoundingBoxManager.registerHeadshotBox((EntityType)ModEntities.COG_KNIGHT.get(), new BasicHeadshotBox(8.0, 24.0));
        BoundingBoxManager.registerHeadshotBox((EntityType)ModEntities.TRAUMA_UNIT.get(), new BasicHeadshotBox(8.0, 24.0));
        BoundingBoxManager.registerHeadshotBox((EntityType)ModEntities.BLUNDERER.get(), new BasicHeadshotBox(8.0, 24.0));
        BoundingBoxManager.registerHeadshotBox((EntityType)ModEntities.HIVE.get(), new BasicHeadshotBox(8.0, 18.0));
        BoundingBoxManager.registerHeadshotBox((EntityType)ModEntities.SULFURHEAD.get(), new BasicHeadshotBox(8.0, 18.0));
        BoundingBoxManager.registerHeadshotBox((EntityType)ModEntities.DISSIDENT.get(), new BasicHeadshotBox(8.0, 18.0));
        BoundingBoxManager.registerHeadshotBox((EntityType)ModEntities.SCAMP_TANK.get(), new BasicHeadshotBox(8.0, 30.0));
    }
}

