/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.init.ModSyncedDataKeys;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.util.GunCompositeStatHelper;

@Mod.EventBusSubscriber(modid="scguns")
public class BurstTracker {
    private static final Map<Player, BurstTracker> BURST_TRACKER_MAP = new WeakHashMap<Player, BurstTracker>();
    private int burstTick;
    private final int slot;
    private final ItemStack stack;
    private final Gun gun;

    private BurstTracker(Player player) {
        this.burstTick = player.f_19797_ - 20;
        this.slot = player.m_150109_().f_35977_;
        this.stack = player.m_150109_().m_36056_();
        this.gun = ((GunItem)this.stack.m_41720_()).getModifiedGun(this.stack);
    }

    private boolean isSameWeapon(Player player) {
        return !this.stack.m_41619_() && player.m_150109_().f_35977_ == this.slot && player.m_150109_().m_36056_() == this.stack;
    }

    private int getDeltaTicks(Player player) {
        int deltaTicks = player.f_19797_ - this.burstTick;
        return deltaTicks;
    }

    private int getBurstDelayTicks(Player player) {
        int minTickDelay = GunCompositeStatHelper.getCompositeRate(this.stack, this.gun, player) + Gun.getBurstCooldown(this.stack);
        return minTickDelay - 1;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.player.m_9236_().f_46443_) {
            Player player = event.player;
            if (!BURST_TRACKER_MAP.containsKey(player)) {
                if (!(player.m_150109_().m_36056_().m_41720_() instanceof GunItem)) {
                    ModSyncedDataKeys.BURSTCOUNT.setValue((Entity)player, (Object)0);
                    ModSyncedDataKeys.ONBURSTCOOLDOWN.setValue((Entity)player, (Object)false);
                    return;
                }
                BURST_TRACKER_MAP.put(player, new BurstTracker(player));
            }
            BurstTracker tracker = BURST_TRACKER_MAP.get(player);
            boolean resetBurst = false;
            if (player.m_150109_().m_36056_().m_41720_() instanceof GunItem) {
                GunItem gunItem = (GunItem)tracker.stack.m_41720_();
                if (((Boolean)ModSyncedDataKeys.SHOOTING.getValue((Entity)player)).booleanValue() && Gun.hasBurstFire(tracker.stack)) {
                    tracker.burstTick = player.f_19797_;
                }
                if (tracker.isSameWeapon(player)) {
                    if (!((Boolean)ModSyncedDataKeys.SHOOTING.getValue((Entity)player)).booleanValue()) {
                        boolean onCooldown;
                        boolean bl = onCooldown = tracker.getDeltaTicks(player) < tracker.getBurstDelayTicks(player);
                        if (!onCooldown) {
                            ModSyncedDataKeys.ONBURSTCOOLDOWN.setValue((Entity)player, (Object)false);
                        }
                    } else if (Gun.hasBurstFire(tracker.stack)) {
                        ModSyncedDataKeys.ONBURSTCOOLDOWN.setValue((Entity)player, (Object)true);
                    }
                } else {
                    resetBurst = true;
                }
            } else {
                resetBurst = true;
            }
            if (resetBurst) {
                ModSyncedDataKeys.BURSTCOUNT.setValue((Entity)player, (Object)0);
                if (BURST_TRACKER_MAP.containsKey(player)) {
                    BURST_TRACKER_MAP.remove(player);
                }
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerEvent.PlayerLoggedOutEvent event) {
        MinecraftServer server = event.getEntity().m_20194_();
        if (server != null) {
            server.execute(() -> BURST_TRACKER_MAP.remove(event.getEntity()));
        }
    }
}

