/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common;

import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.common.exosuit.ExoSuitGasMaskHandler;
import top.ribs.scguns.init.ModTags;

public class ChokeBombCloud {
    private static final double PARTICLE_RENDER_DISTANCE = 256.0;
    private static final int BASE_CLOUD_PARTICLES = 20;
    private static final int BASE_ASH_PARTICLES = 10;

    public static void spawnChokeCloudParticles(Level level, Vec3 center, double radius, float intensity, RandomSource random) {
        double zSpeed;
        double ySpeed;
        double xSpeed;
        double speed;
        double y;
        double z;
        double x;
        double angle;
        int i;
        if (level.f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        List<ServerPlayer> nearbyPlayers = ChokeBombCloud.getNearbyPlayers(serverLevel, center, 256.0);
        int cloudParticles = Math.round(20.0f * intensity);
        int ashParticles = Math.round(10.0f * intensity);
        for (i = 0; i < cloudParticles; ++i) {
            angle = random.m_188500_() * 2.0 * Math.PI;
            double sphereRadius = Math.sqrt(random.m_188500_()) * radius;
            x = center.f_82479_ + Math.cos(angle) * sphereRadius;
            z = center.f_82481_ + Math.sin(angle) * sphereRadius;
            y = center.f_82480_ + (random.m_188500_() - 0.5) * (radius * 0.5);
            speed = 0.002 + random.m_188500_() * 0.005;
            xSpeed = (random.m_188500_() - 0.5) * speed;
            ySpeed = random.m_188500_() * speed * 0.5;
            zSpeed = (random.m_188500_() - 0.5) * speed;
            for (ServerPlayer player : nearbyPlayers) {
                serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_175821_, true, x, y, z, 1, xSpeed, ySpeed, zSpeed, 0.1);
            }
        }
        for (i = 0; i < ashParticles; ++i) {
            angle = random.m_188500_() * 2.0 * Math.PI;
            double ashRadius = Math.sqrt(random.m_188500_()) * (radius * 1.1);
            x = center.f_82479_ + Math.cos(angle) * ashRadius;
            z = center.f_82481_ + Math.sin(angle) * ashRadius;
            y = center.f_82480_ + 0.1 + random.m_188500_() * 0.3;
            speed = 0.001 + random.m_188500_() * 0.002;
            xSpeed = (random.m_188500_() - 0.5) * speed;
            ySpeed = random.m_188500_() * speed * 0.5;
            zSpeed = (random.m_188500_() - 0.5) * speed;
            for (ServerPlayer player : nearbyPlayers) {
                serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123790_, true, x, y, z, 1, xSpeed, ySpeed, zSpeed, 0.1);
            }
        }
    }

    private static List<ServerPlayer> getNearbyPlayers(ServerLevel serverLevel, Vec3 center, double renderDistance) {
        AABB searchArea = new AABB(center.m_82492_(renderDistance, renderDistance, renderDistance), center.m_82520_(renderDistance, renderDistance, renderDistance));
        return serverLevel.m_45976_(ServerPlayer.class, searchArea);
    }

    public static void applyChokeEffects(Level level, Vec3 center, double radius) {
        if (level.f_46443_) {
            return;
        }
        double radiusSquared = radius * radius;
        AABB effectArea = new AABB(center.m_82492_(radius, radius, radius), center.m_82520_(radius, radius, radius));
        List entities = level.m_45976_(LivingEntity.class, effectArea);
        for (LivingEntity entity : entities) {
            ItemStack helmet;
            Player player;
            double distanceSquared = entity.m_20238_(center);
            if (distanceSquared > radiusSquared || entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_()) || entity instanceof Player && ExoSuitGasMaskHandler.hasProtection(player = (Player)entity) || (helmet = entity.m_6844_(EquipmentSlot.HEAD)).m_204117_(ModTags.Items.GAS_MASK)) continue;
            if (entity.m_20146_() > 0) {
                entity.m_20301_(entity.m_20146_() - 5);
            }
            if (entity.m_20146_() <= 0) {
                entity.m_6469_(entity.m_269291_().m_269063_(), 2.0f);
            }
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 100, 0, false, true));
        }
    }

    public static void extinguishFireInArea(Level level, Vec3 center, double radius) {
        BlockPos centerPos = BlockPos.m_274446_((Position)center);
        int blockRadius = (int)Math.ceil(radius);
        for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)centerPos.m_7918_(-blockRadius, -1, -blockRadius), (BlockPos)centerPos.m_7918_(blockRadius, 1, blockRadius))) {
            if (!(center.m_82554_(Vec3.m_82512_((Vec3i)checkPos)) <= radius)) continue;
            BlockState blockState = level.m_8055_(checkPos);
            if (blockState.m_60713_(Blocks.f_50083_) || blockState.m_60713_(Blocks.f_50084_)) {
                level.m_7731_(checkPos, Blocks.f_50016_.m_49966_(), 3);
                continue;
            }
            if (!blockState.m_60713_(Blocks.f_50683_) && !blockState.m_60713_(Blocks.f_50684_)) continue;
            level.m_7731_(checkPos, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)), 3);
        }
        AABB effectArea = new AABB(centerPos).m_82400_(radius);
        List affectedEntities = level.m_45976_(LivingEntity.class, effectArea);
        for (LivingEntity affectedEntity : affectedEntities) {
            if (!affectedEntity.m_6060_()) continue;
            affectedEntity.m_20095_();
        }
    }

    public static boolean isChokeBombActive(Level level, Vec3 position, double checkRadius) {
        if (level.f_46443_) {
            return false;
        }
        AABB searchArea = new AABB(position.m_82492_(checkRadius, checkRadius, checkRadius), position.m_82520_(checkRadius, checkRadius, checkRadius));
        List allEntities = level.m_45933_((Entity)null, searchArea);
        for (Entity entity : allEntities) {
            if (!entity.getClass().getSimpleName().equals("ThrowableChokeBombEntity")) continue;
            try {
                Field cloudActiveField = entity.getClass().getDeclaredField("cloudActive");
                cloudActiveField.setAccessible(true);
                if (!cloudActiveField.getBoolean(entity)) continue;
                return true;
            }
            catch (Exception e) {
            }
        }
        return false;
    }

    public static void removeGasCloudsInArea(Level level, Vec3 center, double radius) {
        if (level.f_46443_) {
            return;
        }
        AABB searchArea = new AABB(center.m_82492_(radius, radius, radius), center.m_82520_(radius, radius, radius));
        List allEntities = level.m_45933_((Entity)null, searchArea);
        for (Entity entity : allEntities) {
            if (!entity.getClass().getSimpleName().equals("ThrowableGasGrenadeEntity")) continue;
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }
}

