/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import top.ribs.scguns.Config;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.init.ModTags;
import top.ribs.scguns.util.GunModifierHelper;

public class GunEffectsHandler {
    private static final Map<UUID, Long> lastEffectTime = new ConcurrentHashMap<UUID, Long>();
    private static final long EFFECT_COOLDOWN_MS = 250L;
    private static final int MAX_ENTITIES_PER_SHOT = 25;
    private static final Map<UUID, Integer> shotCounter = new ConcurrentHashMap<UUID, Integer>();
    private static final Predicate<LivingEntity> FLEEING_ENTITIES = entity -> {
        if (entity instanceof Animal) {
            return true;
        }
        if (entity.m_6095_().m_204039_(ModTags.Entities.FLEEING_FROM_GUNS)) {
            return true;
        }
        return ((List)Config.COMMON.fleeingMobs.fleeingEntities.get()).contains(EntityType.m_20613_((EntityType)entity.m_6095_()).toString());
    };
    private static final Predicate<LivingEntity> HOSTILE_ENTITIES = entity -> {
        if (entity.m_6095_().m_204039_(ModTags.Entities.AGGRO_FROM_GUNS)) {
            return true;
        }
        if (entity.m_5720_() == SoundSource.HOSTILE) {
            return true;
        }
        if (entity.m_6095_() == EntityType.f_20511_ || entity.m_6095_() == EntityType.f_20512_ || entity.m_6095_() == ModEntities.HORNLIN.get() || entity.m_6095_() == ModEntities.ZOMBIFIED_HORNLIN.get() || entity.m_6095_() == EntityType.f_20531_ || entity.m_6095_() == EntityType.f_20566_) {
            return true;
        }
        return !((List)Config.COMMON.aggroMobs.exemptEntities.get()).contains(EntityType.m_20613_((EntityType)entity.m_6095_()).toString());
    };

    public static void handleGunEffects(ServerPlayer player, ItemStack heldItem, Gun modifiedGun) {
        int shots;
        if (player.m_7500_() || !((Boolean)Config.COMMON.aggroMobs.enabled.get()).booleanValue() && !((Boolean)Config.COMMON.fleeingMobs.enabled.get()).booleanValue()) {
            return;
        }
        UUID playerId = player.m_20148_();
        long currentTime = System.currentTimeMillis();
        Long lastTime = lastEffectTime.get(playerId);
        if (lastTime != null && currentTime - lastTime < 250L) {
            return;
        }
        int fireRate = modifiedGun.getGeneral().getRate();
        if (fireRate < 6 && (shots = shotCounter.merge(playerId, 1, Integer::sum).intValue()) % 2 != 0) {
            return;
        }
        lastEffectTime.put(playerId, currentTime);
        Level world = player.m_9236_();
        boolean isSilenced = GunModifierHelper.isSilencedFire(heldItem);
        if (!isSilenced && world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            GunEffectsHandler.triggerSculkSensor(serverLevel, player);
        }
        double effectRadius = GunEffectsHandler.getEffectRadius(isSilenced);
        List<LivingEntity> nearbyEntities = GunEffectsHandler.getOptimizedNearbyEntities(world, player, effectRadius);
        for (LivingEntity entity : nearbyEntities) {
            if (entity == player) continue;
            GunEffectsHandler.handleEntityReaction(entity, player, isSilenced);
        }
        if (player.f_19797_ % 1200 == 0) {
            GunEffectsHandler.cleanupOldEntries(currentTime);
        }
    }

    private static void triggerSculkSensor(ServerLevel level, ServerPlayer player) {
        BlockPos playerPos = player.m_20183_();
        level.m_220407_(GameEvent.f_157778_, playerPos, GameEvent.Context.m_223717_((Entity)player));
    }

    private static double getEffectRadius(boolean isSilenced) {
        if (isSilenced) {
            return (Double)Config.COMMON.fleeingMobs.silencedRange.get();
        }
        return Math.max((Double)Config.COMMON.aggroMobs.unsilencedRange.get(), (Double)Config.COMMON.fleeingMobs.unsilencedRange.get());
    }

    private static List<LivingEntity> getOptimizedNearbyEntities(Level world, ServerPlayer player, double radius) {
        AABB searchArea = new AABB(player.m_20185_() - radius, player.m_20186_() - radius, player.m_20189_() - radius, player.m_20185_() + radius, player.m_20186_() + radius, player.m_20189_() + radius);
        List entities = world.m_45976_(LivingEntity.class, searchArea);
        if (entities.size() > 25) {
            return entities.stream().sorted(Comparator.comparingDouble(e -> e.m_20280_((Entity)player))).limit(25L).collect(Collectors.toList());
        }
        return entities;
    }

    private static void handleEntityReaction(LivingEntity entity, ServerPlayer player, boolean isSilenced) {
        if (!isSilenced) {
            if (GunEffectsHandler.shouldEntityFlee(entity)) {
                GunEffectsHandler.applyKnockbackEffect(entity, player);
            }
            if (GunEffectsHandler.shouldEntityAggro(entity)) {
                GunEffectsHandler.handleAggroBehavior(entity, player);
            }
        }
    }

    private static boolean shouldEntityFlee(LivingEntity entity) {
        return (Boolean)Config.COMMON.fleeingMobs.enabled.get() != false && FLEEING_ENTITIES.test(entity) && !GunEffectsHandler.isTamedMob(entity) && entity.m_20197_().isEmpty();
    }

    private static boolean shouldEntityAggro(LivingEntity entity) {
        return (Boolean)Config.COMMON.aggroMobs.enabled.get() != false && HOSTILE_ENTITIES.test(entity);
    }

    private static boolean isTamedMob(LivingEntity entity) {
        if (entity instanceof TamableAnimal) {
            TamableAnimal tamableAnimal = (TamableAnimal)entity;
            return tamableAnimal.m_21824_();
        }
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            return horse.m_30614_();
        }
        return false;
    }

    private static void applyKnockbackEffect(LivingEntity entity, ServerPlayer player) {
        double deltaZ;
        double deltaX = entity.m_20185_() - player.m_20185_();
        double distance = Math.sqrt(deltaX * deltaX + (deltaZ = entity.m_20189_() - player.m_20189_()) * deltaZ);
        if (distance > 0.0) {
            double knockbackStrength = GunEffectsHandler.getKnockbackStrength(entity);
            double normalizedX = deltaX / distance;
            double normalizedZ = deltaZ / distance;
            entity.m_147240_(knockbackStrength, -normalizedX, -normalizedZ);
        }
    }

    private static double getKnockbackStrength(LivingEntity entity) {
        if (entity.m_6095_().m_204039_(ModTags.Entities.HEAVY)) {
            return 0.4;
        }
        if (entity.m_6095_().m_204039_(ModTags.Entities.VERY_HEAVY)) {
            return 0.2;
        }
        return 0.8;
    }

    private static void handleAggroBehavior(LivingEntity entity, ServerPlayer player) {
        if (entity instanceof Monster) {
            Monster monster = (Monster)entity;
            float aggroChance = ((Double)Config.COMMON.aggroMobs.aggroChance.get()).floatValue();
            if (player.m_9236_().f_46441_.m_188501_() < aggroChance) {
                monster.m_6710_((LivingEntity)player);
                GunEffectsHandler.alertNearbyMobs(monster, player);
            }
        }
    }

    private static void alertNearbyMobs(Monster alertedMob, ServerPlayer player) {
        double chainRadius = (Double)Config.COMMON.aggroMobs.chainAggroRadius.get();
        float chainChance = ((Double)Config.COMMON.aggroMobs.chainAggroChance.get()).floatValue();
        EntityType mobType = alertedMob.m_6095_();
        List<LivingEntity> nearbyMobs = GunEffectsHandler.getOptimizedNearbyEntities(player.m_9236_(), player, chainRadius);
        for (LivingEntity entity : nearbyMobs) {
            if (entity.m_6095_() != mobType || !(entity instanceof Monster)) continue;
            Monster nearbyMonster = (Monster)entity;
            if (entity == alertedMob || !(player.m_9236_().f_46441_.m_188501_() < chainChance)) continue;
            nearbyMonster.m_6710_((LivingEntity)player);
        }
    }

    private static void cleanupOldEntries(long currentTime) {
        long expireTime = currentTime - 5000L;
        lastEffectTime.entrySet().removeIf(entry -> (Long)entry.getValue() < expireTime);
        shotCounter.clear();
    }
}

