/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.interfaces.IProjectileFactory;

public class ProjectileManager {
    private static ProjectileManager instance = null;
    private final IProjectileFactory DEFAULT_FACTORY = (worldIn, entity, weapon, item, modifiedGun) -> new ProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun);
    private final Map<ResourceLocation, IProjectileFactory> projectileFactoryMap = new HashMap<ResourceLocation, IProjectileFactory>();

    public static ProjectileManager getInstance() {
        if (instance == null) {
            instance = new ProjectileManager();
        }
        return instance;
    }

    public void registerFactory(Item ammo, IProjectileFactory factory) {
        this.projectileFactoryMap.put(ForgeRegistries.ITEMS.getKey((Object)ammo), factory);
    }

    public IProjectileFactory getFactory(ResourceLocation id) {
        return this.projectileFactoryMap.getOrDefault(id, this.DEFAULT_FACTORY);
    }
}

