/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common;

import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandlerModifiable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animation.AnimationController;
import top.ribs.scguns.Config;
import top.ribs.scguns.attributes.SCAttributes;
import top.ribs.scguns.client.handler.ReloadHandler;
import top.ribs.scguns.common.AmmoContext;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.common.ReloadType;
import top.ribs.scguns.common.exosuit.ExoSuitAmmoHelper;
import top.ribs.scguns.common.network.ServerPlayHandler;
import top.ribs.scguns.event.GunEventBus;
import top.ribs.scguns.init.ModSyncedDataKeys;
import top.ribs.scguns.item.AmmoBoxItem;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.item.ammo_boxes.CreativeAmmoBoxItem;
import top.ribs.scguns.item.animated.AnimatedGunItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageGunSound;
import top.ribs.scguns.network.message.S2CMessageStopReload;
import top.ribs.scguns.util.GunEnchantmentHelper;
import top.ribs.scguns.util.GunModifierHelper;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ReloadTracker {
    private static final Map<Player, ReloadTracker> RELOAD_TRACKER_MAP = new WeakHashMap<Player, ReloadTracker>();
    private final int startTick;
    private final int slot;
    private final ItemStack stack;
    private final Gun gun;

    public ReloadTracker(Player player) {
        this.startTick = player.f_19797_;
        this.slot = player.m_150109_().f_35977_;
        this.stack = player.m_150109_().m_36056_();
        this.gun = ((GunItem)this.stack.m_41720_()).getModifiedGun(this.stack);
    }

    private void handleReloadByproduct(Player player) {
        Item byproduct;
        if (this.gun.getReloads().getReloadType() != ReloadType.SINGLE_ITEM) {
            return;
        }
        if (this.gun.getReloads().shouldGiveByproduct(player.m_9236_().m_213780_(), this.stack) && (byproduct = this.gun.getReloads().getReloadByproduct()) != null) {
            ItemStack byproductStack = new ItemStack((ItemLike)byproduct);
            if (GunEventBus.addCasingDirectly(player, byproductStack)) {
                return;
            }
            boolean added = player.m_150109_().m_36054_(byproductStack);
            if (!added) {
                Level level = player.m_9236_();
                double x = player.m_20185_();
                double y = player.m_20186_();
                double z = player.m_20189_();
                ItemEntity itemEntity = new ItemEntity(level, x, y, z, byproductStack);
                itemEntity.m_20334_(level.f_46441_.m_188500_() * 0.2 - 0.1, 0.2, level.f_46441_.m_188500_() * 0.2 - 0.1);
                level.m_7967_((Entity)itemEntity);
            }
        }
    }

    public boolean isWeaponFull(Player player) {
        int maxAmmo;
        ItemStack currentStack = player.m_21205_();
        CompoundTag tag = currentStack.m_41784_();
        int currentAmmo = tag.m_128451_("AmmoCount");
        return currentAmmo >= (maxAmmo = GunModifierHelper.getModifiedAmmoCapacity(currentStack, this.gun));
    }

    private boolean isWeaponEmpty() {
        CompoundTag tag = this.stack.m_41784_();
        return tag.m_128451_("AmmoCount") == 0;
    }

    public boolean hasNoAmmo(Player player) {
        boolean result = this.gun.getReloads().getReloadType() == ReloadType.SINGLE_ITEM ? Gun.findAmmo(player, this.gun.getReloads().getReloadItem()).stack().m_41619_() : Gun.findAmmo(player, this.gun.getProjectile().getItem()).stack().m_41619_();
        return result;
    }

    private boolean canReload(Player player) {
        if (this.gun.getReloads().getReloadType() == ReloadType.MANUAL) {
            return true;
        }
        int deltaTicks = player.f_19797_ - this.startTick;
        double reloadSpeed = Objects.requireNonNull(player.m_21051_((Attribute)SCAttributes.RELOAD_SPEED.get())).m_22135_();
        int interval = this.gun.getReloads().getReloadType() == ReloadType.SINGLE_ITEM ? (int)Math.ceil((double)GunEnchantmentHelper.getMagReloadSpeed(this.stack) / reloadSpeed) : (int)Math.ceil((double)GunEnchantmentHelper.getReloadInterval(this.stack) / reloadSpeed);
        return deltaTicks >= interval;
    }

    public static int ammoInInventory(ItemStack[] ammoStack) {
        int result = 0;
        for (ItemStack x : ammoStack) {
            result += x.m_41613_();
        }
        return result;
    }

    private void shrinkFromAmmoPool(ItemStack[] ammoStack, Player player, int shrinkAmount) {
        int[] shrinkAmt = new int[]{shrinkAmount};
        int exoSuitShrinkAmount = Math.min(shrinkAmt[0], ExoSuitAmmoHelper.getAmmoCountInExoSuit(player, this.gun.getProjectile().getItem()));
        if (exoSuitShrinkAmount > 0) {
            ExoSuitAmmoHelper.shrinkAmmoInExoSuit(player, this.gun.getProjectile().getItem(), exoSuitShrinkAmount);
            shrinkAmt[0] = shrinkAmt[0] - exoSuitShrinkAmount;
            if (shrinkAmt[0] == 0) {
                return;
            }
        }
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
            IItemHandlerModifiable curios = handler.getEquippedCurios();
            for (int i = 0; i < curios.getSlots(); ++i) {
                ItemStack stack = curios.getStackInSlot(i);
                if (!(stack.m_41720_() instanceof AmmoBoxItem)) continue;
                List<ItemStack> contents = AmmoBoxItem.getContents(stack).collect(Collectors.toList());
                for (ItemStack pouchAmmoStack : contents) {
                    if (pouchAmmoStack.m_41619_() || pouchAmmoStack.m_41720_() != this.gun.getProjectile().getItem()) continue;
                    int max = Math.min(shrinkAmt[0], pouchAmmoStack.m_41613_());
                    pouchAmmoStack.m_41774_(max);
                    shrinkAmt[0] = shrinkAmt[0] - max;
                    if (shrinkAmt[0] != 0) continue;
                    this.updateAmmoPouchContents(stack, contents);
                    return;
                }
                this.updateAmmoPouchContents(stack, contents);
            }
        });
        for (ItemStack itemStack : player.m_150109_().f_35974_) {
            if (!(itemStack.m_41720_() instanceof AmmoBoxItem)) continue;
            List<ItemStack> contents = AmmoBoxItem.getContents(itemStack).collect(Collectors.toList());
            for (ItemStack pouchAmmoStack : contents) {
                if (pouchAmmoStack.m_41619_() || pouchAmmoStack.m_41720_() != this.gun.getProjectile().getItem()) continue;
                int max = Math.min(shrinkAmt[0], pouchAmmoStack.m_41613_());
                pouchAmmoStack.m_41774_(max);
                shrinkAmt[0] = shrinkAmt[0] - max;
                if (shrinkAmt[0] != 0) continue;
                this.updateAmmoPouchContents(itemStack, contents);
                return;
            }
            this.updateAmmoPouchContents(itemStack, contents);
        }
        for (ItemStack itemStack : ammoStack) {
            if (shrinkAmt[0] <= 0 || itemStack.m_41619_() || itemStack.m_41720_() != this.gun.getProjectile().getItem()) continue;
            int max = Math.min(shrinkAmt[0], itemStack.m_41613_());
            itemStack.m_41774_(max);
            shrinkAmt[0] = shrinkAmt[0] - max;
        }
    }

    private void shrinkFromAmmoPool(ItemStack ammoStack, Player player, int shrinkAmount) {
        int[] shrinkAmt = new int[]{shrinkAmount};
        int exoSuitShrinkAmount = Math.min(shrinkAmt[0], ExoSuitAmmoHelper.getAmmoCountInExoSuit(player, this.gun.getProjectile().getItem()));
        if (exoSuitShrinkAmount > 0) {
            ExoSuitAmmoHelper.shrinkAmmoInExoSuit(player, this.gun.getProjectile().getItem(), exoSuitShrinkAmount);
            shrinkAmt[0] = shrinkAmt[0] - exoSuitShrinkAmount;
            if (shrinkAmt[0] == 0) {
                return;
            }
        }
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
            IItemHandlerModifiable curios = handler.getEquippedCurios();
            for (int i = 0; i < curios.getSlots(); ++i) {
                ItemStack stack = curios.getStackInSlot(i);
                if (!(stack.m_41720_() instanceof AmmoBoxItem)) continue;
                List<ItemStack> contents = AmmoBoxItem.getContents(stack).collect(Collectors.toList());
                for (ItemStack pouchAmmoStack : contents) {
                    if (pouchAmmoStack.m_41619_() || pouchAmmoStack.m_41720_() != this.gun.getProjectile().getItem()) continue;
                    int max = Math.min(shrinkAmt[0], pouchAmmoStack.m_41613_());
                    pouchAmmoStack.m_41774_(max);
                    shrinkAmt[0] = shrinkAmt[0] - max;
                    if (shrinkAmt[0] != 0) continue;
                    this.updateAmmoPouchContents(stack, contents);
                    return;
                }
                this.updateAmmoPouchContents(stack, contents);
            }
        });
        for (ItemStack itemStack : player.m_150109_().f_35974_) {
            if (!(itemStack.m_41720_() instanceof AmmoBoxItem)) continue;
            List<ItemStack> contents = AmmoBoxItem.getContents(itemStack).collect(Collectors.toList());
            for (ItemStack pouchAmmoStack : contents) {
                if (pouchAmmoStack.m_41619_() || pouchAmmoStack.m_41720_() != this.gun.getProjectile().getItem()) continue;
                int max = Math.min(shrinkAmt[0], pouchAmmoStack.m_41613_());
                pouchAmmoStack.m_41774_(max);
                shrinkAmt[0] = shrinkAmt[0] - max;
                if (shrinkAmt[0] != 0) continue;
                this.updateAmmoPouchContents(itemStack, contents);
                return;
            }
            this.updateAmmoPouchContents(itemStack, contents);
        }
        if (shrinkAmt[0] > 0 && !ammoStack.m_41619_() && ammoStack.m_41720_() == this.gun.getProjectile().getItem()) {
            int max = Math.min(shrinkAmt[0], ammoStack.m_41613_());
            ammoStack.m_41774_(max);
            shrinkAmt[0] = shrinkAmt[0] - max;
        }
    }

    private void updateAmmoPouchContents(ItemStack ammoPouch, List<ItemStack> contents) {
        ListTag listTag = new ListTag();
        for (ItemStack stack : contents) {
            CompoundTag itemTag = new CompoundTag();
            stack.m_41739_(itemTag);
            listTag.add((Object)itemTag);
        }
        ammoPouch.m_41784_().m_128365_("Items", (Tag)listTag);
    }

    public void increaseMagAmmo(Player player) {
        CompoundTag tag;
        ItemStack[] ammoStack = Gun.findAmmoStack(player, this.gun.getProjectile().getItem());
        if (ammoStack.length > 0 && (tag = this.stack.m_41783_()) != null) {
            int amount;
            int ammoAmount;
            boolean hasCreativeBox;
            int maxAmmo = GunModifierHelper.getModifiedAmmoCapacity(this.stack, this.gun);
            boolean bl = hasCreativeBox = player.m_150109_().f_35974_.stream().anyMatch(i -> i.m_41720_() instanceof CreativeAmmoBoxItem) || ServerPlayHandler.hasCreativeAmmoBoxInCurios((ServerPlayer)player);
            if (hasCreativeBox) {
                tag.m_128405_("AmmoCount", maxAmmo);
                return;
            }
            int currentAmmo = tag.m_128451_("AmmoCount");
            if (currentAmmo < 0 || currentAmmo > maxAmmo) {
                currentAmmo = 0;
            }
            if ((ammoAmount = Math.min(ReloadTracker.ammoInInventory(ammoStack), maxAmmo)) < (amount = maxAmmo - currentAmmo)) {
                tag.m_128405_("AmmoCount", currentAmmo + ammoAmount);
                this.shrinkFromAmmoPool(ammoStack, player, ammoAmount);
            } else {
                tag.m_128405_("AmmoCount", maxAmmo);
                this.shrinkFromAmmoPool(ammoStack, player, amount);
            }
        }
        this.playReloadSound(player);
    }

    public void reloadItem(Player player) {
        Item reloadItem = this.gun.getReloads().getReloadItem();
        ItemStack[] ammoStacks = Gun.findAmmoStack(player, reloadItem);
        if (ammoStacks.length > 0) {
            CompoundTag tag = this.stack.m_41783_();
            if (tag != null) {
                int maxAmmo = GunModifierHelper.getModifiedAmmoCapacity(this.stack, this.gun);
                int currentAmmo = tag.m_128451_("AmmoCount");
                if (currentAmmo < maxAmmo) {
                    tag.m_128405_("AmmoCount", maxAmmo);
                    this.shrinkFromAmmoPool(ammoStacks, player, 1);
                    this.handleReloadByproduct(player);
                }
            }
            this.playReloadSound(player);
        }
    }

    public void increaseAmmo(Player player) {
        AmmoContext context = Gun.findAmmo(player, this.gun.getProjectile().getItem());
        ItemStack ammo = context.stack();
        if (!ammo.m_41619_()) {
            int amount = Math.min(ammo.m_41613_(), this.gun.getReloads().getReloadAmount());
            ItemStack currentStack = player.m_21205_();
            CompoundTag tag = currentStack.m_41783_();
            if (tag != null) {
                int maxAmmo = GunModifierHelper.getModifiedAmmoCapacity(currentStack, this.gun);
                int currentAmmo = tag.m_128451_("AmmoCount");
                amount = Math.min(amount, maxAmmo - currentAmmo);
                tag.m_128405_("AmmoCount", currentAmmo + amount);
            }
            this.shrinkFromAmmoPool(Gun.findAmmoStack(player, this.gun.getProjectile().getItem()), player, amount);
        }
        this.playReloadSound(player);
    }

    private void playReloadSound(Player player) {
        if (this.stack.m_41720_() instanceof AnimatedGunItem) {
            return;
        }
        ResourceLocation reloadSound = this.gun.getSounds().getReload();
        if (reloadSound != null) {
            double radius = (Double)Config.SERVER.reloadMaxDistance.get();
            double soundX = player.m_20185_();
            double soundY = player.m_20186_() + 1.0;
            double soundZ = player.m_20189_();
            S2CMessageGunSound message = new S2CMessageGunSound(reloadSound, SoundSource.PLAYERS, (float)soundX, (float)soundY, (float)soundZ, 1.0f, 1.0f, player.m_19879_(), false, true);
            PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.m_9236_(), (double)soundX, (double)soundY, (double)soundZ, (double)radius), (IMessage)message);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Player player = event.player;
        if (player.m_9236_().f_46443_) {
            return;
        }
        if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue()) {
            ItemStack heldItem = player.m_21205_();
            Item item = heldItem.m_41720_();
            if (item instanceof GunItem) {
                GunItem gunItem = (GunItem)item;
                Gun gun = gunItem.getModifiedGun(heldItem);
                if (gun.getReloads().getReloadType() != ReloadType.MANUAL) {
                    CompoundTag compoundTag = heldItem.m_41784_();
                }
                CompoundTag tag = heldItem.m_41784_();
                if (!heldItem.m_41720_().getClass().getPackageName().startsWith("top.ribs.scguns")) {
                    return;
                }
                ReloadTracker tracker = RELOAD_TRACKER_MAP.get(player);
                boolean needsNewTracker = false;
                if (tracker == null) {
                    needsNewTracker = true;
                } else {
                    ItemStack currentWeapon = player.m_150109_().m_36056_();
                    int currentSlot = player.m_150109_().f_35977_;
                    boolean isActivelyReloading = (Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player);
                    if (!(isActivelyReloading || tracker.slot == currentSlot && !currentWeapon.m_41619_() && currentWeapon.m_41720_().getClass().equals(tracker.stack.m_41720_().getClass()))) {
                        needsNewTracker = true;
                        RELOAD_TRACKER_MAP.remove(player);
                    }
                }
                if (needsNewTracker) {
                    if (!(player.m_150109_().m_36056_().m_41720_() instanceof GunItem)) {
                        ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                        return;
                    }
                    tracker = new ReloadTracker(player);
                    RELOAD_TRACKER_MAP.put(player, tracker);
                }
                boolean weaponFull = tracker.isWeaponFull(player);
                boolean hasNoAmmo = tracker.hasNoAmmo(player);
                if (weaponFull || hasNoAmmo) {
                    if (player.m_21205_().m_41720_() instanceof AnimatedGunItem && tracker.gun.getReloads().getReloadType() == ReloadType.MANUAL) {
                        if (tag.m_128471_("scguns:ShouldStopAfterLoop")) {
                            long stopTime = tag.m_128454_("scguns:StopAfterLoopTime");
                            if (stopTime == 0L) {
                                tag.m_128356_("scguns:StopAfterLoopTime", System.currentTimeMillis());
                                return;
                            }
                            if (System.currentTimeMillis() - stopTime < 100L) {
                                return;
                            }
                            tag.m_128473_("scguns:ShouldStopAfterLoop");
                            tag.m_128473_("scguns:StopAfterLoopTime");
                        } else {
                            tag.m_128379_("scguns:ShouldStopAfterLoop", true);
                            return;
                        }
                    }
                    RELOAD_TRACKER_MAP.remove(player);
                    ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                    tag.m_128473_("IsReloading");
                    tag.m_128473_("scguns:IsReloading");
                    if (player.m_21205_().m_41720_() instanceof AnimatedGunItem) {
                        tag.m_128359_("scguns:ReloadState", "STOPPING");
                        tag.m_128379_("scguns:IsPlayingReloadStop", true);
                        PacketHandler.getPlayChannel().sendToPlayer(() -> (ServerPlayer)player, (IMessage)new S2CMessageStopReload());
                    }
                }
            }
        } else {
            RELOAD_TRACKER_MAP.remove(player);
            CompoundTag tag = player.m_21205_().m_41783_();
            if (tag != null) {
                tag.m_128473_("IsReloading");
            }
        }
    }

    public static void loaded(Player player) {
        ItemStack heldItem = player.m_21205_();
        if (!heldItem.m_41720_().getClass().getPackageName().startsWith("top.ribs.scguns")) {
            return;
        }
        CompoundTag tag = player.m_21205_().m_41783_();
        if (!((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player)).booleanValue()) {
            RELOAD_TRACKER_MAP.remove(player);
            if (tag != null) {
                tag.m_128473_("IsReloading");
            }
            return;
        }
        if (!RELOAD_TRACKER_MAP.containsKey(player)) {
            if (!(player.m_150109_().m_36056_().m_41720_() instanceof GunItem)) {
                ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                return;
            }
            RELOAD_TRACKER_MAP.put(player, new ReloadTracker(player));
        }
        ReloadTracker tracker = RELOAD_TRACKER_MAP.get(player);
        boolean weaponChanged = false;
        ItemStack currentWeapon = player.m_150109_().m_36056_();
        int currentSlot = player.m_150109_().f_35977_;
        if (tracker.slot != currentSlot || !currentWeapon.m_41720_().equals(tracker.stack.m_41720_()) || currentWeapon.m_41619_()) {
            weaponChanged = true;
        }
        if (weaponChanged || tracker.hasNoAmmo(player) || tracker.isWeaponFull(player) && tracker.gun.getReloads().getReloadType() != ReloadType.MANUAL) {
            RELOAD_TRACKER_MAP.remove(player);
            ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
            if (tag != null) {
                tag.m_128473_("IsReloading");
            }
            return;
        }
        Item item = player.m_21205_().m_41720_();
        if (item instanceof GunItem) {
            Gun gun = tracker.gun;
            ReloadType reloadType = gun.getReloads().getReloadType();
            if (!(item instanceof AnimatedGunItem)) {
                if (reloadType == ReloadType.MAG_FED) {
                    tracker.increaseMagAmmo(player);
                } else if (reloadType == ReloadType.SINGLE_ITEM) {
                    tracker.reloadItem(player);
                } else if (reloadType == ReloadType.MANUAL) {
                    tracker.increaseAmmo(player);
                }
                RELOAD_TRACKER_MAP.remove(player);
                ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                if (tag != null) {
                    tag.m_128473_("IsReloading");
                }
                return;
            }
            if (item instanceof AnimatedGunItem) {
                AnimatedGunItem gunItem = (AnimatedGunItem)item;
                if (item.getClass().getPackageName().startsWith("top.ribs.scguns")) {
                    if (reloadType == ReloadType.MANUAL) {
                        tracker.increaseAmmo(player);
                    }
                    if (tracker.isWeaponFull(player) || tracker.hasNoAmmo(player)) {
                        long id = GeoItem.getId((ItemStack)player.m_21205_());
                        AnimationController animationController = (AnimationController)gunItem.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
                        animationController.setAnimationSpeed(1.0);
                        animationController.forceAnimationReset();
                        if (reloadType == ReloadType.MANUAL) {
                            ReloadHandler.loaded(player);
                        }
                        tracker.handleReloadByproduct(player);
                        RELOAD_TRACKER_MAP.remove(player);
                        ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                        if (tag != null) {
                            tag.m_128473_("IsReloading");
                        }
                    }
                }
            }
        }
    }
}

