/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common;

import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.item.GunItem;

@Mod.EventBusSubscriber(modid="scguns")
public class ServerBurstTracker {
    private static final Map<UUID, BurstData> burstDataMap = new WeakHashMap<UUID, BurstData>();

    public static int getBurstCount(ServerPlayer player) {
        BurstData data = burstDataMap.get(player.m_20148_());
        if (data != null && data.isSameWeapon(player)) {
            return data.burstCount;
        }
        return 0;
    }

    public static void setBurstCount(ServerPlayer player, int count) {
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof GunItem) {
            burstDataMap.put(player.m_20148_(), new BurstData(count, player.m_150109_().f_35977_, heldItem));
        }
    }

    public static void decrementBurstCount(ServerPlayer player) {
        BurstData data = burstDataMap.get(player.m_20148_());
        if (data != null && data.isSameWeapon(player)) {
            data.burstCount = Math.max(0, data.burstCount - 1);
        }
    }

    public static void clearBurstData(ServerPlayer player) {
        burstDataMap.remove(player.m_20148_());
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ServerBurstTracker.clearBurstData(player2);
        }
    }

    public static class BurstData {
        public int burstCount = 0;
        public int weaponSlot = -1;
        public ItemStack weaponStack = ItemStack.f_41583_;

        public BurstData(int burstCount, int slot, ItemStack stack) {
            this.burstCount = burstCount;
            this.weaponSlot = slot;
            this.weaponStack = stack;
        }

        public boolean isSameWeapon(ServerPlayer player) {
            return player.m_150109_().f_35977_ == this.weaponSlot && player.m_150109_().m_36056_() == this.weaponStack;
        }
    }
}

