/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class VentCollectorConfig
implements INBTSerializable<CompoundTag> {
    protected Filters filters = new Filters();
    protected Processing processing = new Processing();

    public Filters getFilters() {
        return this.filters;
    }

    public Processing getProcessing() {
        return this.processing;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Filters", (Tag)this.filters.serializeNBT());
        tag.m_128365_("Processing", (Tag)this.processing.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("Filters", 10)) {
            this.filters.deserializeNBT(tag.m_128469_("Filters"));
        }
        if (tag.m_128425_("Processing", 10)) {
            this.processing.deserializeNBT(tag.m_128469_("Processing"));
        }
    }

    public JsonObject toJsonObject() {
        JsonObject object = new JsonObject();
        object.add("filters", (JsonElement)this.filters.toJsonObject());
        object.add("processing", (JsonElement)this.processing.toJsonObject());
        return object;
    }

    public static VentCollectorConfig create(CompoundTag tag) {
        VentCollectorConfig config = new VentCollectorConfig();
        config.deserializeNBT(tag);
        return config;
    }

    public VentCollectorConfig copy() {
        VentCollectorConfig config = new VentCollectorConfig();
        config.filters = this.filters.copy();
        config.processing = this.processing.copy();
        return config;
    }

    public static class Filters
    implements INBTSerializable<CompoundTag> {
        private int maxCharge = 64;
        private float consumptionChance = 0.5f;
        private int processCooldown = 2;
        private final List<FilterItem> filterItems = new ArrayList<FilterItem>();

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("MaxCharge", this.maxCharge);
            tag.m_128350_("ConsumptionChance", this.consumptionChance);
            tag.m_128405_("ProcessCooldown", this.processCooldown);
            CompoundTag itemsTag = new CompoundTag();
            for (int i = 0; i < this.filterItems.size(); ++i) {
                itemsTag.m_128365_("FilterItem" + i, (Tag)this.filterItems.get(i).serializeNBT());
            }
            tag.m_128365_("FilterItems", (Tag)itemsTag);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("MaxCharge", 99)) {
                this.maxCharge = tag.m_128451_("MaxCharge");
            }
            if (tag.m_128425_("ConsumptionChance", 99)) {
                this.consumptionChance = tag.m_128457_("ConsumptionChance");
            }
            if (tag.m_128425_("ProcessCooldown", 99)) {
                this.processCooldown = tag.m_128451_("ProcessCooldown");
            }
            if (tag.m_128425_("FilterItems", 10)) {
                CompoundTag itemsTag = tag.m_128469_("FilterItems");
                this.filterItems.clear();
                int i = 0;
                while (itemsTag.m_128441_("FilterItem" + i)) {
                    FilterItem item = new FilterItem();
                    item.deserializeNBT(itemsTag.m_128469_("FilterItem" + i));
                    this.filterItems.add(item);
                    ++i;
                }
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (this.maxCharge != 64) {
                object.addProperty("maxCharge", (Number)this.maxCharge);
            }
            if (this.consumptionChance != 0.5f) {
                object.addProperty("consumptionChance", (Number)Float.valueOf(this.consumptionChance));
            }
            if (this.processCooldown != 2) {
                object.addProperty("processCooldown", (Number)this.processCooldown);
            }
            if (!this.filterItems.isEmpty()) {
                JsonArray itemsArray = new JsonArray();
                for (FilterItem item : this.filterItems) {
                    itemsArray.add((JsonElement)item.toJsonObject());
                }
                object.add("filterItems", (JsonElement)itemsArray);
            }
            return object;
        }

        public Filters copy() {
            Filters filters = new Filters();
            filters.maxCharge = this.maxCharge;
            filters.consumptionChance = this.consumptionChance;
            filters.processCooldown = this.processCooldown;
            for (FilterItem item : this.filterItems) {
                filters.filterItems.add(item.copy());
            }
            return filters;
        }

        public int getMaxCharge() {
            return this.maxCharge;
        }

        public float getConsumptionChance() {
            return this.consumptionChance;
        }

        public int getProcessCooldown() {
            return this.processCooldown;
        }

        public List<FilterItem> getFilterItems() {
            return this.filterItems;
        }

        public void setMaxCharge(int maxCharge) {
            this.maxCharge = maxCharge;
        }

        public void setConsumptionChance(float consumptionChance) {
            this.consumptionChance = consumptionChance;
        }

        public void setProcessCooldown(int processCooldown) {
            this.processCooldown = processCooldown;
        }

        public void clearFilterItems() {
            this.filterItems.clear();
        }

        public void addFilterItem(FilterItem item) {
            this.filterItems.add(item);
        }

        public static class FilterItem
        implements INBTSerializable<CompoundTag> {
            private ResourceLocation identifier;
            private boolean isTag = true;
            private int chargeAmount;

            public CompoundTag serializeNBT() {
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("Identifier", this.identifier.toString());
                tag.m_128379_("IsTag", this.isTag);
                tag.m_128405_("ChargeAmount", this.chargeAmount);
                return tag;
            }

            public void deserializeNBT(CompoundTag tag) {
                if (tag.m_128425_("Identifier", 8)) {
                    this.identifier = new ResourceLocation(tag.m_128461_("Identifier"));
                }
                if (tag.m_128425_("IsTag", 99)) {
                    this.isTag = tag.m_128471_("IsTag");
                }
                if (tag.m_128425_("ChargeAmount", 99)) {
                    this.chargeAmount = tag.m_128451_("ChargeAmount");
                }
            }

            public JsonObject toJsonObject() {
                JsonObject object = new JsonObject();
                if (this.isTag) {
                    object.addProperty("tag", this.identifier.toString());
                } else {
                    object.addProperty("item", this.identifier.toString());
                }
                object.addProperty("chargeAmount", (Number)this.chargeAmount);
                return object;
            }

            public FilterItem copy() {
                FilterItem item = new FilterItem();
                item.identifier = this.identifier;
                item.isTag = this.isTag;
                item.chargeAmount = this.chargeAmount;
                return item;
            }

            public ResourceLocation getIdentifier() {
                return this.identifier;
            }

            public boolean isTag() {
                return this.isTag;
            }

            public int getChargeAmount() {
                return this.chargeAmount;
            }

            public void setIdentifier(ResourceLocation identifier) {
                this.identifier = identifier;
            }

            public void setIsTag(boolean isTag) {
                this.isTag = isTag;
            }

            public void setChargeAmount(int chargeAmount) {
                this.chargeAmount = chargeAmount;
            }
        }
    }

    public static class Processing
    implements INBTSerializable<CompoundTag> {
        private float powerSpeedMultiplier = 0.35f;
        private int pushCooldown = 5;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128350_("PowerSpeedMultiplier", this.powerSpeedMultiplier);
            tag.m_128405_("PushCooldown", this.pushCooldown);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("PowerSpeedMultiplier", 99)) {
                this.powerSpeedMultiplier = tag.m_128457_("PowerSpeedMultiplier");
            }
            if (tag.m_128425_("PushCooldown", 99)) {
                this.pushCooldown = tag.m_128451_("PushCooldown");
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (this.powerSpeedMultiplier != 0.35f) {
                object.addProperty("powerSpeedMultiplier", (Number)Float.valueOf(this.powerSpeedMultiplier));
            }
            if (this.pushCooldown != 5) {
                object.addProperty("pushCooldown", (Number)this.pushCooldown);
            }
            return object;
        }

        public Processing copy() {
            Processing processing = new Processing();
            processing.powerSpeedMultiplier = this.powerSpeedMultiplier;
            processing.pushCooldown = this.pushCooldown;
            return processing;
        }

        public float getPowerSpeedMultiplier() {
            return this.powerSpeedMultiplier;
        }

        public int getPushCooldown() {
            return this.pushCooldown;
        }

        public void setPowerSpeedMultiplier(float powerSpeedMultiplier) {
            this.powerSpeedMultiplier = powerSpeedMultiplier;
        }

        public void setPushCooldown(int pushCooldown) {
            this.pushCooldown = pushCooldown;
        }
    }
}

