/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common.exosuit;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.ItemStackHandler;
import top.ribs.scguns.common.exosuit.ExoSuitData;
import top.ribs.scguns.common.exosuit.ExoSuitUpgrade;
import top.ribs.scguns.common.exosuit.ExoSuitUpgradeManager;
import top.ribs.scguns.item.AmmoBoxItem;
import top.ribs.scguns.item.animated.ExoSuitItem;

public class ExoSuitAmmoHelper {
    public static ItemStack findAmmoInExoSuit(Player player, Item ammoItem) {
        ItemStack chestplate = ExoSuitAmmoHelper.getEquippedChestplate(player);
        if (chestplate.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack pouchUpgrade = ExoSuitAmmoHelper.findPouchUpgrade(chestplate);
        if (pouchUpgrade.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ExoSuitUpgrade upgrade = ExoSuitUpgradeManager.getUpgradeForItem(pouchUpgrade);
        if (upgrade == null) {
            return ItemStack.f_41583_;
        }
        String pouchId = ExoSuitAmmoHelper.getPouchId(pouchUpgrade);
        ItemStackHandler pouchInventory = ExoSuitAmmoHelper.getPouchInventory(chestplate, pouchId, upgrade.getDisplay().getStorageSize());
        for (int i = 0; i < pouchInventory.getSlots(); ++i) {
            ItemStack stack = pouchInventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() == ammoItem) {
                return stack;
            }
            if (!(stack.m_41720_() instanceof AmmoBoxItem)) continue;
            try {
                List<ItemStack> ammoBoxContents = AmmoBoxItem.getContents(stack).toList();
                for (ItemStack ammoStack : ammoBoxContents) {
                    if (ammoStack.m_41619_() || ammoStack.m_41720_() != ammoItem) continue;
                    return ammoStack;
                }
                continue;
            }
            catch (Exception e) {
                System.out.println("Error reading AmmoBox contents: " + e.getMessage());
                e.printStackTrace();
            }
        }
        System.out.println("No ammo found in exo suit pouches");
        return ItemStack.f_41583_;
    }

    public static List<ItemStack> findAllAmmoInExoSuit(Player player, Item ammoItem) {
        ItemStack stack;
        int i;
        ArrayList<ItemStack> ammoStacks = new ArrayList<ItemStack>();
        ItemStack chestplate = ExoSuitAmmoHelper.getEquippedChestplate(player);
        if (chestplate.m_41619_()) {
            return ammoStacks;
        }
        ItemStack pouchUpgrade = ExoSuitAmmoHelper.findPouchUpgrade(chestplate);
        if (pouchUpgrade.m_41619_()) {
            return ammoStacks;
        }
        ExoSuitUpgrade upgrade = ExoSuitUpgradeManager.getUpgradeForItem(pouchUpgrade);
        if (upgrade == null) {
            return ammoStacks;
        }
        String pouchId = ExoSuitAmmoHelper.getPouchId(pouchUpgrade);
        ItemStackHandler pouchInventory = ExoSuitAmmoHelper.getPouchInventory(chestplate, pouchId, upgrade.getDisplay().getStorageSize());
        for (i = 0; i < pouchInventory.getSlots(); ++i) {
            stack = pouchInventory.getStackInSlot(i);
            if (stack.m_41619_() || stack.m_41720_() != ammoItem) continue;
            ammoStacks.add(stack);
        }
        for (i = 0; i < pouchInventory.getSlots(); ++i) {
            stack = pouchInventory.getStackInSlot(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof AmmoBoxItem)) continue;
            try {
                List<ItemStack> ammoBoxContents = AmmoBoxItem.getContents(stack).toList();
                for (ItemStack ammoStack : ammoBoxContents) {
                    if (ammoStack.m_41619_() || ammoStack.m_41720_() != ammoItem) continue;
                    ammoStacks.add(ammoStack);
                }
                continue;
            }
            catch (Exception e) {
                System.out.println("Error reading AmmoBox contents in findAllAmmoInExoSuit: " + e.getMessage());
            }
        }
        return ammoStacks;
    }

    public static int getAmmoCountInExoSuit(Player player, Item ammoItem) {
        ItemStack stack;
        int i;
        int totalCount = 0;
        ItemStack chestplate = ExoSuitAmmoHelper.getEquippedChestplate(player);
        if (chestplate.m_41619_()) {
            return totalCount;
        }
        ItemStack pouchUpgrade = ExoSuitAmmoHelper.findPouchUpgrade(chestplate);
        if (pouchUpgrade.m_41619_()) {
            return totalCount;
        }
        ExoSuitUpgrade upgrade = ExoSuitUpgradeManager.getUpgradeForItem(pouchUpgrade);
        if (upgrade == null) {
            return totalCount;
        }
        String pouchId = ExoSuitAmmoHelper.getPouchId(pouchUpgrade);
        ItemStackHandler pouchInventory = ExoSuitAmmoHelper.getPouchInventory(chestplate, pouchId, upgrade.getDisplay().getStorageSize());
        for (i = 0; i < pouchInventory.getSlots(); ++i) {
            stack = pouchInventory.getStackInSlot(i);
            if (stack.m_41619_() || stack.m_41720_() != ammoItem) continue;
            totalCount += stack.m_41613_();
        }
        for (i = 0; i < pouchInventory.getSlots(); ++i) {
            stack = pouchInventory.getStackInSlot(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof AmmoBoxItem)) continue;
            try {
                List<ItemStack> ammoBoxContents = AmmoBoxItem.getContents(stack).toList();
                for (ItemStack ammoStack : ammoBoxContents) {
                    if (ammoStack.m_41619_() || ammoStack.m_41720_() != ammoItem) continue;
                    totalCount += ammoStack.m_41613_();
                }
                continue;
            }
            catch (Exception e) {
                System.out.println("Error reading AmmoBox contents in getAmmoCountInExoSuit: " + e.getMessage());
            }
        }
        return totalCount;
    }

    public static boolean addItemToExoSuit(Player player, ItemStack itemToAdd) {
        ItemStack chestplate = ExoSuitAmmoHelper.getEquippedChestplate(player);
        if (chestplate.m_41619_()) {
            return false;
        }
        ItemStack pouchUpgrade = ExoSuitAmmoHelper.findPouchUpgrade(chestplate);
        if (pouchUpgrade.m_41619_()) {
            return false;
        }
        ExoSuitUpgrade upgrade = ExoSuitUpgradeManager.getUpgradeForItem(pouchUpgrade);
        if (upgrade == null) {
            return false;
        }
        String pouchId = ExoSuitAmmoHelper.getPouchId(pouchUpgrade);
        ItemStackHandler pouchInventory = ExoSuitAmmoHelper.getPouchInventory(chestplate, pouchId, upgrade.getDisplay().getStorageSize());
        for (int i = 0; i < pouchInventory.getSlots(); ++i) {
            ItemStack remaining = pouchInventory.insertItem(i, itemToAdd, false);
            if (remaining.m_41619_()) {
                ExoSuitAmmoHelper.savePouchInventory(chestplate, pouchId, pouchInventory);
                return true;
            }
            if (remaining.m_41613_() >= itemToAdd.m_41613_()) continue;
            itemToAdd.m_41764_(remaining.m_41613_());
        }
        if (itemToAdd.m_41613_() < itemToAdd.m_41613_()) {
            ExoSuitAmmoHelper.savePouchInventory(chestplate, pouchId, pouchInventory);
        }
        return false;
    }

    public static void shrinkAmmoInExoSuit(Player player, Item ammoItem, int amountToShrink) {
        ItemStack stack;
        int i;
        ItemStack chestplate = ExoSuitAmmoHelper.getEquippedChestplate(player);
        if (chestplate.m_41619_()) {
            return;
        }
        ItemStack pouchUpgrade = ExoSuitAmmoHelper.findPouchUpgrade(chestplate);
        if (pouchUpgrade.m_41619_()) {
            return;
        }
        ExoSuitUpgrade upgrade = ExoSuitUpgradeManager.getUpgradeForItem(pouchUpgrade);
        if (upgrade == null) {
            return;
        }
        String pouchId = ExoSuitAmmoHelper.getPouchId(pouchUpgrade);
        ItemStackHandler pouchInventory = ExoSuitAmmoHelper.getPouchInventory(chestplate, pouchId, upgrade.getDisplay().getStorageSize());
        int remainingToShrink = amountToShrink;
        for (i = 0; i < pouchInventory.getSlots() && remainingToShrink > 0; ++i) {
            stack = pouchInventory.getStackInSlot(i);
            if (stack.m_41619_() || stack.m_41720_() != ammoItem) continue;
            int shrinkAmount = Math.min(remainingToShrink, stack.m_41613_());
            stack.m_41774_(shrinkAmount);
            remainingToShrink -= shrinkAmount;
            if (!stack.m_41619_()) continue;
            pouchInventory.setStackInSlot(i, ItemStack.f_41583_);
        }
        for (i = 0; i < pouchInventory.getSlots() && remainingToShrink > 0; ++i) {
            stack = pouchInventory.getStackInSlot(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof AmmoBoxItem)) continue;
            try {
                List<ItemStack> contents = AmmoBoxItem.getContents(stack).toList();
                boolean hasAmmo = false;
                for (ItemStack ammoStack : contents) {
                    if (ammoStack.m_41619_() || ammoStack.m_41720_() != ammoItem) continue;
                    hasAmmo = true;
                    break;
                }
                if (!hasAmmo) continue;
                new ItemStack((ItemLike)ammoItem, remainingToShrink);
                CompoundTag tag = stack.m_41784_();
                if (!tag.m_128441_("Items")) continue;
                int ammoInBox = 0;
                for (ItemStack ammoStack : contents) {
                    if (ammoStack.m_41619_() || ammoStack.m_41720_() != ammoItem) continue;
                    ammoInBox += ammoStack.m_41613_();
                }
                if (ammoInBox <= 0) continue;
                int toExtract = Math.min(remainingToShrink, ammoInBox);
                ItemStack newAmmoBox = stack.m_41777_();
                newAmmoBox.m_41784_().m_128473_("Items");
                int extracted = 0;
                for (ItemStack ammoStack : contents) {
                    if (extracted >= toExtract) {
                        if (ammoStack.m_41619_()) continue;
                        AmmoBoxItem.add(newAmmoBox, ammoStack);
                        continue;
                    }
                    if (ammoStack.m_41720_() == ammoItem) {
                        int canExtract = Math.min(toExtract - extracted, ammoStack.m_41613_());
                        extracted += canExtract;
                        if (ammoStack.m_41613_() <= canExtract) continue;
                        ItemStack remaining = ammoStack.m_41777_();
                        remaining.m_41764_(ammoStack.m_41613_() - canExtract);
                        AmmoBoxItem.add(newAmmoBox, remaining);
                        continue;
                    }
                    if (ammoStack.m_41619_()) continue;
                    AmmoBoxItem.add(newAmmoBox, ammoStack);
                }
                pouchInventory.setStackInSlot(i, newAmmoBox);
                remainingToShrink -= extracted;
                continue;
            }
            catch (Exception e) {
                System.out.println("Error shrinking ammo from AmmoBox: " + e.getMessage());
                e.printStackTrace();
            }
        }
        ExoSuitAmmoHelper.savePouchInventory(chestplate, pouchId, pouchInventory);
    }

    private static ItemStack getEquippedChestplate(Player player) {
        for (ItemStack armorStack : player.m_6168_()) {
            ExoSuitItem exosuit;
            Item item = armorStack.m_41720_();
            if (!(item instanceof ExoSuitItem) || (exosuit = (ExoSuitItem)item).m_266204_() != ArmorItem.Type.CHESTPLATE) continue;
            return armorStack;
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack findPouchUpgrade(ItemStack chestplate) {
        for (int slot = 0; slot < 4; ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(chestplate, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("pouches")) continue;
            return upgradeItem;
        }
        return ItemStack.f_41583_;
    }

    private static String getPouchId(ItemStack pouchUpgrade) {
        return pouchUpgrade.m_41720_().toString();
    }

    private static ItemStackHandler getPouchInventory(ItemStack chestplate, String pouchId, int size) {
        CompoundTag pouchData = chestplate.m_41784_().m_128469_("PouchData");
        ItemStackHandler handler = new ItemStackHandler(size);
        if (pouchData.m_128441_(pouchId)) {
            handler.deserializeNBT(pouchData.m_128469_(pouchId));
        }
        return handler;
    }

    private static void savePouchInventory(ItemStack chestplate, String pouchId, ItemStackHandler handler) {
        CompoundTag pouchData = chestplate.m_41784_().m_128469_("PouchData");
        pouchData.m_128365_(pouchId, (Tag)handler.serializeNBT());
        chestplate.m_41784_().m_128365_("PouchData", (Tag)pouchData);
    }
}

