/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common.exosuit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.common.exosuit.ExoSuitData;
import top.ribs.scguns.common.exosuit.ExoSuitEffectsHandler;
import top.ribs.scguns.common.exosuit.ExoSuitUpgrade;
import top.ribs.scguns.common.exosuit.ExoSuitUpgradeManager;
import top.ribs.scguns.item.animated.ExoSuitItem;
import top.ribs.scguns.item.exosuit.DamageableUpgradeItem;

@Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ExoSuitDamageHandler {
    private static final Random RANDOM = new Random();
    private static final float PLATING_ABSORPTION = 0.8f;
    private static final float COMPONENT_ABSORPTION = 0.3f;
    private static final float EXOSUIT_ABSORPTION = 0.1f;
    private static final long DURABILITY_DAMAGE_COOLDOWN = 1000L;
    private static final Map<UUID, Long> lastDurabilityDamage = new HashMap<UUID, Long>();
    private static final long CONTINUOUS_DAMAGE_COOLDOWN = 2000L;
    private static final String[] CONTINUOUS_DAMAGE_SOURCES = new String[]{"slime", "magmaCube", "mob", "sweetBerryBush", "cactus", "hotFloor"};

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingAttack(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_9236_().f_46443_) {
            return;
        }
        List<ItemStack> exoSuitPieces = ExoSuitDamageHandler.getEquippedExoSuitPieces(player);
        if (exoSuitPieces.isEmpty()) {
            return;
        }
        UUID playerUUID = player.m_20148_();
        long currentTime = System.currentTimeMillis();
        long cooldownTime = ExoSuitDamageHandler.isContinuousDamageSource(event.getSource().m_19385_()) ? 2000L : 1000L;
        Long lastDamageTime = lastDurabilityDamage.get(playerUUID);
        if (lastDamageTime != null && currentTime - lastDamageTime < cooldownTime) {
            return;
        }
        lastDurabilityDamage.put(playerUUID, currentTime);
        ExoSuitDamageHandler.cleanupOldEntries(currentTime);
        float damageToDistribute = event.getAmount();
        boolean componentsChanged = false;
        for (ItemStack exoSuitPiece : exoSuitPieces) {
            float remainingDamage = ExoSuitDamageHandler.distributeDamageToComponents(exoSuitPiece, damageToDistribute / (float)exoSuitPieces.size());
            if (remainingDamage != damageToDistribute / (float)exoSuitPieces.size()) {
                componentsChanged = true;
            }
            if (!(RANDOM.nextFloat() < 0.1f)) continue;
            exoSuitPiece.m_41721_(exoSuitPiece.m_41773_() + 1);
        }
        if (componentsChanged) {
            player.m_9236_().m_7654_().execute(() -> ExoSuitEffectsHandler.applyExoSuitEffects(player));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_9236_().f_46443_) {
            return;
        }
        List<ItemStack> exoSuitPieces = ExoSuitDamageHandler.getEquippedExoSuitPieces(player);
        if (exoSuitPieces.isEmpty()) {
            return;
        }
        float totalDamageReduction = ExoSuitDamageHandler.calculatePlatingDamageReduction(exoSuitPieces, event.getAmount());
        if (totalDamageReduction > 0.0f) {
            float newDamage = Math.max(0.0f, event.getAmount() - totalDamageReduction);
            event.setAmount(newDamage);
        }
    }

    private static boolean isContinuousDamageSource(String damageSourceId) {
        if (damageSourceId == null) {
            return false;
        }
        String lowerSource = damageSourceId.toLowerCase();
        for (String continuousSource : CONTINUOUS_DAMAGE_SOURCES) {
            if (!lowerSource.contains(continuousSource)) continue;
            return true;
        }
        return false;
    }

    private static void cleanupOldEntries(long currentTime) {
        if (RANDOM.nextInt(100) == 0) {
            lastDurabilityDamage.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > Math.max(1000L, 2000L) * 2L);
        }
    }

    private static float calculatePlatingDamageReduction(List<ItemStack> exoSuitPieces, float damage) {
        float totalReduction = 0.0f;
        int functionalPlatingCount = 0;
        for (ItemStack exoSuitPiece : exoSuitPieces) {
            List<ItemStack> upgradeItems = ExoSuitDamageHandler.getUpgradeItems(exoSuitPiece);
            ItemStack plating = ExoSuitDamageHandler.findUpgradeByType(upgradeItems, "plating");
            if (plating == null || !ExoSuitDamageHandler.isUpgradeFunctional(plating)) continue;
            ++functionalPlatingCount;
        }
        if (functionalPlatingCount > 0) {
            float baseReduction = damage * 0.15f;
            totalReduction = baseReduction * (float)Math.min(functionalPlatingCount, 4);
            if (functionalPlatingCount > 1) {
                totalReduction *= 0.8f + 0.2f / (float)functionalPlatingCount;
            }
        }
        return totalReduction;
    }

    private static List<ItemStack> getEquippedExoSuitPieces(Player player) {
        ArrayList<ItemStack> exoSuitPieces = new ArrayList<ItemStack>();
        for (ItemStack armorStack : player.m_6168_()) {
            if (!(armorStack.m_41720_() instanceof ExoSuitItem)) continue;
            exoSuitPieces.add(armorStack);
        }
        return exoSuitPieces;
    }

    private static float distributeDamageToComponents(ItemStack exoSuitPiece, float incomingDamage) {
        ExoSuitUpgrade upgradeData;
        float remainingDamage = incomingDamage;
        List<ItemStack> upgradeItems = ExoSuitDamageHandler.getUpgradeItems(exoSuitPiece);
        if (upgradeItems.isEmpty()) {
            return remainingDamage;
        }
        boolean needsUpdate = false;
        ItemStack plating = ExoSuitDamageHandler.findUpgradeByType(upgradeItems, "plating");
        if (plating != null && !plating.m_41619_() && ExoSuitDamageHandler.isUpgradeDamageable(plating) && !ExoSuitDamageHandler.isUpgradeBroken(plating)) {
            float absorbedDamage = remainingDamage * 0.8f;
            ExoSuitDamageHandler.damageUpgradeItem(plating, (int)Math.ceil(absorbedDamage * 0.1f));
            remainingDamage -= absorbedDamage;
            if (ExoSuitDamageHandler.isUpgradeBroken(plating)) {
                needsUpdate = true;
            }
        }
        int nonPlatingComponents = 0;
        for (ItemStack upgrade : upgradeItems) {
            if (upgrade == plating || upgrade.m_41619_() || (upgradeData = ExoSuitUpgradeManager.getUpgradeForItem(upgrade)) == null || upgradeData.getType().equals("plating")) continue;
            ++nonPlatingComponents;
        }
        if (nonPlatingComponents > 0 && remainingDamage > 0.0f) {
            for (ItemStack upgrade : upgradeItems) {
                if (upgrade == plating || upgrade.m_41619_() || !(remainingDamage > 0.0f) || (upgradeData = ExoSuitUpgradeManager.getUpgradeForItem(upgrade)) == null || upgradeData.getType().equals("plating") || !ExoSuitDamageHandler.isUpgradeDamageable(upgrade) || ExoSuitDamageHandler.isUpgradeBroken(upgrade)) continue;
                float componentDamage = remainingDamage * 0.3f * (1.0f / (float)nonPlatingComponents);
                ExoSuitDamageHandler.damageUpgradeItem(upgrade, (int)Math.ceil(componentDamage * 0.05f));
                remainingDamage -= componentDamage;
                if (!ExoSuitDamageHandler.isUpgradeBroken(upgrade)) continue;
                needsUpdate = true;
            }
        }
        if (needsUpdate) {
            ExoSuitDamageHandler.removeBrokenComponents(exoSuitPiece);
        }
        return Math.max(0.0f, remainingDamage);
    }

    private static List<ItemStack> getUpgradeItems(ItemStack exoSuitPiece) {
        ArrayList<ItemStack> upgrades = new ArrayList<ItemStack>();
        for (int slot = 0; slot < 4; ++slot) {
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(exoSuitPiece, slot);
            if (upgradeItem.m_41619_()) continue;
            upgrades.add(upgradeItem);
        }
        return upgrades;
    }

    private static ItemStack findUpgradeByType(List<ItemStack> upgrades, String type) {
        for (ItemStack upgrade : upgrades) {
            ExoSuitUpgrade upgradeData = ExoSuitUpgradeManager.getUpgradeForItem(upgrade);
            if (upgradeData == null || !upgradeData.getType().equals(type)) continue;
            return upgrade;
        }
        return null;
    }

    private static void damageUpgradeItem(ItemStack upgradeItem, int damage) {
        if (!ExoSuitDamageHandler.isUpgradeDamageable(upgradeItem) || damage <= 0) {
            return;
        }
        Item item = upgradeItem.m_41720_();
        if (item instanceof DamageableUpgradeItem) {
            DamageableUpgradeItem damageableUpgrade = (DamageableUpgradeItem)item;
            damageableUpgrade.onUpgradeDamaged(upgradeItem, damage);
        } else if (upgradeItem.m_41763_()) {
            int newDamage = upgradeItem.m_41773_() + damage;
            int maxDamage = upgradeItem.m_41776_();
            upgradeItem.m_41721_(Math.min(newDamage, maxDamage));
            if (upgradeItem.m_41773_() < maxDamage || maxDamage > 0) {
                // empty if block
            }
        }
    }

    private static boolean isUpgradeFunctional(ItemStack upgradeItem) {
        return !upgradeItem.m_41619_() && !ExoSuitDamageHandler.isUpgradeBroken(upgradeItem);
    }

    private static boolean isUpgradeDamageable(ItemStack upgradeItem) {
        if (upgradeItem.m_41619_()) {
            return false;
        }
        if (upgradeItem.m_41720_() instanceof DamageableUpgradeItem) {
            return true;
        }
        if (upgradeItem.m_41763_()) {
            return true;
        }
        return upgradeItem.m_41776_() > 0;
    }

    private static boolean isUpgradeBroken(ItemStack upgradeItem) {
        if (!ExoSuitDamageHandler.isUpgradeDamageable(upgradeItem)) {
            return false;
        }
        Item item = upgradeItem.m_41720_();
        if (item instanceof DamageableUpgradeItem) {
            DamageableUpgradeItem damageableUpgrade = (DamageableUpgradeItem)item;
            return damageableUpgrade.isBroken(upgradeItem);
        }
        return upgradeItem.m_41773_() >= upgradeItem.m_41776_() && upgradeItem.m_41776_() > 0;
    }

    private static void removeBrokenComponents(ItemStack exoSuitPiece) {
        CompoundTag upgradeData = ExoSuitData.getUpgradeData(exoSuitPiece);
        if (!upgradeData.m_128441_("Upgrades")) {
            return;
        }
        ListTag upgradeList = upgradeData.m_128437_("Upgrades", 10);
        ListTag newUpgradeList = new ListTag();
        boolean removedAny = false;
        for (int i = 0; i < upgradeList.size(); ++i) {
            CompoundTag slotTag = upgradeList.m_128728_(i);
            if (slotTag.m_128441_("Item")) {
                ItemStack upgradeStack = ItemStack.m_41712_((CompoundTag)slotTag.m_128469_("Item"));
                if (!upgradeStack.m_41619_() && !ExoSuitDamageHandler.isUpgradeBroken(upgradeStack)) {
                    newUpgradeList.add((Object)slotTag);
                    continue;
                }
                if (upgradeStack.m_41619_()) continue;
                removedAny = true;
                continue;
            }
            newUpgradeList.add((Object)slotTag);
        }
        if (removedAny) {
            upgradeData.m_128365_("Upgrades", (Tag)newUpgradeList);
            ExoSuitData.setUpgradeData(exoSuitPiece, upgradeData);
        }
    }
}

