/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common.exosuit;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.common.exosuit.ExoSuitData;
import top.ribs.scguns.common.exosuit.ExoSuitPowerManager;
import top.ribs.scguns.common.exosuit.ExoSuitUpgrade;
import top.ribs.scguns.common.exosuit.ExoSuitUpgradeManager;
import top.ribs.scguns.item.animated.ExoSuitItem;
import top.ribs.scguns.item.exosuit.EnergyUpgradeItem;

@Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ExoSuitFallDamageHandler {
    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_9236_().f_46443_) {
            return;
        }
        float totalFallDamageReduction = ExoSuitFallDamageHandler.calculateTotalFallDamageReduction(player);
        if (totalFallDamageReduction > 0.0f) {
            float originalDamage = event.getDamageMultiplier();
            float reducedDamage = originalDamage * (1.0f - totalFallDamageReduction);
            reducedDamage = Math.max(0.0f, reducedDamage);
            event.setDamageMultiplier(reducedDamage);
        }
    }

    private static float calculateTotalFallDamageReduction(Player player) {
        float totalReduction = 0.0f;
        for (ItemStack armorStack : player.m_6168_()) {
            if (!(armorStack.m_41720_() instanceof ExoSuitItem)) continue;
            totalReduction += ExoSuitFallDamageHandler.getFallDamageReductionFromPiece(armorStack, player);
        }
        return Math.min(totalReduction, 1.0f);
    }

    private static float getFallDamageReductionFromPiece(ItemStack armorStack, Player player) {
        float totalReduction = 0.0f;
        for (int slot = 0; slot < 4; ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(armorStack, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null) continue;
            ExoSuitUpgrade.Effects effects = upgrade.getEffects();
            if (!ExoSuitFallDamageHandler.canUpgradeFunction(player, upgrade, upgradeItem)) continue;
            totalReduction += effects.getFallDamageReduction();
        }
        return totalReduction;
    }

    private static boolean canUpgradeFunction(Player player, ExoSuitUpgrade upgrade, ItemStack upgradeItem) {
        String upgradeType = upgrade.getType();
        Item item = upgradeItem.m_41720_();
        if (item instanceof EnergyUpgradeItem) {
            EnergyUpgradeItem energyUpgrade = (EnergyUpgradeItem)item;
            boolean powerEnabled = ExoSuitPowerManager.isPowerEnabled(player, upgradeType);
            if (!powerEnabled) {
                return false;
            }
            if (!energyUpgrade.canFunctionWithoutPower()) {
                return ExoSuitPowerManager.canUpgradeFunction(player, upgradeType);
            }
            return true;
        }
        return true;
    }
}

