/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common.exosuit;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.common.exosuit.ExoSuitData;
import top.ribs.scguns.common.exosuit.ExoSuitPowerManager;
import top.ribs.scguns.common.exosuit.ExoSuitUpgrade;
import top.ribs.scguns.common.exosuit.ExoSuitUpgradeManager;
import top.ribs.scguns.item.animated.ExoSuitItem;
import top.ribs.scguns.item.exosuit.TargetTrackerModuleItem;

@Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ExoSuitTargetTrackerHandler {
    private static final int REFRESH_INTERVAL = 50;
    private static final double DETECTION_RADIUS = 16.0;
    private static final int GLOW_DURATION = 120;
    private static final Map<UUID, Long> playerLastUpdate = new HashMap<UUID, Long>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        Player player = event.player;
        if (player.f_19797_ % 10 != 0) {
            return;
        }
        ExoSuitTargetTrackerHandler.handleTargetTracker(player);
    }

    private static void handleTargetTracker(Player player) {
        TargetTrackerModuleItem targetTrackerModule;
        Item item;
        boolean targetTrackerEnabled = ExoSuitPowerManager.isPowerEnabled(player, "hud");
        if (!targetTrackerEnabled) {
            ExoSuitTargetTrackerHandler.removeEntityHighlights(player);
            return;
        }
        if (!ExoSuitTargetTrackerHandler.hasTargetTrackerModule(player)) {
            ExoSuitTargetTrackerHandler.removeEntityHighlights(player);
            return;
        }
        if (!ExoSuitPowerManager.canConsumeEnergy(player, "hud", 50)) {
            return;
        }
        if (!ExoSuitPowerManager.canUpgradeFunction(player, "hud")) {
            ExoSuitTargetTrackerHandler.removeEntityHighlights(player);
            return;
        }
        ItemStack helmetUpgrade = ExoSuitTargetTrackerHandler.findTargetTrackerModule(player);
        if (!helmetUpgrade.m_41619_() && (item = helmetUpgrade.m_41720_()) instanceof TargetTrackerModuleItem && !(targetTrackerModule = (TargetTrackerModuleItem)item).canFunctionWithoutPower() && !ExoSuitPowerManager.consumeEnergyForUpgrade(player, "hud", helmetUpgrade)) {
            ExoSuitTargetTrackerHandler.removeEntityHighlights(player);
            return;
        }
        ExoSuitTargetTrackerHandler.highlightNearbyEntities(player);
        playerLastUpdate.put(player.m_20148_(), player.m_9236_().m_46467_());
    }

    private static void highlightNearbyEntities(Player player) {
        AABB detectionArea = new AABB(player.m_20185_() - 16.0, player.m_20186_() - 16.0, player.m_20189_() - 16.0, player.m_20185_() + 16.0, player.m_20186_() + 16.0, player.m_20189_() + 16.0);
        List nearbyEntities = player.m_9236_().m_6443_(LivingEntity.class, detectionArea, entity -> entity != player && entity.m_6084_() && !entity.m_20145_());
        for (LivingEntity entity2 : nearbyEntities) {
            if (!entity2.m_21023_(MobEffects.f_19619_)) {
                entity2.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 120, 0, false, false, false));
                continue;
            }
            MobEffectInstance currentGlow = entity2.m_21124_(MobEffects.f_19619_);
            if (currentGlow == null || currentGlow.m_19557_() >= 60) continue;
            entity2.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 120, 0, false, false, false));
        }
    }

    private static void removeEntityHighlights(Player player) {
        playerLastUpdate.remove(player.m_20148_());
    }

    public static boolean hasTargetTrackerModule(Player player) {
        return !ExoSuitTargetTrackerHandler.findTargetTrackerModule(player).m_41619_();
    }

    public static boolean isTargetTrackerActive(Player player) {
        return ExoSuitTargetTrackerHandler.hasTargetTrackerModule(player) && ExoSuitPowerManager.isPowerEnabled(player, "hud") && ExoSuitPowerManager.canUpgradeFunction(player, "hud");
    }

    private static ItemStack findTargetTrackerModule(Player player) {
        for (ItemStack armorStack : player.m_6168_()) {
            ExoSuitItem exosuit;
            Item item = armorStack.m_41720_();
            if (!(item instanceof ExoSuitItem) || (exosuit = (ExoSuitItem)item).m_266204_() != ArmorItem.Type.HELMET) continue;
            for (int slot = 0; slot < 4; ++slot) {
                ExoSuitUpgrade upgrade;
                ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(armorStack, slot);
                if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("hud") || !(upgradeItem.m_41720_() instanceof TargetTrackerModuleItem)) continue;
                return upgradeItem;
            }
        }
        return ItemStack.f_41583_;
    }

    public static void onPlayerLogout(Player player) {
        playerLastUpdate.remove(player.m_20148_());
    }

    public static void onPlayerDeath(Player player) {
        ExoSuitTargetTrackerHandler.removeEntityHighlights(player);
    }
}

