/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common.exosuit;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import top.ribs.scguns.common.exosuit.ExoSuitUpgrade;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageSyncUpgradeRegistry;

public class ExoSuitUpgradeManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static ExoSuitUpgradeManager instance;
    private static final Map<ResourceLocation, ExoSuitUpgrade> itemUpgrades;

    public ExoSuitUpgradeManager() {
        super(GSON, "upgrades");
        instance = this;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        itemUpgrades.clear();
        pObject.forEach((resourceLocation, jsonElement) -> {
            try {
                ExoSuitUpgrade upgrade;
                JsonObject jsonObject;
                ResourceLocation itemId;
                if (jsonElement.isJsonObject() && ForgeRegistries.ITEMS.containsKey(itemId = this.getItemIdFromJson(jsonObject = jsonElement.getAsJsonObject(), (ResourceLocation)resourceLocation)) && (upgrade = this.loadUpgradeFromJson(jsonObject)) != null) {
                    itemUpgrades.put(itemId, upgrade);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        System.out.println("ExoSuitUpgradeManager: Loaded " + itemUpgrades.size() + " upgrades");
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        Map<ResourceLocation, CompoundTag> upgradeData = ExoSuitUpgradeManager.serializeUpgrades();
        S2CMessageSyncUpgradeRegistry message = new S2CMessageSyncUpgradeRegistry(upgradeData);
        if (event.getPlayer() != null) {
            PacketHandler.getPlayChannel().sendToPlayer(() -> ((OnDatapackSyncEvent)event).getPlayer(), (IMessage)message);
        } else {
            for (ServerPlayer player : event.getPlayerList().m_11314_()) {
                PacketHandler.getPlayChannel().sendToPlayer(() -> player, (IMessage)message);
            }
        }
    }

    public static Map<ResourceLocation, CompoundTag> serializeUpgrades() {
        HashMap<ResourceLocation, CompoundTag> serialized = new HashMap<ResourceLocation, CompoundTag>();
        for (Map.Entry<ResourceLocation, ExoSuitUpgrade> entry : itemUpgrades.entrySet()) {
            serialized.put(entry.getKey(), entry.getValue().serializeNBT());
        }
        return serialized;
    }

    public static void deserializeUpgrades(Map<ResourceLocation, CompoundTag> upgradeData) {
        itemUpgrades.clear();
        for (Map.Entry<ResourceLocation, CompoundTag> entry : upgradeData.entrySet()) {
            ExoSuitUpgrade upgrade = new ExoSuitUpgrade();
            upgrade.deserializeNBT(entry.getValue());
            itemUpgrades.put(entry.getKey(), upgrade);
        }
        System.out.println("ExoSuitUpgradeManager: Synced " + itemUpgrades.size() + " upgrades from server");
    }

    private ResourceLocation getItemIdFromJson(JsonObject json, ResourceLocation fileLocation) {
        String[] parts;
        if (json.has("item")) {
            String itemStr = json.get("item").getAsString();
            return new ResourceLocation(itemStr);
        }
        String path = fileLocation.m_135815_();
        if (path.contains("/") && (parts = path.split("/")).length >= 2) {
            String namespace = parts[parts.length - 2];
            String itemName = parts[parts.length - 1];
            ResourceLocation result = new ResourceLocation(namespace, itemName);
            return result;
        }
        return new ResourceLocation(fileLocation.m_135827_(), fileLocation.m_135815_());
    }

    private ExoSuitUpgrade loadUpgradeFromJson(JsonObject json) {
        ExoSuitUpgrade upgrade = new ExoSuitUpgrade();
        try {
            if (json.has("type")) {
                upgrade.type = json.get("type").getAsString();
            }
            if (json.has("effects")) {
                JsonObject effects = json.getAsJsonObject("effects");
                ExoSuitUpgrade.Effects effectsData = upgrade.getEffects();
                if (effects.has("armorBonus")) {
                    effectsData.armorBonus = effects.get("armorBonus").getAsFloat();
                }
                if (effects.has("armorToughness")) {
                    effectsData.armorToughness = effects.get("armorToughness").getAsFloat();
                }
                if (effects.has("knockbackResistance")) {
                    effectsData.knockbackResistance = effects.get("knockbackResistance").getAsFloat();
                }
                if (effects.has("speedModifier")) {
                    effectsData.speedModifier = effects.get("speedModifier").getAsFloat();
                }
                if (effects.has("jumpBoost")) {
                    effectsData.jumpBoost = effects.get("jumpBoost").getAsFloat();
                }
                if (effects.has("fallDamageReduction")) {
                    effectsData.fallDamageReduction = effects.get("fallDamageReduction").getAsFloat();
                }
                if (effects.has("nightVision")) {
                    effectsData.nightVision = effects.get("nightVision").getAsBoolean();
                }
                if (effects.has("flight")) {
                    effectsData.flight = effects.get("flight").getAsBoolean();
                }
                if (effects.has("flightSpeed")) {
                    effectsData.flightSpeed = effects.get("flightSpeed").getAsFloat();
                }
                if (effects.has("energyUse")) {
                    effectsData.energyUse = effects.get("energyUse").getAsFloat();
                }
                if (effects.has("recoilAngleReduction")) {
                    effectsData.recoilAngleReduction = effects.get("recoilAngleReduction").getAsFloat();
                }
                if (effects.has("recoilKickReduction")) {
                    effectsData.recoilKickReduction = effects.get("recoilKickReduction").getAsFloat();
                }
                if (effects.has("spreadReduction")) {
                    effectsData.spreadReduction = effects.get("spreadReduction").getAsFloat();
                }
            }
            if (json.has("display")) {
                JsonObject display = json.getAsJsonObject("display");
                ExoSuitUpgrade.Display displayData = upgrade.getDisplay();
                if (display.has("model")) {
                    displayData.model = display.get("model").getAsString();
                }
                if (display.has("storageSize")) {
                    displayData.storageSize = display.get("storageSize").getAsInt();
                }
                if (display.has("gridWidth")) {
                    displayData.gridWidth = display.get("gridWidth").getAsInt();
                }
                if (display.has("gridHeight")) {
                    displayData.gridHeight = display.get("gridHeight").getAsInt();
                }
                if (display.has("containerType")) {
                    displayData.containerType = display.get("containerType").getAsString();
                }
            }
            return upgrade;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ExoSuitUpgrade getUpgradeForItem(Item item) {
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)item);
        return itemUpgrades.get(itemId);
    }

    public static ExoSuitUpgrade getUpgradeForItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        return ExoSuitUpgradeManager.getUpgradeForItem(stack.m_41720_());
    }

    public static ExoSuitUpgrade getUpgradeForItemInSlot(ItemStack stack, String slotType) {
        if (stack.m_41619_()) {
            return null;
        }
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        String slotSpecificKey = itemId.toString() + "_" + slotType;
        ResourceLocation slotSpecificId = new ResourceLocation(slotSpecificKey);
        ExoSuitUpgrade slotSpecific = itemUpgrades.get(slotSpecificId);
        if (slotSpecific != null) {
            return slotSpecific;
        }
        return itemUpgrades.get(itemId);
    }

    public static boolean isUpgradeItem(Item item) {
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)item);
        return itemUpgrades.containsKey(itemId);
    }

    public static boolean isUpgradeItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return ExoSuitUpgradeManager.isUpgradeItem(stack.m_41720_());
    }

    public static ExoSuitUpgradeManager getInstance() {
        return instance;
    }

    static {
        itemUpgrades = new HashMap<ResourceLocation, ExoSuitUpgrade>();
    }
}

