/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.compat;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import top.ribs.scguns.client.screen.PoweredMaceratorRecipe;
import top.ribs.scguns.init.ModBlocks;

public class PoweredMaceratorCategory
implements IRecipeCategory<PoweredMaceratorRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("scguns", "powered_macerating");
    public static final ResourceLocation TEXTURE = new ResourceLocation("scguns", "textures/gui/powered_macerator_gui.png");
    public static final RecipeType<PoweredMaceratorRecipe> POWERED_MACERATING_TYPE = new RecipeType(UID, PoweredMaceratorRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final int offsetX = 11;
    private final int offsetY = 16;

    public PoweredMaceratorCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 11, 16, 128, 54);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.POWERED_MACERATOR.get()));
    }

    public RecipeType<PoweredMaceratorRecipe> getRecipeType() {
        return POWERED_MACERATING_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"block.scguns.powered_macerator");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PoweredMaceratorRecipe recipe, IFocusGroup focuses) {
        int inputBaseX = 33;
        int inputBaseY = 11;
        int inputSpacing = 18;
        for (int i = 0; i < 4; ++i) {
            int row = i / 2;
            int col = i % 2;
            int x = inputBaseX + col * inputSpacing;
            int y = inputBaseY + row * inputSpacing;
            if (i >= recipe.m_7527_().size()) continue;
            builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients((Ingredient)recipe.m_7527_().get(i));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 103, inputBaseY).addItemStack(recipe.m_8043_(null));
    }

    public void draw(PoweredMaceratorRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        int processingTime = recipe.getProcessingTime();
        if (processingTime > 0) {
            int seconds = processingTime / 20;
            String processingTimeText = String.format("%ds", seconds);
            guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, processingTimeText, 81, 44, Color.gray.getRGB(), false);
        }
        this.drawEnergyBar(guiGraphics, recipe);
        if (this.isMouseOverEnergyBar(mouseX, mouseY, 3, 5, 7, 42)) {
            this.renderEnergyTooltip(guiGraphics, mouseX, mouseY, recipe.getEnergyUse());
        }
    }

    private void drawEnergyBar(GuiGraphics guiGraphics, PoweredMaceratorRecipe recipe) {
        int energyRequired = recipe.getEnergyUse();
        int maxEnergy = 10000;
        int barHeight = 42;
        int energyHeight = (int)((float)(energyRequired * barHeight) / (float)maxEnergy);
        int energyBarX = 3;
        int energyBarY = 5 + (barHeight - energyHeight);
        guiGraphics.m_280218_(TEXTURE, energyBarX, energyBarY, 176, 20 + (barHeight - energyHeight), 14, energyHeight);
    }

    private boolean isMouseOverEnergyBar(double mouseX, double mouseY, int x, int y, int width, int height) {
        return mouseX >= (double)x && mouseX <= (double)(x + width) && mouseY >= (double)y && mouseY <= (double)(y + height);
    }

    private void renderEnergyTooltip(GuiGraphics guiGraphics, double mouseX, double mouseY, int energyRequired) {
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        tooltip.add(Component.m_237110_((String)"tooltip.powered_macerator.energy", (Object[])new Object[]{energyRequired}));
        guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, tooltip, Optional.empty(), (int)mouseX, (int)mouseY);
    }
}

