/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.config;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ribs.scguns.util.GunCurseUtil;

@Mod.EventBusSubscriber(modid="scguns")
public class EntityEquipmentConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, EquipmentData> CONFIGS = new HashMap<String, EquipmentData>();

    public static void loadConfig(ResourceManager resourceManager, ResourceLocation configLocation) {
        block11: {
            try {
                Resource resource = resourceManager.m_213713_(configLocation).orElse(null);
                if (resource != null) {
                    try (InputStreamReader reader = new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8);){
                        Gson gson = new Gson();
                        JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                        if (!json.has("id")) {
                            LOGGER.warn("Equipment config missing 'id' field: {}", (Object)configLocation);
                            return;
                        }
                        String entityId = json.get("id").getAsString();
                        EquipmentData data = EntityEquipmentConfig.parseEquipmentData(json);
                        if (data != null) {
                            CONFIGS.put(entityId, data);
                            int totalEntries = data.entriesBySlot.values().stream().mapToInt(List::size).sum();
                            LOGGER.info("Loaded equipment config for {} from {}: {} entries across {} slots", (Object)entityId, (Object)configLocation, (Object)totalEntries, (Object)data.entriesBySlot.size());
                        }
                        break block11;
                    }
                }
                LOGGER.warn("Equipment config not found: {}", (Object)configLocation);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load equipment config: {}", (Object)configLocation, (Object)e);
            }
        }
    }

    private static EquipmentData parseEquipmentData(JsonObject json) {
        float equipmentChance = json.has("equipment_chance") ? json.get("equipment_chance").getAsFloat() : 0.75f;
        HashMap<EquipmentSlot, List<EquipmentEntry>> entriesBySlot = new HashMap<EquipmentSlot, List<EquipmentEntry>>();
        if (json.has("items")) {
            JsonArray itemsArray = json.getAsJsonArray("items");
            for (JsonElement element : itemsArray) {
                JsonObject itemObj = element.getAsJsonObject();
                EquipmentEntry entry = EntityEquipmentConfig.parseEntry(itemObj);
                if (entry == null) continue;
                entriesBySlot.computeIfAbsent(entry.slot, k -> new ArrayList()).add(entry);
            }
        }
        return new EquipmentData(equipmentChance, entriesBySlot);
    }

    @Nullable
    private static EquipmentEntry parseEntry(JsonObject json) {
        try {
            String itemId = json.get("item").getAsString();
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
            if (item == null) {
                LOGGER.warn("Unknown item: {}", (Object)itemId);
                return null;
            }
            float spawnWeight = json.has("weight") ? json.get("weight").getAsFloat() : 1.0f;
            float dropChance = json.has("drop_chance") ? json.get("drop_chance").getAsFloat() : 0.2f;
            EquipmentSlot slot = EquipmentSlot.MAINHAND;
            if (json.has("slot")) {
                String slotName;
                slot = switch (slotName = json.get("slot").getAsString().toLowerCase()) {
                    case "head", "helmet" -> EquipmentSlot.HEAD;
                    case "chest", "chestplate" -> EquipmentSlot.CHEST;
                    case "legs", "leggings" -> EquipmentSlot.LEGS;
                    case "feet", "boots" -> EquipmentSlot.FEET;
                    case "offhand" -> EquipmentSlot.OFFHAND;
                    default -> EquipmentSlot.MAINHAND;
                };
            }
            Float minDurability = json.has("min_durability") ? Float.valueOf(json.get("min_durability").getAsFloat()) : null;
            Float maxDurability = json.has("max_durability") ? Float.valueOf(json.get("max_durability").getAsFloat()) : null;
            return new EquipmentEntry(item, spawnWeight, dropChance, slot, minDurability, maxDurability);
        }
        catch (Exception e) {
            LOGGER.error("Error parsing equipment entry", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static EquipmentData getEquipmentData(String entityId) {
        return CONFIGS.get(entityId);
    }

    public static void equipEntity(Mob mob, String entityId) {
        EquipmentData data = EntityEquipmentConfig.getEquipmentData(entityId);
        if (data == null) {
            return;
        }
        if (mob.m_217043_().m_188501_() >= data.equipmentChance) {
            return;
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            EquipmentEntry entry = data.selectRandom(slot, mob.m_217043_());
            if (entry == null) continue;
            ItemStack stack = entry.createItemStack(mob.m_217043_());
            if (slot == EquipmentSlot.MAINHAND) {
                GunCurseUtil.applyCurseIfRoll(stack, mob.m_217043_());
            }
            mob.m_8061_(slot, stack);
            mob.m_21409_(slot, entry.dropChance);
        }
    }

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SimplePreparableReloadListener<Void>(){

            protected Void prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
                return null;
            }

            protected void apply(Void object, ResourceManager resourceManager, ProfilerFiller profiler) {
                CONFIGS.clear();
                EntityEquipmentConfig.loadAllConfigs(resourceManager);
            }
        });
    }

    private static void loadAllConfigs(ResourceManager resourceManager) {
        String namespace = "scguns";
        String folderPath = "entity/equipment";
        try {
            Map resources = resourceManager.m_214159_(folderPath, location -> location.m_135815_().endsWith(".json"));
            for (ResourceLocation location2 : resources.keySet()) {
                if (!location2.m_135827_().equals(namespace)) continue;
                EntityEquipmentConfig.loadConfig(resourceManager, location2);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to scan equipment configs directory", (Throwable)e);
        }
    }

    public record EquipmentData(float equipmentChance, Map<EquipmentSlot, List<EquipmentEntry>> entriesBySlot) {
        @Nullable
        public EquipmentEntry selectRandom(EquipmentSlot slot, RandomSource random) {
            List<EquipmentEntry> entries = this.entriesBySlot.get(slot);
            if (entries == null || entries.isEmpty()) {
                return null;
            }
            float totalWeight = 0.0f;
            for (EquipmentEntry entry : entries) {
                totalWeight += entry.spawnWeight;
            }
            float roll = random.m_188501_() * totalWeight;
            float currentWeight = 0.0f;
            for (EquipmentEntry entry : entries) {
                if (!(roll < (currentWeight += entry.spawnWeight))) continue;
                return entry;
            }
            return entries.get(entries.size() - 1);
        }
    }

    public record EquipmentEntry(Item item, float spawnWeight, float dropChance, EquipmentSlot slot, @Nullable Float minDurability, @Nullable Float maxDurability) {
        public ItemStack createItemStack(RandomSource random) {
            ItemStack stack = new ItemStack((ItemLike)this.item);
            if (stack.m_41763_() && this.minDurability != null && this.maxDurability != null) {
                float durabilityPercent = this.minDurability.floatValue() + random.m_188501_() * (this.maxDurability.floatValue() - this.minDurability.floatValue());
                int damage = (int)((float)stack.m_41776_() * (1.0f - durabilityPercent));
                stack.m_41721_(damage);
            }
            return stack;
        }
    }
}

