/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.entity.monster.AdjudicatorEntity;
import top.ribs.scguns.item.GunItem;

public class AdjudicatorModel<T extends AdjudicatorEntity>
extends HierarchicalModel<T>
implements ArmedModel {
    private final ModelPart root;
    private final ModelPart right_leg;
    private final ModelPart left_leg;
    private final ModelPart torso;
    private final ModelPart head;
    private final ModelPart nose;
    private final ModelPart left_ear;
    private final ModelPart right_ear;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final PartPose headDefault;
    private final PartPose noseDefault;
    private final PartPose leftArmDefault;
    private final PartPose rightArmDefault;
    private final PartPose leftLegDefault;
    private final PartPose rightLegDefault;
    private float attackStartTime = -1.0f;
    private int lastAttackTimeout = 0;
    private static final float ATTACK_DURATION = 12.0f;

    public AdjudicatorModel(ModelPart root) {
        this.root = root;
        this.right_leg = root.m_171324_("right_leg");
        this.left_leg = root.m_171324_("left_leg");
        this.torso = root.m_171324_("torso");
        this.head = root.m_171324_("head");
        this.nose = this.head.m_171324_("nose");
        this.left_ear = this.head.m_171324_("left_ear");
        this.right_ear = this.head.m_171324_("right_ear");
        this.left_arm = root.m_171324_("left_arm");
        this.right_arm = root.m_171324_("right_arm");
        this.headDefault = this.head.m_171308_();
        this.noseDefault = this.nose.m_171308_();
        this.leftArmDefault = this.left_arm.m_171308_();
        this.rightArmDefault = this.right_arm.m_171308_();
        this.leftLegDefault = this.left_leg.m_171308_();
        this.rightLegDefault = this.right_leg.m_171308_();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(20, 47).m_171480_().m_171488_(-2.9f, 4.2285f, -5.576f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.85f, (float)11.0f, (float)9.35f));
        PartDefinition right_leg_r1 = right_leg.m_171599_("right_leg_r1", CubeListBuilder.m_171558_().m_171514_(52, 44).m_171480_().m_171488_(-1.25f, -7.3896f, -2.9787f, 3.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-0.75f, (float)5.6396f, (float)-3.1213f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(20, 47).m_171488_(-1.1f, 4.2285f, -5.576f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.85f, (float)11.0f, (float)9.35f));
        PartDefinition left_leg_r1 = left_leg.m_171599_("left_leg_r1", CubeListBuilder.m_171558_().m_171514_(52, 44).m_171488_(-1.75f, -7.3896f, -2.9787f, 3.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.75f, (float)5.6396f, (float)-3.1213f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition torso = partdefinition.m_171599_("torso", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.6332f, (float)7.2892f, (float)4.2402f));
        PartDefinition body_r1 = torso.m_171599_("body_r1", CubeListBuilder.m_171558_().m_171514_(30, 60).m_171488_(-4.0f, -0.0192f, 0.3659f, 8.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)3.25f, (float)1.7802f, (float)-1.2828f, (float)-1.5708f));
        PartDefinition body_r2 = torso.m_171599_("body_r2", CubeListBuilder.m_171558_().m_171514_(14, 60).m_171488_(-4.0f, -0.0192f, 0.3659f, 8.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)7.2663f, (float)2.0f, (float)3.25f, (float)1.8588f, (float)1.2828f, (float)1.5708f));
        PartDefinition body_r3 = torso.m_171599_("body_r3", CubeListBuilder.m_171558_().m_171514_(54, 25).m_171488_(-4.0f, -0.0192f, 0.3659f, 8.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.6332f, (float)0.9681f, (float)6.7335f, (float)0.288f, (float)0.0f, (float)0.0f));
        PartDefinition body_r4 = torso.m_171599_("body_r4", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-3.5f, -4.0f, -2.0f, 8.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.1332f, (float)3.0711f, (float)2.5543f, (float)1.0734f, (float)0.0f, (float)0.0f));
        PartDefinition body_r5 = torso.m_171599_("body_r5", CubeListBuilder.m_171558_().m_171514_(33, 14).m_171488_(-3.5f, -10.75f, -1.5f, 8.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.1332f, (float)-1.9289f, (float)5.5543f, (float)1.3788f, (float)0.0f, (float)0.0f));
        PartDefinition body_r6 = torso.m_171599_("body_r6", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.5f, -11.25f, -1.5f, 9.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.6332f, (float)3.0711f, (float)2.5543f, (float)1.3788f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)8.0456f, (float)-4.0525f, (float)-0.3403f, (float)0.0f, (float)0.0f));
        PartDefinition head_r1 = head.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -1.5f, -3.5f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(74, 63).m_171488_(-4.0f, -1.5f, -3.5f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.m_171423_((float)0.0f, (float)-5.59f, (float)-3.5625f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-0.025f, (float)-0.301f, (float)-4.1306f, (float)0.2094f, (float)0.0f, (float)0.0f));
        PartDefinition head_r2 = nose.m_171599_("head_r2", CubeListBuilder.m_171558_().m_171514_(0, 67).m_171488_(-1.025f, -1.8907f, -7.2403f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(26, 67).m_171488_(-1.025f, -1.8907f, -2.2403f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)3.25f, (float)-0.75f, (float)1.309f, (float)0.0f, (float)0.0f));
        PartDefinition head_r3 = nose.m_171599_("head_r3", CubeListBuilder.m_171558_().m_171514_(72, 7).m_171488_(-0.975f, -2.8029f, 1.8261f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)3.25f, (float)-0.75f, (float)0.9163f, (float)0.0f, (float)0.0f));
        PartDefinition left_ear = head.m_171599_("left_ear", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)5.4413f, (float)-5.071f, (float)1.2706f));
        PartDefinition ear_r1 = left_ear.m_171599_("ear_r1", CubeListBuilder.m_171558_().m_171514_(0, 57).m_171488_(0.0f, -1.5f, -4.0f, 0.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5934f, (float)0.3378f, (float)0.2042f));
        PartDefinition right_ear = head.m_171599_("right_ear", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-5.4413f, (float)-5.071f, (float)1.2706f));
        PartDefinition ear_r2 = right_ear.m_171599_("ear_r2", CubeListBuilder.m_171558_().m_171514_(58, 13).m_171488_(0.0f, -1.5f, -4.0f, 0.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5934f, (float)-0.3378f, (float)-0.2042f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)4.5f, (float)7.0f, (float)-0.75f, (float)0.1833f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = left_arm.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(0.4f, 0.55f, -1.6f, 0.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.75f, (float)2.3097f, (float)-0.9567f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = left_arm.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-0.5f, -0.25f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.75f, (float)2.3097f, (float)-0.9567f, (float)-1.1781f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm_r1 = left_arm.m_171599_("left_arm_r1", CubeListBuilder.m_171558_().m_171514_(66, 49).m_171488_(-2.0f, -1.5f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)-0.3496f, (float)-0.438f, (float)-0.3655f, (float)0.147f, (float)0.3655f));
        PartDefinition left_arm_r2 = left_arm.m_171599_("left_arm_r2", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, 4.75f, -0.95f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-1.0f, 3.75f, 1.05f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(66, 63).m_171488_(-0.5f, 1.75f, -0.75f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(14, 67).m_171488_(-1.0f, -4.25f, -1.25f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)3.2503f, (float)-2.1997f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-4.25f, (float)7.0f, (float)-1.6f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm_r1 = right_arm.m_171599_("right_arm_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-2.0f, 3.75f, 1.05f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(24, 0).m_171480_().m_171488_(-2.0f, 4.75f, -0.95f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(66, 63).m_171480_().m_171488_(-1.5f, 1.75f, -0.75f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.25f, (float)3.0306f, (float)-1.4008f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm_r2 = right_arm.m_171599_("right_arm_r2", CubeListBuilder.m_171558_().m_171514_(66, 56).m_171488_(-2.0f, -1.5f, -2.2f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.25f, (float)-0.5692f, (float)0.3609f, (float)-0.3655f, (float)-0.147f, (float)-0.3655f));
        PartDefinition right_arm_r3 = right_arm.m_171599_("right_arm_r3", CubeListBuilder.m_171558_().m_171514_(60, 0).m_171488_(-2.0f, -3.25f, -0.95f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.25f, (float)1.7806f, (float)-1.4008f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.m_171322_(this.headDefault);
        this.nose.m_171322_(this.noseDefault);
        this.left_arm.m_171322_(this.leftArmDefault);
        this.right_arm.m_171322_(this.rightArmDefault);
        this.left_leg.m_171322_(this.leftLegDefault);
        this.right_leg.m_171322_(this.rightLegDefault);
        boolean holdingItem = !entity.m_21205_().m_41619_();
        boolean holdingGun = entity.m_21205_().m_41720_() instanceof GunItem;
        float legSwing = Mth.m_14089_((float)(limbSwing * 0.4f)) * 1.0f * limbSwingAmount;
        float armSwing = Mth.m_14089_((float)(limbSwing * 0.4f + (float)Math.PI)) * 1.0f * limbSwingAmount;
        this.right_leg.f_104203_ += legSwing;
        this.left_leg.f_104203_ -= legSwing;
        if (!holdingItem) {
            this.right_arm.f_104203_ += armSwing;
            this.left_arm.f_104203_ -= armSwing;
        } else if (!holdingGun) {
            if (((AdjudicatorEntity)((Object)entity)).isAttacking() && ((AdjudicatorEntity)((Object)entity)).getAttackTimeout() > 0) {
                this.animateAttackSmooth(((AdjudicatorEntity)((Object)entity)).getAttackTimeout(), ageInTicks);
            }
            this.left_arm.f_104203_ -= armSwing;
        }
        float earTime = ageInTicks * 0.08f + limbSwing * 0.4f;
        float earAmount = 0.06f + limbSwingAmount * 0.3f;
        this.left_ear.f_104205_ = Mth.m_14089_((float)(earTime * 1.1f)) * earAmount;
        this.right_ear.f_104205_ = -Mth.m_14089_((float)earTime) * earAmount;
        float breathe = Mth.m_14031_((float)(ageInTicks * 0.12f)) * 0.04f;
        this.nose.f_104203_ += breathe;
        float clampedYaw = Mth.m_14036_((float)netHeadYaw, (float)-60.0f, (float)60.0f);
        float clampedPitch = Mth.m_14036_((float)headPitch, (float)-25.0f, (float)25.0f);
        this.head.f_104204_ += clampedYaw * ((float)Math.PI / 180);
        this.head.f_104203_ += clampedPitch * ((float)Math.PI / 180) * 0.5f;
        if (holdingGun) {
            this.right_arm.f_104203_ = -1.1781f;
            this.right_arm.f_104204_ = 0.0f;
            this.right_arm.f_104205_ = 0.0f;
        }
    }

    private void animateAttackSmooth(int attackTimeout, float ageInTicks) {
        if (attackTimeout <= 0) {
            this.right_arm.f_104203_ = 0.0f;
            this.right_arm.f_104204_ = 0.0f;
            this.attackStartTime = -1.0f;
            this.lastAttackTimeout = 0;
            return;
        }
        if (attackTimeout > this.lastAttackTimeout || this.attackStartTime < 0.0f) {
            this.attackStartTime = ageInTicks;
        }
        this.lastAttackTimeout = attackTimeout;
        float elapsedTime = ageInTicks - this.attackStartTime;
        float attackProgress = elapsedTime / 12.0f;
        attackProgress = Mth.m_14036_((float)attackProgress, (float)0.0f, (float)1.0f);
        float swingCurve = Mth.m_14031_((float)(attackProgress * (float)Math.PI));
        this.right_arm.f_104203_ = -swingCurve * 1.7f;
        this.right_arm.f_104204_ = 0.0f;
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.right_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.torso.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_arm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.right_arm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void m_6002_(HumanoidArm pSide, PoseStack pPoseStack) {
        if (pSide == HumanoidArm.RIGHT) {
            this.right_arm.m_104299_(pPoseStack);
            pPoseStack.m_252781_(Axis.f_252529_.m_252961_(-0.3927f));
            pPoseStack.m_85837_(-0.05, 0.55, 0.05);
            pPoseStack.m_85841_(0.8f, 0.8f, 0.8f);
        }
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

