/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.entity.monster.BlundererEntity;
import top.ribs.scguns.item.GunItem;

public class BlundererModel<T extends BlundererEntity>
extends HierarchicalModel<T>
implements ArmedModel,
HeadedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart torso;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart left_leg;
    private final ModelPart right_leg;
    private final PartPose headDefault;
    private final PartPose torsoDefault;
    private final PartPose leftArmDefault;
    private final PartPose rightArmDefault;
    private final PartPose leftLegDefault;
    private final PartPose rightLegDefault;

    public BlundererModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.torso = root.m_171324_("torso");
        this.left_arm = root.m_171324_("left_arm");
        this.right_arm = root.m_171324_("right_arm");
        this.left_leg = root.m_171324_("left_leg");
        this.right_leg = root.m_171324_("right_leg");
        this.headDefault = this.head.m_171308_();
        this.torsoDefault = this.torso.m_171308_();
        this.leftArmDefault = this.left_arm.m_171308_();
        this.rightArmDefault = this.right_arm.m_171308_();
        this.leftLegDefault = this.left_leg.m_171308_();
        this.rightLegDefault = this.right_leg.m_171308_();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.2071f, (float)-8.25f, (float)-2.0f));
        PartDefinition cube_r1 = head.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 80).m_171488_(-4.0f, -8.5f, -3.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.275f)).m_171514_(36, 82).m_171488_(-4.0f, -8.5f, -3.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.2071f, (float)-2.25f, (float)-0.25f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = head.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(68, 40).m_171488_(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.2071f, (float)-4.75f, (float)2.75f, (float)-1.5708f, (float)0.7854f, (float)-1.5708f));
        PartDefinition cube_r3 = head.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(44, 63).m_171488_(-1.0f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.2071f, (float)-5.45f, (float)2.75f, (float)-1.5708f, (float)0.7854f, (float)-1.5708f));
        PartDefinition cube_r4 = head.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(40, 63).m_171488_(0.0f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.7929f, (float)-5.45f, (float)2.75f, (float)-1.5708f, (float)-0.7854f, (float)1.5708f));
        PartDefinition cube_r5 = head.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(62, 40).m_171488_(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.7929f, (float)-4.75f, (float)2.75f, (float)-1.5708f, (float)-0.7854f, (float)1.5708f));
        PartDefinition cube_r6 = head.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(104, 8).m_171488_(-1.0f, -0.5f, -4.0f, 6.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.7929f, (float)-5.25f, (float)0.75f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition cube_r7 = head.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(80, 65).m_171488_(-5.0f, -1.5f, -4.0f, 10.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.7929f, (float)-2.25f, (float)0.75f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition torso = partdefinition.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(58, 43).m_171488_(-8.0f, -19.0f, -5.5f, 15.0f, 11.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(104, 0).m_171488_(-7.5f, -21.2855f, 0.0f, 14.0f, 3.0f, 5.0f, new CubeDeformation(0.025f)).m_171514_(0, 24).m_171488_(-8.0f, -6.0f, -10.5f, 15.0f, 3.0f, 16.0f, new CubeDeformation(0.25f)).m_171514_(0, 43).m_171488_(-7.5f, -8.0f, -10.0f, 14.0f, 5.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-8.0f, -8.0f, -10.5f, 15.0f, 8.0f, 16.0f, new CubeDeformation(0.0f)).m_171514_(43, 43).m_171488_(-4.0f, -8.0f, 5.5f, 7.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 5).m_171488_(-4.0f, -7.0f, 7.5f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(62, 21).m_171488_(-3.0f, 0.0f, -10.5f, 5.0f, 4.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(76, 100).m_171488_(-8.0f, 0.0f, 1.5f, 15.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(62, 0).m_171480_().m_171488_(-0.1f, 0.0f, -9.5f, 7.0f, 7.0f, 14.0f, new CubeDeformation(0.025f)).m_171555_(false).m_171514_(62, 0).m_171488_(-7.9f, 0.0f, -9.5f, 7.0f, 7.0f, 14.0f, new CubeDeformation(0.025f)), PartPose.m_171419_((float)0.5f, (float)10.0f, (float)-1.5f));
        PartDefinition cube_r8 = torso.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(38, 100).m_171488_(-7.0f, -2.5f, -2.5f, 14.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-17.0f, (float)5.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r9 = torso.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(0, 100).m_171488_(-7.0f, -2.5f, -2.5f, 14.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-17.75f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r10 = torso.m_171599_("cube_r10", CubeListBuilder.m_171558_().m_171514_(40, 65).m_171488_(-8.5f, -7.0f, -6.0f, 15.0f, 12.0f, 5.0f, new CubeDeformation(-0.025f)), PartPose.m_171423_((float)0.5f, (float)-10.1637f, (float)6.8133f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r11 = torso.m_171599_("cube_r11", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171480_().m_171488_(1.625f, 3.5f, -6.125f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 7).m_171480_().m_171488_(1.625f, 2.5f, -6.875f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.375f, (float)-9.5711f, (float)-10.1091f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition cube_r12 = torso.m_171599_("cube_r12", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171488_(-6.875f, 2.5f, -6.875f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 28).m_171488_(-6.875f, 3.5f, -6.125f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.375f, (float)-9.5711f, (float)-10.1091f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition cube_r13 = torso.m_171599_("cube_r13", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(1.3155f, -1.9116f, 1.6112f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 43).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(8, 32).m_171488_(-3.3155f, -2.0884f, -3.6112f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.9461f, (float)-15.377f, (float)-7.5209f, (float)-0.421f, (float)0.6473f, (float)-0.7081f));
        PartDefinition cube_r14 = torso.m_171599_("cube_r14", CubeListBuilder.m_171558_().m_171514_(22, 110).m_171488_(-0.8f, -1.0f, -7.0f, 1.0f, 2.0f, 14.0f, new CubeDeformation(0.2f)), PartPose.m_171423_((float)7.2863f, (float)-16.2995f, (float)0.9311f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r15 = torso.m_171599_("cube_r15", CubeListBuilder.m_171558_().m_171514_(102, 31).m_171488_(-7.5f, -5.0f, -6.0f, 16.0f, 2.0f, 14.0f, new CubeDeformation(0.225f)), PartPose.m_171423_((float)0.5f, (float)-10.2694f, (float)-2.649f, (float)-0.3655f, (float)-0.147f, (float)-0.3655f));
        PartDefinition cube_r16 = torso.m_171599_("cube_r16", CubeListBuilder.m_171558_().m_171514_(0, 63).m_171488_(-8.5f, -7.0f, -6.0f, 15.0f, 12.0f, 5.0f, new CubeDeformation(-0.025f)), PartPose.m_171423_((float)0.5f, (float)-10.2694f, (float)-2.649f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(76, 109).m_171488_(-5.2807f, 7.7955f, -3.0f, 5.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(98, 109).m_171488_(-5.2807f, 0.1955f, -3.0f, 5.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(108, 78).m_171488_(-7.5307f, 6.1955f, -4.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-7.25f, (float)-9.0f, (float)-1.5f));
        PartDefinition cube_r17 = left_arm.m_171599_("cube_r17", CubeListBuilder.m_171558_().m_171514_(0, 110).m_171488_(-2.5307f, -7.3045f, -4.0f, 5.0f, 6.0f, 6.0f, new CubeDeformation(-0.025f)), PartPose.m_171423_((float)-2.6864f, (float)14.3849f, (float)0.9815f, (float)-0.0013f, (float)0.0036f, (float)-0.3055f));
        PartDefinition cube_r18 = left_arm.m_171599_("cube_r18", CubeListBuilder.m_171558_().m_171514_(102, 21).m_171488_(-5.0f, 0.75f, -4.5f, 9.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(108, 88).m_171488_(-4.0f, -3.25f, -3.5f, 8.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(76, 109).m_171480_().m_171488_(0.2807f, 7.7955f, -3.0f, 5.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(98, 109).m_171480_().m_171488_(0.2807f, 0.1955f, -3.0f, 5.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(108, 78).m_171480_().m_171488_(-0.4693f, 6.1955f, -4.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)7.25f, (float)-9.0f, (float)-1.5f));
        PartDefinition cube_r19 = right_arm.m_171599_("cube_r19", CubeListBuilder.m_171558_().m_171514_(0, 110).m_171480_().m_171488_(-2.4693f, -7.3045f, -4.0f, 5.0f, 6.0f, 6.0f, new CubeDeformation(-0.025f)).m_171555_(false), PartPose.m_171423_((float)2.6864f, (float)14.3849f, (float)0.9815f, (float)-0.0013f, (float)-0.0036f, (float)0.3055f));
        PartDefinition cube_r20 = right_arm.m_171599_("cube_r20", CubeListBuilder.m_171558_().m_171514_(102, 21).m_171480_().m_171488_(-4.0f, 0.75f, -4.5f, 9.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(108, 88).m_171480_().m_171488_(-4.0f, -3.25f, -3.5f, 8.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)3.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(80, 78).m_171488_(-3.0333f, 0.0f, -2.3333f, 6.0f, 14.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-2.5333f, 5.5f, -3.3333f, 5.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.9667f, (float)10.0f, (float)-5.1667f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(80, 78).m_171480_().m_171488_(-2.9667f, 0.0f, -2.3333f, 6.0f, 14.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 0).m_171480_().m_171488_(-2.4667f, 5.5f, -3.3333f, 5.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)3.9667f, (float)10.0f, (float)-5.1667f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.m_171322_(this.headDefault);
        this.torso.m_171322_(this.torsoDefault);
        this.left_arm.m_171322_(this.leftArmDefault);
        this.right_arm.m_171322_(this.rightArmDefault);
        this.left_leg.m_171322_(this.leftLegDefault);
        this.right_leg.m_171322_(this.rightLegDefault);
        boolean holdingItem = !entity.m_21205_().m_41619_();
        boolean holdingGun = entity.m_21205_().m_41720_() instanceof GunItem;
        float legSwing = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float armSwing = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.0f * limbSwingAmount;
        this.right_leg.f_104203_ += legSwing;
        this.left_leg.f_104203_ -= legSwing;
        float clampedYaw = Mth.m_14036_((float)netHeadYaw, (float)-60.0f, (float)60.0f);
        float clampedPitch = Mth.m_14036_((float)headPitch, (float)-45.0f, (float)45.0f);
        if (((BlundererEntity)((Object)entity)).isTossingGrenade()) {
            int tossTimeout = ((BlundererEntity)((Object)entity)).getGrenadeTossTimeout();
            if (tossTimeout > 6) {
                float windUp = (float)(12 - tossTimeout) / 6.0f;
                this.right_arm.f_104203_ = -2.8f + windUp * 0.3f;
                this.right_arm.f_104205_ = 0.5f;
            } else {
                float throwMotion = (float)(6 - tossTimeout) / 6.0f;
                float curve = Mth.m_14031_((float)(throwMotion * (float)Math.PI));
                this.right_arm.f_104203_ = -2.8f + curve * 3.5f;
                this.right_arm.f_104205_ = 0.5f - throwMotion * 0.3f;
            }
            this.torso.f_104204_ = -0.2f;
            this.left_arm.f_104203_ = -0.5f;
            this.left_arm.f_104205_ = -0.2f;
        } else if (((BlundererEntity)((Object)entity)).isCharging()) {
            float fastLegSwing;
            float chargeIntensity = Mth.m_14031_((float)(ageInTicks * 0.8f)) * 0.15f;
            this.torso.f_104203_ = -0.4f + chargeIntensity;
            this.left_arm.f_104203_ = -1.2f + chargeIntensity;
            this.left_arm.f_104205_ = -0.3f;
            this.right_arm.f_104203_ = -1.2f + chargeIntensity;
            this.right_arm.f_104205_ = 0.3f;
            this.right_leg.f_104203_ = fastLegSwing = Mth.m_14089_((float)(limbSwing * 1.2f)) * 2.0f * limbSwingAmount;
            this.left_leg.f_104203_ = -fastLegSwing;
            this.head.f_104203_ = -0.2f;
        } else if (!holdingItem) {
            this.right_arm.f_104203_ += armSwing;
            this.left_arm.f_104203_ -= armSwing;
        } else if (!holdingGun) {
            if (((BlundererEntity)((Object)entity)).isAttacking()) {
                this.animateAttackSmooth(ageInTicks);
            } else {
                this.left_arm.f_104203_ -= armSwing;
            }
            this.right_arm.f_104203_ += armSwing;
        } else {
            float aimPitchRadians = clampedPitch * ((float)Math.PI / 180);
            this.left_arm.f_104203_ = -1.5708f + aimPitchRadians;
            this.left_arm.f_104204_ = 0.0f;
            this.left_arm.f_104205_ = 0.0f;
            this.right_arm.f_104203_ = armSwing;
            this.torso.f_104203_ += aimPitchRadians * 0.4f;
        }
        this.head.f_104204_ += clampedYaw * ((float)Math.PI / 180);
        this.head.f_104203_ += clampedPitch * ((float)Math.PI / 180) * 0.5f;
        float breathe = Mth.m_14031_((float)(ageInTicks * 0.08f)) * 0.03f;
        this.torso.f_104201_ += breathe;
    }

    private void animateAttackSmooth(float ageInTicks) {
        float attackProgress = ageInTicks % 20.0f / 20.0f;
        float swingCurve = Mth.m_14031_((float)(attackProgress * (float)Math.PI));
        this.left_arm.f_104203_ = -swingCurve * 2.0f;
        this.left_arm.f_104204_ = 0.0f;
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.torso.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_arm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.right_arm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.right_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void m_6002_(HumanoidArm pSide, PoseStack pPoseStack) {
        if (pSide == HumanoidArm.LEFT) {
            this.left_arm.m_104299_(pPoseStack);
            pPoseStack.m_85837_(-0.2, 0.25, -0.05);
            pPoseStack.m_85841_(1.1f, 1.1f, 1.1f);
        }
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

