/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.entity.monster.PraetorEntity;

public class PraetorModel<T extends Entity>
extends EntityModel<T> {
    private final ModelPart head;
    private final ModelPart mask;
    private final ModelPart torso;
    private final ModelPart left_leg;
    private final ModelPart right_leg;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final PartPose headDefault;
    private final PartPose torsoDefault;
    private final PartPose leftArmDefault;
    private final PartPose rightArmDefault;
    private final PartPose leftLegDefault;
    private final PartPose rightLegDefault;
    private float attackStartTime = -1.0f;
    private int lastAttackTimeout = 0;
    private static final float ATTACK_DURATION = 8.0f;
    private float roarStartTime = -1.0f;
    private int lastRoarTick = 0;
    private static final float ROAR_DURATION = 40.0f;

    public PraetorModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.mask = this.head.m_171324_("mask");
        this.torso = root.m_171324_("torso");
        this.left_leg = root.m_171324_("left_leg");
        this.right_leg = root.m_171324_("right_leg");
        this.left_arm = root.m_171324_("left_arm");
        this.right_arm = root.m_171324_("right_arm");
        this.headDefault = this.head.m_171308_();
        this.torsoDefault = this.torso.m_171308_();
        this.leftArmDefault = this.left_arm.m_171308_();
        this.rightArmDefault = this.right_arm.m_171308_();
        this.leftLegDefault = this.left_leg.m_171308_();
        this.rightLegDefault = this.right_leg.m_171308_();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-9.25f, (float)-0.75f));
        PartDefinition cube_r1 = head.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(56, 99).m_171488_(-5.0f, 4.0f, 0.0f, 9.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(104, 109).m_171488_(-6.0f, -4.0f, -3.0f, 11.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)-4.85f, (float)-4.85f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition mask = head.m_171599_("mask", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-9.7431f, (float)-4.2957f));
        PartDefinition cube_r2 = mask.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(66, 15).m_171488_(-4.5f, -0.5f, -8.0f, 9.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(26, 79).m_171488_(-5.5f, 0.5f, -2.0f, 11.0f, 8.0f, 1.0f, new CubeDeformation(0.25f)).m_171514_(0, 0).m_171488_(-1.0f, -1.5f, -5.0f, 2.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(51, 26).m_171488_(-4.5f, -1.5f, 0.0f, 9.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)3.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition torso = partdefinition.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(0, 60).m_171488_(-8.0f, -10.0f, 2.0f, 16.0f, 8.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(62, 43).m_171488_(-11.0f, -6.0f, 4.0f, 21.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-9.0f, -2.0f, 1.0f, 18.0f, 10.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(92, 81).m_171488_(-9.0f, -2.0f, -1.0f, 18.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 43).m_171488_(-9.0f, 8.0f, 1.0f, 18.0f, 4.0f, 13.0f, new CubeDeformation(0.0f)).m_171514_(0, 25).m_171488_(-9.0f, 12.0f, -1.0f, 18.0f, 3.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(66, 33).m_171488_(-9.0f, 7.0f, -4.0f, 18.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)-3.0f));
        PartDefinition cube_r3 = torso.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(80, 90).m_171488_(-10.0f, -6.0f, 0.5f, 18.0f, 6.0f, 3.0f, new CubeDeformation(-0.025f)), PartPose.m_171423_((float)1.0f, (float)12.2039f, (float)10.4703f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = torso.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(92, 54).m_171488_(-8.0f, -2.0f, 0.5f, 16.0f, 8.0f, 3.0f, new CubeDeformation(-0.025f)), PartPose.m_171423_((float)0.0f, (float)-6.2039f, (float)10.4703f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r5 = torso.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(36, 90).m_171488_(-9.5f, -4.5f, -3.0f, 18.0f, 4.0f, 4.0f, new CubeDeformation(-0.025f)), PartPose.m_171423_((float)0.5f, (float)13.0607f, (float)1.3033f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r6 = torso.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(66, 0).m_171488_(-8.5f, -3.0f, -1.5f, 18.0f, 9.0f, 6.0f, new CubeDeformation(-0.025f)), PartPose.m_171423_((float)-0.5f, (float)2.0307f, (float)-0.3181f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r7 = torso.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(28, 98).m_171488_(-4.5f, -3.0f, -0.5f, 11.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.8284f, (float)-3.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition cube_r8 = torso.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(106, 15).m_171488_(-3.5f, -2.0f, -3.0f, 8.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)7.5f, (float)0.0f, (float)7.5f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition cube_r9 = torso.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(86, 99).m_171488_(-4.5f, -2.0f, -3.0f, 8.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-7.5f, (float)0.0f, (float)7.5f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(54, 60).m_171488_(-4.0f, -1.0f, -7.0f, 7.0f, 18.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)7.0f, (float)4.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(54, 60).m_171480_().m_171488_(-3.0f, -1.0f, -7.0f, 7.0f, 18.0f, 12.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)4.0f, (float)7.0f, (float)4.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-10.5f, (float)-10.5f, (float)5.0f));
        PartDefinition cube_r10 = left_arm.m_171599_("cube_r10", CubeListBuilder.m_171558_().m_171514_(92, 65).m_171488_(-6.5005f, -3.2594f, -5.0f, 7.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(88, 109).m_171488_(-5.5005f, 21.7406f, 0.0f, 8.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(72, 109).m_171488_(-5.5005f, 19.7406f, -4.0f, 8.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(56, 109).m_171488_(-5.5005f, 19.7406f, 4.0f, 8.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(0, 79).m_171488_(-6.5005f, 12.7406f, -5.0f, 8.0f, 9.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(0, 98).m_171488_(-5.5005f, 3.7406f, -4.0f, 6.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.75f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r11 = left_arm.m_171599_("cube_r11", CubeListBuilder.m_171558_().m_171514_(51, 29).m_171488_(17.5894f, 3.7635f, 2.0f, 8.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.75f, (float)-0.5f, (float)0.0f, (float)-3.1416f, (float)0.0f, (float)1.8413f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(5.25f, -0.25f, -0.75f, 0.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)10.5f, (float)-10.5f, (float)5.0f));
        PartDefinition cube_r12 = right_arm.m_171599_("cube_r12", CubeListBuilder.m_171558_().m_171514_(6, 5).m_171488_(-1.25f, -2.0f, -1.0f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.0f, (float)-1.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r13 = right_arm.m_171599_("cube_r13", CubeListBuilder.m_171558_().m_171514_(92, 65).m_171480_().m_171488_(-0.4995f, -3.2594f, -5.0f, 7.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(88, 109).m_171480_().m_171488_(-2.4995f, 21.7406f, 0.0f, 8.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(72, 109).m_171480_().m_171488_(-2.4995f, 19.7406f, -4.0f, 8.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(56, 109).m_171480_().m_171488_(-2.4995f, 19.7406f, 4.0f, 8.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 79).m_171480_().m_171488_(-1.4995f, 12.7406f, -5.0f, 8.0f, 9.0f, 10.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 98).m_171480_().m_171488_(-0.4995f, 3.7406f, -4.0f, 6.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.75f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r14 = right_arm.m_171599_("cube_r14", CubeListBuilder.m_171558_().m_171514_(51, 29).m_171480_().m_171488_(-25.5894f, 3.7635f, 2.0f, 8.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.75f, (float)-0.5f, (float)0.0f, (float)-3.1416f, (float)0.0f, (float)-1.8413f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void m_6973_(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.m_171322_(this.headDefault);
        this.torso.m_171322_(this.torsoDefault);
        this.left_arm.m_171322_(this.leftArmDefault);
        this.right_arm.m_171322_(this.rightArmDefault);
        this.left_leg.m_171322_(this.leftLegDefault);
        this.right_leg.m_171322_(this.rightLegDefault);
        float breathe = Mth.m_14031_((float)(ageInTicks * 0.04f)) * 0.05f;
        this.torso.f_104201_ += breathe;
        float clampedYaw = Mth.m_14036_((float)netHeadYaw, (float)-45.0f, (float)45.0f);
        float clampedPitch = Mth.m_14036_((float)headPitch, (float)-20.0f, (float)20.0f);
        this.head.f_104204_ = clampedYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = clampedPitch * ((float)Math.PI / 180);
        if (entity instanceof PraetorEntity) {
            PraetorEntity praetor = (PraetorEntity)((Object)entity);
            boolean bl = this.mask.f_104207_ = !praetor.isInSecondPhase();
            if (praetor.isRoaring()) {
                this.setupRoarAnim(praetor.getRoarTick(), ageInTicks);
            } else if (praetor.isAttacking() && praetor.getAttackTimeout() > 0) {
                this.setupAttackAnim(praetor.getAttackTimeout(), ageInTicks, praetor.getAttackVariation());
            } else {
                this.left_arm.f_104203_ = -0.35f;
                this.left_arm.f_104205_ = 0.35f;
                this.right_arm.f_104203_ = -0.35f;
                this.right_arm.f_104205_ = -0.35f;
                float armSway = Mth.m_14031_((float)(ageInTicks * 0.05f)) * 0.05f;
                this.left_arm.f_104203_ += armSway;
                this.right_arm.f_104203_ -= armSway;
            }
        } else {
            this.left_arm.f_104203_ = -0.35f;
            this.left_arm.f_104205_ = 0.35f;
            this.right_arm.f_104203_ = -0.35f;
            this.right_arm.f_104205_ = -0.35f;
        }
        if (limbSwingAmount > 0.01f) {
            PraetorEntity praetor;
            float legSwing;
            this.left_leg.f_104203_ = legSwing = Mth.m_14089_((float)(limbSwing * 0.5f)) * 0.5f * limbSwingAmount;
            this.right_leg.f_104203_ = -legSwing;
            if (!(entity instanceof PraetorEntity) || !(praetor = (PraetorEntity)((Object)entity)).isRoaring()) {
                PraetorEntity praetor2;
                float torsoSway;
                this.torso.f_104204_ = torsoSway = Mth.m_14031_((float)(limbSwing * 0.5f)) * limbSwingAmount * 0.1f;
                this.head.f_104204_ += torsoSway * 0.5f;
                if (!(entity instanceof PraetorEntity) || !(praetor2 = (PraetorEntity)((Object)entity)).isAttacking()) {
                    this.left_arm.f_104204_ = torsoSway * 0.3f;
                    this.right_arm.f_104204_ = torsoSway * 0.3f;
                }
            }
        }
    }

    public void setupRoarAnim(int roarTick, float ageInTicks) {
        if (roarTick <= 0) {
            this.roarStartTime = -1.0f;
            this.lastRoarTick = 0;
            return;
        }
        if (roarTick < this.lastRoarTick || this.lastRoarTick == 0 || this.roarStartTime < 0.0f) {
            this.roarStartTime = ageInTicks;
        }
        this.lastRoarTick = roarTick;
        float animProgress = this.getAnimProgress(ageInTicks);
        this.head.f_104203_ = 1.2f * animProgress;
        float armSpread = 0.9f * animProgress;
        this.left_arm.f_104203_ = -0.35f - armSpread * 0.5f;
        this.left_arm.f_104205_ = 0.35f + armSpread;
        this.left_arm.f_104204_ = -armSpread * 0.3f;
        this.right_arm.f_104203_ = -0.35f - armSpread * 0.5f;
        this.right_arm.f_104205_ = -0.35f - armSpread;
        this.right_arm.f_104204_ = armSpread * 0.3f;
        if (animProgress > 0.5f) {
            this.torso.f_104203_ = Mth.m_14031_((float)(ageInTicks * 1.5f)) * 0.05f * animProgress;
        }
    }

    private float getAnimProgress(float ageInTicks) {
        float elapsedTime = ageInTicks - this.roarStartTime;
        float roarProgress = elapsedTime / 40.0f;
        roarProgress = Mth.m_14036_((float)roarProgress, (float)0.0f, (float)1.0f);
        float peakProgress = 0.35f;
        float holdEnd = 0.75f;
        float animProgress = roarProgress < peakProgress ? roarProgress / peakProgress : (roarProgress < holdEnd ? 1.0f : 1.0f - (roarProgress - holdEnd) / (1.0f - holdEnd));
        return animProgress;
    }

    public void setupAttackAnim(int attackTicks, float ageInTicks, int variation) {
        if (attackTicks <= 0) {
            this.attackStartTime = -1.0f;
            this.lastAttackTimeout = 0;
            return;
        }
        if (attackTicks > this.lastAttackTimeout || this.attackStartTime < 0.0f) {
            this.attackStartTime = ageInTicks;
        }
        this.lastAttackTimeout = attackTicks;
        float elapsedTime = ageInTicks - this.attackStartTime;
        float attackProgress = elapsedTime / 8.0f;
        attackProgress = Mth.m_14036_((float)attackProgress, (float)0.0f, (float)1.0f);
        float swingCurve = Mth.m_14031_((float)(attackProgress * (float)Math.PI));
        switch (variation) {
            case 0: {
                this.left_arm.f_104203_ = -0.35f - swingCurve * 1.8f;
                this.left_arm.f_104205_ = 0.35f + swingCurve * 0.5f;
                this.left_arm.f_104204_ = -swingCurve * 0.2f;
                this.right_arm.f_104203_ = -0.35f;
                this.right_arm.f_104205_ = -0.35f;
                break;
            }
            case 1: {
                this.left_arm.f_104203_ = -0.35f;
                this.left_arm.f_104205_ = 0.35f;
                this.right_arm.f_104203_ = -0.35f - swingCurve * 1.8f;
                this.right_arm.f_104205_ = -0.35f - swingCurve * 0.5f;
                this.right_arm.f_104204_ = swingCurve * 0.2f;
                break;
            }
            case 2: {
                this.left_arm.f_104203_ = -0.35f - swingCurve * 1.8f;
                this.left_arm.f_104205_ = 0.35f + swingCurve * 0.5f;
                this.left_arm.f_104204_ = -swingCurve * 0.05f;
                this.right_arm.f_104203_ = -0.35f - swingCurve * 1.8f;
                this.right_arm.f_104205_ = -0.35f - swingCurve * 0.5f;
                this.right_arm.f_104204_ = swingCurve * 0.05f;
            }
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.torso.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.right_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_arm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.right_arm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

