/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.entity.monster.SupplyScampEntity;

public class SupplyScampModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart main;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart cog;
    private final ModelPart tread;
    private final ModelPart[] masks = new ModelPart[16];
    private final PartPose headDefault;
    private final PartPose bodyDefault;
    private final PartPose cogDefault;
    private final PartPose treadDefault;

    public SupplyScampModel(ModelPart root) {
        this.main = root.m_171324_("SupplyScamp");
        this.body = this.main.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.cog = this.body.m_171324_("Cog");
        this.tread = this.main.m_171324_("tread");
        this.headDefault = this.head.m_171308_();
        this.bodyDefault = this.body.m_171308_();
        this.cogDefault = this.cog.m_171308_();
        this.treadDefault = this.tread.m_171308_();
        this.masks[0] = this.head.m_171324_("MaskBlack");
        this.masks[1] = this.head.m_171324_("MaskRed");
        this.masks[2] = this.head.m_171324_("MaskGreen");
        this.masks[3] = this.head.m_171324_("MaskBrown");
        this.masks[4] = this.head.m_171324_("MaskBlue");
        this.masks[5] = this.head.m_171324_("MaskPurple");
        this.masks[6] = this.head.m_171324_("MaskCyan");
        this.masks[7] = this.head.m_171324_("MaskLightGray");
        this.masks[8] = this.head.m_171324_("MaskGray");
        this.masks[9] = this.head.m_171324_("MaskPink");
        this.masks[10] = this.head.m_171324_("MaskLime");
        this.masks[11] = this.head.m_171324_("MaskYellow");
        this.masks[12] = this.head.m_171324_("MaskLightBlue");
        this.masks[13] = this.head.m_171324_("MaskMagenta");
        this.masks[14] = this.head.m_171324_("MaskOrange");
        this.masks[15] = this.head.m_171324_("MaskWhite");
    }

    public void m_6973_(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.m_171322_(this.headDefault);
        this.body.m_171322_(this.bodyDefault);
        this.cog.m_171322_(this.cogDefault);
        this.tread.m_171322_(this.treadDefault);
        if (entity instanceof SupplyScampEntity) {
            SupplyScampEntity supplyScamp = (SupplyScampEntity)((Object)entity);
            for (ModelPart mask : this.masks) {
                mask.f_104207_ = false;
            }
            int maskColor = supplyScamp.getMaskColor();
            if (maskColor >= 0 && maskColor < this.masks.length) {
                this.masks[maskColor].f_104207_ = supplyScamp.m_21824_();
            }
            this.cog.f_104204_ += ageInTicks * 0.15f;
            if (supplyScamp.m_21824_() && supplyScamp.isPartying()) {
                this.animateDancing(ageInTicks);
            } else if (supplyScamp.isSitting()) {
                this.animateSitting(ageInTicks);
            } else if (supplyScamp.isPanicked()) {
                this.animatePanic(limbSwing, limbSwingAmount, ageInTicks);
            } else {
                this.animateMovement(limbSwing, limbSwingAmount, ageInTicks);
            }
        }
    }

    private void animateDancing(float ageInTicks) {
        float danceSpeed = 0.5f;
        float bounce = Mth.m_14154_((float)Mth.m_14031_((float)(ageInTicks * danceSpeed))) * 1.2f;
        this.body.f_104201_ += bounce;
        this.body.f_104205_ = Mth.m_14031_((float)(ageInTicks * danceSpeed)) * 0.15f;
        this.body.f_104203_ = Mth.m_14089_((float)(ageInTicks * danceSpeed * 0.5f)) * 0.08f;
        this.head.f_104203_ = Mth.m_14031_((float)(ageInTicks * danceSpeed * 2.0f)) * 0.15f;
        this.head.f_104204_ = Mth.m_14031_((float)(ageInTicks * danceSpeed * 1.5f)) * 0.2f;
        float treadBounce = Mth.m_14154_((float)Mth.m_14031_((float)(ageInTicks * danceSpeed * 1.5f))) * 0.8f;
        this.tread.f_104201_ += treadBounce;
    }

    private void animateSitting(float ageInTicks) {
        float sitOffset = 2.0f;
        this.body.f_104201_ += sitOffset;
        this.head.f_104202_ = 0.0f;
        float breathe = Mth.m_14031_((float)(ageInTicks * 0.08f)) * 0.3f;
        this.body.f_104201_ += breathe;
    }

    private void animatePanic(float limbSwing, float limbSwingAmount, float ageInTicks) {
        this.head.f_104202_ = 2.0f;
        float shakeSpeed = 0.8f;
        float shakeAmount = 0.3f;
        this.body.f_104203_ = Mth.m_14031_((float)(ageInTicks * shakeSpeed)) * shakeAmount * 0.3f;
        this.body.f_104205_ = Mth.m_14089_((float)(ageInTicks * shakeSpeed * 1.3f)) * shakeAmount * 0.2f;
        this.head.f_104203_ = Mth.m_14031_((float)(ageInTicks * shakeSpeed * 1.5f)) * shakeAmount * 0.15f;
        float bodyBob = Mth.m_14154_((float)Mth.m_14031_((float)(limbSwing * 0.6662f))) * limbSwingAmount * 0.5f;
        this.body.f_104201_ += bodyBob;
        float treadBob = Mth.m_14154_((float)Mth.m_14031_((float)(limbSwing * 0.6662f))) * limbSwingAmount * 0.8f;
        this.tread.f_104201_ += treadBob;
    }

    private void animateMovement(float limbSwing, float limbSwingAmount, float ageInTicks) {
        this.head.f_104204_ = Mth.m_14031_((float)(ageInTicks * 0.1f)) * 0.08f;
        this.head.f_104203_ = Mth.m_14031_((float)(ageInTicks * 0.12f)) * 0.03f;
        float bodyBob = Mth.m_14154_((float)Mth.m_14031_((float)(limbSwing * 0.6662f))) * limbSwingAmount * 0.3f;
        this.body.f_104201_ += bodyBob;
        float treadBob = Mth.m_14154_((float)Mth.m_14031_((float)(limbSwing * 0.6662f))) * limbSwingAmount * 0.8f;
        this.tread.f_104201_ += treadBob;
        this.body.f_104205_ = Mth.m_14031_((float)(limbSwing * 0.6662f)) * limbSwingAmount * 0.08f;
        this.body.f_104203_ = Mth.m_14031_((float)(ageInTicks * 0.08f)) * 0.02f;
        float idleBob = Mth.m_14031_((float)(ageInTicks * 0.08f)) * 0.05f;
        this.body.f_104201_ += idleBob;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition SupplyScamp = partdefinition.m_171599_("SupplyScamp", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition tread = SupplyScamp.m_171599_("tread", CubeListBuilder.m_171558_().m_171514_(48, 69).m_171488_(-8.5f, 7.0f, -7.0f, 1.0f, 3.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(0, 21).m_171488_(-6.5f, 5.0f, -8.0f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(8, 13).m_171488_(4.5f, 5.0f, 7.0f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(10, 0).m_171488_(-6.5f, 5.0f, 7.0f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 40).m_171488_(-7.5f, 6.0f, -7.0f, 16.0f, 5.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(32, 59).m_171488_(8.5f, 7.0f, -7.0f, 1.0f, 3.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(0, 10).m_171488_(4.5f, 5.0f, -8.0f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-11.0f, (float)0.0f));
        PartDefinition body = SupplyScamp.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)3.75f, (float)0.0f));
        PartDefinition body_r1 = body.m_171599_("body_r1", CubeListBuilder.m_171558_().m_171514_(51, 0).m_171488_(-5.0f, -18.5f, -9.0f, 10.0f, 10.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(24, 59).m_171488_(-2.0f, -9.75f, 4.0f, 4.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(64, 69).m_171488_(-8.0f, -15.75f, -7.0f, 1.0f, 3.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(9, 9).m_171488_(-2.0f, -20.75f, -8.0f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(8, 21).m_171488_(5.0f, -15.75f, -8.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 28).m_171488_(-8.0f, -15.75f, -8.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 75).m_171488_(7.0f, -15.75f, -7.0f, 1.0f, 3.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(54, 35).m_171488_(-2.0f, -20.75f, -7.0f, 4.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(74, 35).m_171488_(-2.0f, -17.75f, 4.0f, 4.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(7, 26).m_171488_(-2.0f, -19.75f, 4.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(49, 21).m_171488_(-6.0f, -16.75f, 4.0f, 12.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(49, 48).m_171488_(-7.0f, -19.75f, -7.0f, 14.0f, 10.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(0, 21).m_171488_(-8.0f, -9.75f, -8.0f, 16.0f, 2.0f, 17.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-8.0f, -7.75f, -9.0f, 16.0f, 2.0f, 19.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition body_r2 = body.m_171599_("body_r2", CubeListBuilder.m_171558_().m_171514_(8, 29).m_171488_(6.0f, -15.75f, 6.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-10.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition body_r3 = body.m_171599_("body_r3", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(6.0f, -15.75f, -7.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-10.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition body_r4 = body.m_171599_("body_r4", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -17.75f, 12.0f, 4.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 59).m_171488_(-4.0f, -4.25f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.0f, (float)-17.25f, (float)0.0f));
        PartDefinition MaskBlack = head.m_171599_("MaskBlack", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_r1 = MaskBlack.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(13, 67).m_171488_(-0.2f, -3.75f, -4.0f, 0.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.25f, (float)-0.25f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition MaskPink = head.m_171599_("MaskPink", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_r2 = MaskPink.m_171599_("head_r2", CubeListBuilder.m_171558_().m_171514_(13, 81).m_171488_(-0.2f, -3.75f, -4.0f, 0.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.25f, (float)-0.25f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition MaskPurple = head.m_171599_("MaskPurple", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_r3 = MaskPurple.m_171599_("head_r3", CubeListBuilder.m_171558_().m_171514_(13, 88).m_171488_(-0.2f, -3.75f, -4.0f, 0.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.25f, (float)-0.25f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition MaskBlue = head.m_171599_("MaskBlue", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_r4 = MaskBlue.m_171599_("head_r4", CubeListBuilder.m_171558_().m_171514_(29, 81).m_171488_(-0.2f, -3.75f, -4.0f, 0.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.25f, (float)-0.25f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition MaskRed = head.m_171599_("MaskRed", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_r5 = MaskRed.m_171599_("head_r5", CubeListBuilder.m_171558_().m_171514_(13, 95).m_171488_(-0.2f, -3.75f, -4.0f, 0.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.25f, (float)-0.25f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition MaskMagenta = head.m_171599_("MaskMagenta", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_r6 = MaskMagenta.m_171599_("head_r6", CubeListBuilder.m_171558_().m_171514_(13, 109).m_171488_(-0.2f, -3.75f, -4.0f, 0.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.25f, (float)-0.25f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition MaskGreen = head.m_171599_("MaskGreen", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_r7 = MaskGreen.m_171599_("head_r7", CubeListBuilder.m_171558_().m_171514_(13, 102).m_171488_(-0.2f, -3.75f, -4.0f, 0.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.25f, (float)-0.25f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition MaskLightGreen = head.m_171599_("MaskLime", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_r8 = MaskLightGreen.m_171599_("head_r8", CubeListBuilder.m_171558_().m_171514_(29, 88).m_171488_(-0.2f, -3.75f, -4.0f, 0.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.25f, (float)-0.25f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition MaskBrown = head.m_171599_("MaskBrown", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_r9 = MaskBrown.m_171599_("head_r9", CubeListBuilder.m_171558_().m_171514_(29, 95).m_171488_(-0.2f, -3.75f, -4.0f, 0.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.25f, (float)-0.25f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition MaskGray = head.m_171599_("MaskGray", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_r10 = MaskGray.m_171599_("head_r10", CubeListBuilder.m_171558_().m_171514_(29, 102).m_171488_(-0.2f, -3.75f, -4.0f, 0.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.25f, (float)-0.25f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition MaskLightGray = head.m_171599_("MaskLightGray", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_r11 = MaskLightGray.m_171599_("head_r11", CubeListBuilder.m_171558_().m_171514_(29, 109).m_171488_(-0.2f, -3.75f, -4.0f, 0.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.25f, (float)-0.25f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition MaskYellow = head.m_171599_("MaskYellow", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_r12 = MaskYellow.m_171599_("head_r12", CubeListBuilder.m_171558_().m_171514_(45, 109).m_171488_(-0.2f, -3.75f, -4.0f, 0.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.25f, (float)-0.25f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition MaskCyan = head.m_171599_("MaskCyan", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_r13 = MaskCyan.m_171599_("head_r13", CubeListBuilder.m_171558_().m_171514_(45, 102).m_171488_(-0.2f, -3.75f, -4.0f, 0.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.25f, (float)-0.25f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition MaskLightBlue = head.m_171599_("MaskLightBlue", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_r14 = MaskLightBlue.m_171599_("head_r14", CubeListBuilder.m_171558_().m_171514_(45, 95).m_171488_(-0.2f, -3.75f, -4.0f, 0.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.25f, (float)-0.25f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition MaskWhite = head.m_171599_("MaskWhite", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_r15 = MaskWhite.m_171599_("head_r15", CubeListBuilder.m_171558_().m_171514_(45, 88).m_171488_(-0.2f, -3.75f, -4.0f, 0.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.25f, (float)-0.25f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition MaskOrange = head.m_171599_("MaskOrange", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_r16 = MaskOrange.m_171599_("head_r16", CubeListBuilder.m_171558_().m_171514_(45, 81).m_171488_(-0.2f, -3.75f, -4.0f, 0.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.25f, (float)-0.25f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition Cog = body.m_171599_("Cog", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.0f, (float)-25.96f, (float)0.0f));
        PartDefinition cube_r1 = Cog.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(46, 40).m_171488_(-1.0f, -4.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.06f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)1.5708f));
        PartDefinition cube_r2 = Cog.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171488_(-1.0f, -4.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.06f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)1.5708f));
        PartDefinition cube_r3 = Cog.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(46, 40).m_171488_(-1.0f, -4.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.04f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)1.5708f));
        PartDefinition cube_r4 = Cog.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(6, 33).m_171488_(-1.5f, -1.0f, -1.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 40).m_171488_(-1.0f, -4.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.04f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.main.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.main;
    }
}

